/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GCClient_GetAssemblyBlobRe_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYBLOBRE_BASE_HPP
#define OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYBLOBRE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGCClient_GetAssemblyBlobRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGCClient_GetAssemblyBlobRequest_Base(void);
    // destructor
    virtual ~CGCClient_GetAssemblyBlobRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TAccession;
    typedef int TRelease_id;
    typedef string TMode;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_accession,
        e_release_id,
        e_mode
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// One of accession or release id MUST BE SUPPLIED
    /// Assembly accession or accession.version
    /// (versionless accession is answered with most recent version)
    /// optional
    /// typedef string TAccession
    ///  Check whether the Accession data member has been assigned a value.
    bool IsSetAccession(void) const;
    /// Check whether it is safe or not to call GetAccession method.
    bool CanGetAccession(void) const;
    void ResetAccession(void);
    const TAccession& GetAccession(void) const;
    void SetAccession(const TAccession& value);
    void SetAccession(TAccession&& value);
    TAccession& SetAccession(void);

    /// release ID
    /// optional
    /// typedef int TRelease_id
    ///  Check whether the Release_id data member has been assigned a value.
    bool IsSetRelease_id(void) const;
    /// Check whether it is safe or not to call GetRelease_id method.
    bool CanGetRelease_id(void) const;
    void ResetRelease_id(void);
    TRelease_id GetRelease_id(void) const;
    void SetRelease_id(TRelease_id value);
    TRelease_id& SetRelease_id(void);

    /// mandatory
    /// typedef string TMode
    ///  Check whether the Mode data member has been assigned a value.
    bool IsSetMode(void) const;
    /// Check whether it is safe or not to call GetMode method.
    bool CanGetMode(void) const;
    void ResetMode(void);
    const TMode& GetMode(void) const;
    void SetMode(const TMode& value);
    void SetMode(TMode&& value);
    TMode& SetMode(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGCClient_GetAssemblyBlobRequest_Base(const CGCClient_GetAssemblyBlobRequest_Base&);
    CGCClient_GetAssemblyBlobRequest_Base& operator=(const CGCClient_GetAssemblyBlobRequest_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Accession;
    int m_Release_id;
    string m_Mode;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGCClient_GetAssemblyBlobRequest_Base::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGCClient_GetAssemblyBlobRequest_Base::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CGCClient_GetAssemblyBlobRequest_Base::TAccession& CGCClient_GetAssemblyBlobRequest_Base::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(0);
    }
    return m_Accession;
}

inline
void CGCClient_GetAssemblyBlobRequest_Base::SetAccession(const CGCClient_GetAssemblyBlobRequest_Base::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0x3;
}

inline
void CGCClient_GetAssemblyBlobRequest_Base::SetAccession(CGCClient_GetAssemblyBlobRequest_Base::TAccession&& value)
{
    m_Accession = std::forward<CGCClient_GetAssemblyBlobRequest_Base::TAccession>(value);
    m_set_State[0] |= 0x3;
}

inline
CGCClient_GetAssemblyBlobRequest_Base::TAccession& CGCClient_GetAssemblyBlobRequest_Base::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Accession;
}

inline
bool CGCClient_GetAssemblyBlobRequest_Base::IsSetRelease_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGCClient_GetAssemblyBlobRequest_Base::CanGetRelease_id(void) const
{
    return IsSetRelease_id();
}

inline
void CGCClient_GetAssemblyBlobRequest_Base::ResetRelease_id(void)
{
    m_Release_id = 0;
    m_set_State[0] &= ~0xc;
}

inline
CGCClient_GetAssemblyBlobRequest_Base::TRelease_id CGCClient_GetAssemblyBlobRequest_Base::GetRelease_id(void) const
{
    if (!CanGetRelease_id()) {
        ThrowUnassigned(1);
    }
    return m_Release_id;
}

inline
void CGCClient_GetAssemblyBlobRequest_Base::SetRelease_id(CGCClient_GetAssemblyBlobRequest_Base::TRelease_id value)
{
    m_Release_id = value;
    m_set_State[0] |= 0xc;
}

inline
CGCClient_GetAssemblyBlobRequest_Base::TRelease_id& CGCClient_GetAssemblyBlobRequest_Base::SetRelease_id(void)
{
#ifdef _DEBUG
    if (!IsSetRelease_id()) {
        memset(&m_Release_id,UnassignedByte(),sizeof(m_Release_id));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Release_id;
}

inline
bool CGCClient_GetAssemblyBlobRequest_Base::IsSetMode(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGCClient_GetAssemblyBlobRequest_Base::CanGetMode(void) const
{
    return IsSetMode();
}

inline
const CGCClient_GetAssemblyBlobRequest_Base::TMode& CGCClient_GetAssemblyBlobRequest_Base::GetMode(void) const
{
    if (!CanGetMode()) {
        ThrowUnassigned(2);
    }
    return m_Mode;
}

inline
void CGCClient_GetAssemblyBlobRequest_Base::SetMode(const CGCClient_GetAssemblyBlobRequest_Base::TMode& value)
{
    m_Mode = value;
    m_set_State[0] |= 0x30;
}

inline
void CGCClient_GetAssemblyBlobRequest_Base::SetMode(CGCClient_GetAssemblyBlobRequest_Base::TMode&& value)
{
    m_Mode = std::forward<CGCClient_GetAssemblyBlobRequest_Base::TMode>(value);
    m_set_State[0] |= 0x30;
}

inline
CGCClient_GetAssemblyBlobRequest_Base::TMode& CGCClient_GetAssemblyBlobRequest_Base::SetMode(void)
{
#ifdef _DEBUG
    if (!IsSetMode()) {
        m_Mode = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Mode;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYBLOBRE_BASE_HPP
