/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Person_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'general.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENERAL_PERSON_ID_BASE_HPP
#define OBJECTS_GENERAL_PERSON_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CName_std;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Person-id is to define a std element for people
///
class NCBI_GENERAL_EXPORT CPerson_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPerson_id_Base(void);
    // destructor
    virtual ~CPerson_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Dbtag,        ///< any defined database tag
        e_Name,         ///< structured name
        e_Ml,           ///< MEDLINE name (semi-structured)     eg. "Jones RM"
        e_Str,          ///< unstructured name
        e_Consortium    ///< consortium name
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 6 ///< == e_Consortium+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CDbtag TDbtag;
    typedef CName_std TName;
    typedef string TMl;
    typedef string TStr;
    typedef string TConsortium;

    // getters
    // setters

    // typedef CDbtag TDbtag
    bool IsDbtag(void) const;
    const TDbtag& GetDbtag(void) const;
    TDbtag& SetDbtag(void);
    void SetDbtag(TDbtag& value);

    // typedef CName_std TName
    bool IsName(void) const;
    const TName& GetName(void) const;
    TName& SetName(void);
    void SetName(TName& value);

    // typedef string TMl
    bool IsMl(void) const;
    const TMl& GetMl(void) const;
    TMl& SetMl(void);
    void SetMl(const TMl& value);

    // typedef string TStr
    bool IsStr(void) const;
    const TStr& GetStr(void) const;
    TStr& SetStr(void);
    void SetStr(const TStr& value);

    // typedef string TConsortium
    bool IsConsortium(void) const;
    const TConsortium& GetConsortium(void) const;
    TConsortium& SetConsortium(void);
    void SetConsortium(const TConsortium& value);


private:
    // copy constructor and assignment operator
    CPerson_id_Base(const CPerson_id_Base& );
    CPerson_id_Base& operator=(const CPerson_id_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPerson_id_Base::E_Choice CPerson_id_Base::Which(void) const
{
    return m_choice;
}

inline
void CPerson_id_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPerson_id_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPerson_id_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPerson_id_Base::IsDbtag(void) const
{
    return m_choice == e_Dbtag;
}

inline
bool CPerson_id_Base::IsName(void) const
{
    return m_choice == e_Name;
}

inline
bool CPerson_id_Base::IsMl(void) const
{
    return m_choice == e_Ml;
}

inline
const CPerson_id_Base::TMl& CPerson_id_Base::GetMl(void) const
{
    CheckSelected(e_Ml);
    return *m_string;
}

inline
CPerson_id_Base::TMl& CPerson_id_Base::SetMl(void)
{
    Select(e_Ml, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPerson_id_Base::IsStr(void) const
{
    return m_choice == e_Str;
}

inline
const CPerson_id_Base::TStr& CPerson_id_Base::GetStr(void) const
{
    CheckSelected(e_Str);
    return *m_string;
}

inline
CPerson_id_Base::TStr& CPerson_id_Base::SetStr(void)
{
    Select(e_Str, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPerson_id_Base::IsConsortium(void) const
{
    return m_choice == e_Consortium;
}

inline
const CPerson_id_Base::TConsortium& CPerson_id_Base::GetConsortium(void) const
{
    CheckSelected(e_Consortium);
    return *m_string;
}

inline
CPerson_id_Base::TConsortium& CPerson_id_Base::SetConsortium(void)
{
    Select(e_Consortium, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENERAL_PERSON_ID_BASE_HPP
