/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ProjectFolder_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_PROJECTFOLDER_BASE_HPP
#define OBJECTS_GBPROJ_PROJECTFOLDER_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFolderInfo;
class CProjectFolder;
class CProjectItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CProjectFolder_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CProjectFolder_Base(void);
    // destructor
    virtual ~CProjectFolder_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CFolderInfo TInfo;
    typedef list< CRef< CProjectFolder > > TFolders;
    typedef list< CRef< CProjectItem > > TItems;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_info,
        e_folders,
        e_items
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CFolderInfo TInfo
    ///  Check whether the Info data member has been assigned a value.
    bool IsSetInfo(void) const;
    /// Check whether it is safe or not to call GetInfo method.
    bool CanGetInfo(void) const;
    void ResetInfo(void);
    const TInfo& GetInfo(void) const;
    void SetInfo(TInfo& value);
    TInfo& SetInfo(void);

    /// optional
    /// typedef list< CRef< CProjectFolder > > TFolders
    ///  Check whether the Folders data member has been assigned a value.
    bool IsSetFolders(void) const;
    /// Check whether it is safe or not to call GetFolders method.
    bool CanGetFolders(void) const;
    void ResetFolders(void);
    const TFolders& GetFolders(void) const;
    TFolders& SetFolders(void);

    /// optional
    /// typedef list< CRef< CProjectItem > > TItems
    ///  Check whether the Items data member has been assigned a value.
    bool IsSetItems(void) const;
    /// Check whether it is safe or not to call GetItems method.
    bool CanGetItems(void) const;
    void ResetItems(void);
    const TItems& GetItems(void) const;
    TItems& SetItems(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CProjectFolder_Base(const CProjectFolder_Base&);
    CProjectFolder_Base& operator=(const CProjectFolder_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TInfo > m_Info;
    list< CRef< CProjectFolder > > m_Folders;
    list< CRef< CProjectItem > > m_Items;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CProjectFolder_Base::IsSetInfo(void) const
{
    return m_Info.NotEmpty();
}

inline
bool CProjectFolder_Base::CanGetInfo(void) const
{
    return true;
}

inline
const CProjectFolder_Base::TInfo& CProjectFolder_Base::GetInfo(void) const
{
    if ( !m_Info ) {
        const_cast<CProjectFolder_Base*>(this)->ResetInfo();
    }
    return (*m_Info);
}

inline
CProjectFolder_Base::TInfo& CProjectFolder_Base::SetInfo(void)
{
    if ( !m_Info ) {
        ResetInfo();
    }
    return (*m_Info);
}

inline
bool CProjectFolder_Base::IsSetFolders(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CProjectFolder_Base::CanGetFolders(void) const
{
    return true;
}

inline
const CProjectFolder_Base::TFolders& CProjectFolder_Base::GetFolders(void) const
{
    return m_Folders;
}

inline
CProjectFolder_Base::TFolders& CProjectFolder_Base::SetFolders(void)
{
    m_set_State[0] |= 0x4;
    return m_Folders;
}

inline
bool CProjectFolder_Base::IsSetItems(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CProjectFolder_Base::CanGetItems(void) const
{
    return true;
}

inline
const CProjectFolder_Base::TItems& CProjectFolder_Base::GetItems(void) const
{
    return m_Items;
}

inline
CProjectFolder_Base::TItems& CProjectFolder_Base::SetItems(void)
{
    m_set_State[0] |= 0x10;
    return m_Items;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_PROJECTFOLDER_BASE_HPP
