/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Other_source_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrezgene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZGENE_OTHER_SOURCE_BASE_HPP
#define OBJECTS_ENTREZGENE_OTHER_SOURCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZGENE_EXPORT COther_source_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    COther_source_Base(void);
    // destructor
    virtual ~COther_source_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CDbtag TSrc;
    typedef string TPre_text;
    typedef string TAnchor;
    typedef string TUrl;
    typedef string TPost_text;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_src,
        e_pre_text,
        e_anchor,
        e_url,
        e_post_text
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// key to non-ncbi source 
    /// optional
    /// typedef CDbtag TSrc
    ///  Check whether the Src data member has been assigned a value.
    bool IsSetSrc(void) const;
    /// Check whether it is safe or not to call GetSrc method.
    bool CanGetSrc(void) const;
    void ResetSrc(void);
    const TSrc& GetSrc(void) const;
    void SetSrc(TSrc& value);
    TSrc& SetSrc(void);

    /// text before anchor 
    /// optional
    /// typedef string TPre_text
    ///  Check whether the Pre_text data member has been assigned a value.
    bool IsSetPre_text(void) const;
    /// Check whether it is safe or not to call GetPre_text method.
    bool CanGetPre_text(void) const;
    void ResetPre_text(void);
    const TPre_text& GetPre_text(void) const;
    void SetPre_text(const TPre_text& value);
    void SetPre_text(TPre_text&& value);
    TPre_text& SetPre_text(void);

    /// text to show as highlight 
    /// optional
    /// typedef string TAnchor
    ///  Check whether the Anchor data member has been assigned a value.
    bool IsSetAnchor(void) const;
    /// Check whether it is safe or not to call GetAnchor method.
    bool CanGetAnchor(void) const;
    void ResetAnchor(void);
    const TAnchor& GetAnchor(void) const;
    void SetAnchor(const TAnchor& value);
    void SetAnchor(TAnchor&& value);
    TAnchor& SetAnchor(void);

    /// if present, use this URL not Dbtag and datbase 
    /// optional
    /// typedef string TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(const TUrl& value);
    void SetUrl(TUrl&& value);
    TUrl& SetUrl(void);

    /// text after anchor 
    /// optional
    /// typedef string TPost_text
    ///  Check whether the Post_text data member has been assigned a value.
    bool IsSetPost_text(void) const;
    /// Check whether it is safe or not to call GetPost_text method.
    bool CanGetPost_text(void) const;
    void ResetPost_text(void);
    const TPost_text& GetPost_text(void) const;
    void SetPost_text(const TPost_text& value);
    void SetPost_text(TPost_text&& value);
    TPost_text& SetPost_text(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    COther_source_Base(const COther_source_Base&);
    COther_source_Base& operator=(const COther_source_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSrc > m_Src;
    string m_Pre_text;
    string m_Anchor;
    string m_Url;
    string m_Post_text;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool COther_source_Base::IsSetSrc(void) const
{
    return m_Src.NotEmpty();
}

inline
bool COther_source_Base::CanGetSrc(void) const
{
    return IsSetSrc();
}

inline
const COther_source_Base::TSrc& COther_source_Base::GetSrc(void) const
{
    if (!CanGetSrc()) {
        ThrowUnassigned(0);
    }
    return (*m_Src);
}

inline
bool COther_source_Base::IsSetPre_text(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool COther_source_Base::CanGetPre_text(void) const
{
    return IsSetPre_text();
}

inline
const COther_source_Base::TPre_text& COther_source_Base::GetPre_text(void) const
{
    if (!CanGetPre_text()) {
        ThrowUnassigned(1);
    }
    return m_Pre_text;
}

inline
void COther_source_Base::SetPre_text(const COther_source_Base::TPre_text& value)
{
    m_Pre_text = value;
    m_set_State[0] |= 0xc;
}

inline
void COther_source_Base::SetPre_text(COther_source_Base::TPre_text&& value)
{
    m_Pre_text = std::forward<COther_source_Base::TPre_text>(value);
    m_set_State[0] |= 0xc;
}

inline
COther_source_Base::TPre_text& COther_source_Base::SetPre_text(void)
{
#ifdef _DEBUG
    if (!IsSetPre_text()) {
        m_Pre_text = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Pre_text;
}

inline
bool COther_source_Base::IsSetAnchor(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool COther_source_Base::CanGetAnchor(void) const
{
    return IsSetAnchor();
}

inline
const COther_source_Base::TAnchor& COther_source_Base::GetAnchor(void) const
{
    if (!CanGetAnchor()) {
        ThrowUnassigned(2);
    }
    return m_Anchor;
}

inline
void COther_source_Base::SetAnchor(const COther_source_Base::TAnchor& value)
{
    m_Anchor = value;
    m_set_State[0] |= 0x30;
}

inline
void COther_source_Base::SetAnchor(COther_source_Base::TAnchor&& value)
{
    m_Anchor = std::forward<COther_source_Base::TAnchor>(value);
    m_set_State[0] |= 0x30;
}

inline
COther_source_Base::TAnchor& COther_source_Base::SetAnchor(void)
{
#ifdef _DEBUG
    if (!IsSetAnchor()) {
        m_Anchor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Anchor;
}

inline
bool COther_source_Base::IsSetUrl(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool COther_source_Base::CanGetUrl(void) const
{
    return IsSetUrl();
}

inline
const COther_source_Base::TUrl& COther_source_Base::GetUrl(void) const
{
    if (!CanGetUrl()) {
        ThrowUnassigned(3);
    }
    return m_Url;
}

inline
void COther_source_Base::SetUrl(const COther_source_Base::TUrl& value)
{
    m_Url = value;
    m_set_State[0] |= 0xc0;
}

inline
void COther_source_Base::SetUrl(COther_source_Base::TUrl&& value)
{
    m_Url = std::forward<COther_source_Base::TUrl>(value);
    m_set_State[0] |= 0xc0;
}

inline
COther_source_Base::TUrl& COther_source_Base::SetUrl(void)
{
#ifdef _DEBUG
    if (!IsSetUrl()) {
        m_Url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Url;
}

inline
bool COther_source_Base::IsSetPost_text(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool COther_source_Base::CanGetPost_text(void) const
{
    return IsSetPost_text();
}

inline
const COther_source_Base::TPost_text& COther_source_Base::GetPost_text(void) const
{
    if (!CanGetPost_text()) {
        ThrowUnassigned(4);
    }
    return m_Post_text;
}

inline
void COther_source_Base::SetPost_text(const COther_source_Base::TPost_text& value)
{
    m_Post_text = value;
    m_set_State[0] |= 0x300;
}

inline
void COther_source_Base::SetPost_text(COther_source_Base::TPost_text&& value)
{
    m_Post_text = std::forward<COther_source_Base::TPost_text>(value);
    m_set_State[0] |= 0x300;
}

inline
COther_source_Base::TPost_text& COther_source_Base::SetPost_text(void)
{
#ifdef _DEBUG
    if (!IsSetPost_text()) {
        m_Post_text = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Post_text;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZGENE_OTHER_SOURCE_BASE_HPP
