/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_term_list_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_TERM_LIST_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_TERM_LIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEntrez2_term;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZ2_EXPORT CEntrez2_term_list_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_term_list_Base(void);
    // destructor
    virtual ~CEntrez2_term_list_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TPos;
    typedef int TNum;
    typedef list< CRef< CEntrez2_term > > TList;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_pos,
        e_num,
        e_list
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// position of first term in list
    /// mandatory
    /// typedef int TPos
    ///  Check whether the Pos data member has been assigned a value.
    bool IsSetPos(void) const;
    /// Check whether it is safe or not to call GetPos method.
    bool CanGetPos(void) const;
    void ResetPos(void);
    TPos GetPos(void) const;
    void SetPos(TPos value);
    TPos& SetPos(void);

    /// number of terms in list
    /// mandatory
    /// typedef int TNum
    ///  Check whether the Num data member has been assigned a value.
    bool IsSetNum(void) const;
    /// Check whether it is safe or not to call GetNum method.
    bool CanGetNum(void) const;
    void ResetNum(void);
    TNum GetNum(void) const;
    void SetNum(TNum value);
    TNum& SetNum(void);

    /// mandatory
    /// typedef list< CRef< CEntrez2_term > > TList
    ///  Check whether the List data member has been assigned a value.
    bool IsSetList(void) const;
    /// Check whether it is safe or not to call GetList method.
    bool CanGetList(void) const;
    void ResetList(void);
    const TList& GetList(void) const;
    TList& SetList(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_term_list_Base(const CEntrez2_term_list_Base&);
    CEntrez2_term_list_Base& operator=(const CEntrez2_term_list_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Pos;
    int m_Num;
    list< CRef< CEntrez2_term > > m_List;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_term_list_Base::IsSetPos(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_term_list_Base::CanGetPos(void) const
{
    return IsSetPos();
}

inline
void CEntrez2_term_list_Base::ResetPos(void)
{
    m_Pos = 0;
    m_set_State[0] &= ~0x3;
}

inline
CEntrez2_term_list_Base::TPos CEntrez2_term_list_Base::GetPos(void) const
{
    if (!CanGetPos()) {
        ThrowUnassigned(0);
    }
    return m_Pos;
}

inline
void CEntrez2_term_list_Base::SetPos(CEntrez2_term_list_Base::TPos value)
{
    m_Pos = value;
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_term_list_Base::TPos& CEntrez2_term_list_Base::SetPos(void)
{
#ifdef _DEBUG
    if (!IsSetPos()) {
        memset(&m_Pos,UnassignedByte(),sizeof(m_Pos));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Pos;
}

inline
bool CEntrez2_term_list_Base::IsSetNum(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_term_list_Base::CanGetNum(void) const
{
    return IsSetNum();
}

inline
void CEntrez2_term_list_Base::ResetNum(void)
{
    m_Num = 0;
    m_set_State[0] &= ~0xc;
}

inline
CEntrez2_term_list_Base::TNum CEntrez2_term_list_Base::GetNum(void) const
{
    if (!CanGetNum()) {
        ThrowUnassigned(1);
    }
    return m_Num;
}

inline
void CEntrez2_term_list_Base::SetNum(CEntrez2_term_list_Base::TNum value)
{
    m_Num = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_term_list_Base::TNum& CEntrez2_term_list_Base::SetNum(void)
{
#ifdef _DEBUG
    if (!IsSetNum()) {
        memset(&m_Num,UnassignedByte(),sizeof(m_Num));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Num;
}

inline
bool CEntrez2_term_list_Base::IsSetList(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_term_list_Base::CanGetList(void) const
{
    return true;
}

inline
const CEntrez2_term_list_Base::TList& CEntrez2_term_list_Base::GetList(void) const
{
    return m_List;
}

inline
CEntrez2_term_list_Base::TList& CEntrez2_term_list_Base::SetList(void)
{
    m_set_State[0] |= 0x10;
    return m_List;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_TERM_LIST_BASE_HPP
