/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_eval_boolean_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_EVAL_BOOLEAN_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_EVAL_BOOLEAN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEntrez2_boolean_exp;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///****************************************
/// When evaluating a boolean query the counts of hits is always
///    returned.
/// In addition, you can request the UIDs of the hits or the
///    the parsed query in structured form (with counts by term),
///    or both.
///****************************************
/// evaluate Boolean query
class NCBI_ENTREZ2_EXPORT CEntrez2_eval_boolean_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_eval_boolean_Base(void);
    // destructor
    virtual ~CEntrez2_eval_boolean_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool TReturn_UIDs;
    typedef bool TReturn_parse;
    typedef CEntrez2_boolean_exp TQuery;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_return_UIDs,
        e_return_parse,
        e_query
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// return UID list?
    /// optional with default false
    /// typedef bool TReturn_UIDs
    ///  Check whether the Return_UIDs data member has been assigned a value.
    bool IsSetReturn_UIDs(void) const;
    /// Check whether it is safe or not to call GetReturn_UIDs method.
    bool CanGetReturn_UIDs(void) const;
    void ResetReturn_UIDs(void);
    void SetDefaultReturn_UIDs(void);
    TReturn_UIDs GetReturn_UIDs(void) const;
    void SetReturn_UIDs(TReturn_UIDs value);
    TReturn_UIDs& SetReturn_UIDs(void);

    /// return parsed query?
    /// optional with default false
    /// typedef bool TReturn_parse
    ///  Check whether the Return_parse data member has been assigned a value.
    bool IsSetReturn_parse(void) const;
    /// Check whether it is safe or not to call GetReturn_parse method.
    bool CanGetReturn_parse(void) const;
    void ResetReturn_parse(void);
    void SetDefaultReturn_parse(void);
    TReturn_parse GetReturn_parse(void) const;
    void SetReturn_parse(TReturn_parse value);
    TReturn_parse& SetReturn_parse(void);

    /// the actual query
    /// mandatory
    /// typedef CEntrez2_boolean_exp TQuery
    ///  Check whether the Query data member has been assigned a value.
    bool IsSetQuery(void) const;
    /// Check whether it is safe or not to call GetQuery method.
    bool CanGetQuery(void) const;
    void ResetQuery(void);
    const TQuery& GetQuery(void) const;
    void SetQuery(TQuery& value);
    TQuery& SetQuery(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_eval_boolean_Base(const CEntrez2_eval_boolean_Base&);
    CEntrez2_eval_boolean_Base& operator=(const CEntrez2_eval_boolean_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Return_UIDs;
    bool m_Return_parse;
    CRef< TQuery > m_Query;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_eval_boolean_Base::IsSetReturn_UIDs(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_eval_boolean_Base::CanGetReturn_UIDs(void) const
{
    return true;
}

inline
void CEntrez2_eval_boolean_Base::ResetReturn_UIDs(void)
{
    m_Return_UIDs = false;
    m_set_State[0] &= ~0x3;
}

inline
void CEntrez2_eval_boolean_Base::SetDefaultReturn_UIDs(void)
{
    ResetReturn_UIDs();
}

inline
CEntrez2_eval_boolean_Base::TReturn_UIDs CEntrez2_eval_boolean_Base::GetReturn_UIDs(void) const
{
    return m_Return_UIDs;
}

inline
void CEntrez2_eval_boolean_Base::SetReturn_UIDs(CEntrez2_eval_boolean_Base::TReturn_UIDs value)
{
    m_Return_UIDs = value;
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_eval_boolean_Base::TReturn_UIDs& CEntrez2_eval_boolean_Base::SetReturn_UIDs(void)
{
#ifdef _DEBUG
    if (!IsSetReturn_UIDs()) {
        memset(&m_Return_UIDs,UnassignedByte(),sizeof(m_Return_UIDs));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Return_UIDs;
}

inline
bool CEntrez2_eval_boolean_Base::IsSetReturn_parse(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_eval_boolean_Base::CanGetReturn_parse(void) const
{
    return true;
}

inline
void CEntrez2_eval_boolean_Base::ResetReturn_parse(void)
{
    m_Return_parse = false;
    m_set_State[0] &= ~0xc;
}

inline
void CEntrez2_eval_boolean_Base::SetDefaultReturn_parse(void)
{
    ResetReturn_parse();
}

inline
CEntrez2_eval_boolean_Base::TReturn_parse CEntrez2_eval_boolean_Base::GetReturn_parse(void) const
{
    return m_Return_parse;
}

inline
void CEntrez2_eval_boolean_Base::SetReturn_parse(CEntrez2_eval_boolean_Base::TReturn_parse value)
{
    m_Return_parse = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_eval_boolean_Base::TReturn_parse& CEntrez2_eval_boolean_Base::SetReturn_parse(void)
{
#ifdef _DEBUG
    if (!IsSetReturn_parse()) {
        memset(&m_Return_parse,UnassignedByte(),sizeof(m_Return_parse));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Return_parse;
}

inline
bool CEntrez2_eval_boolean_Base::IsSetQuery(void) const
{
    return m_Query.NotEmpty();
}

inline
bool CEntrez2_eval_boolean_Base::CanGetQuery(void) const
{
    return true;
}

inline
const CEntrez2_eval_boolean_Base::TQuery& CEntrez2_eval_boolean_Base::GetQuery(void) const
{
    if ( !m_Query ) {
        const_cast<CEntrez2_eval_boolean_Base*>(this)->ResetQuery();
    }
    return (*m_Query);
}

inline
CEntrez2_eval_boolean_Base::TQuery& CEntrez2_eval_boolean_Base::SetQuery(void)
{
    if ( !m_Query ) {
        ResetQuery();
    }
    return (*m_Query);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_EVAL_BOOLEAN_BASE_HPP
