/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MapLoc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_MAPLOC_BASE_HPP
#define OBJECTS_DOCSUM_MAPLOC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFxnSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///Position of a single hit of a variation on a
///				contig
class NCBI_DOCSUM_EXPORT CMapLoc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMapLoc_Base(void);
    // destructor
    virtual ~CMapLoc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        ///defines the seq-loc symbol if asn_from !=
        ///						asn_to
        enum EAttlist_locType {
            eAttlist_locType_insertion   = 1,
            eAttlist_locType_exact       = 2,
            eAttlist_locType_deletion    = 3,
            eAttlist_locType_range_ins   = 4,
            eAttlist_locType_range_exact = 5,
            eAttlist_locType_range_del   = 6
        };
        
        /// Access to EAttlist_locType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_locType)(void);
        
        ///orientation of refSNP sequence to contig
        ///						sequence
        enum EAttlist_orient {
            eAttlist_orient_forward = 1,
            eAttlist_orient_reverse = 2
        };
        
        /// Access to EAttlist_orient's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_orient)(void);
        
        // types
        typedef int TAsnFrom;
        typedef int TAsnTo;
        typedef EAttlist_locType TLocType;
        typedef double TAlnQuality;
        typedef EAttlist_orient TOrient;
        typedef int TPhysMapInt;
        typedef int TLeftFlankNeighborPos;
        typedef int TRightFlankNeighborPos;
        typedef int TLeftContigNeighborPos;
        typedef int TRightContigNeighborPos;
        typedef int TNumberOfMismatches;
        typedef int TNumberOfDeletions;
        typedef int TNumberOfInsertions;
        typedef string TRefAllele;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_asnFrom,
            e_asnTo,
            e_locType,
            e_alnQuality,
            e_orient,
            e_physMapInt,
            e_leftFlankNeighborPos,
            e_rightFlankNeighborPos,
            e_leftContigNeighborPos,
            e_rightContigNeighborPos,
            e_numberOfMismatches,
            e_numberOfDeletions,
            e_numberOfInsertions,
            e_refAllele
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 15> TmemberIndex;
    
        // getters
        // setters
    
        ///beginning of variation as feature on
        ///						contig
        /// mandatory
        /// typedef int TAsnFrom
        ///  Check whether the AsnFrom data member has been assigned a value.
        bool IsSetAsnFrom(void) const;
        /// Check whether it is safe or not to call GetAsnFrom method.
        bool CanGetAsnFrom(void) const;
        void ResetAsnFrom(void);
        TAsnFrom GetAsnFrom(void) const;
        void SetAsnFrom(TAsnFrom value);
        TAsnFrom& SetAsnFrom(void);
    
        ///end position of variation as feature on
        ///						contig
        /// mandatory
        /// typedef int TAsnTo
        ///  Check whether the AsnTo data member has been assigned a value.
        bool IsSetAsnTo(void) const;
        /// Check whether it is safe or not to call GetAsnTo method.
        bool CanGetAsnTo(void) const;
        void ResetAsnTo(void);
        TAsnTo GetAsnTo(void) const;
        void SetAsnTo(TAsnTo value);
        TAsnTo& SetAsnTo(void);
    
        /// mandatory
        /// typedef EAttlist_locType TLocType
        ///  Check whether the LocType data member has been assigned a value.
        bool IsSetLocType(void) const;
        /// Check whether it is safe or not to call GetLocType method.
        bool CanGetLocType(void) const;
        void ResetLocType(void);
        TLocType GetLocType(void) const;
        void SetLocType(TLocType value);
        TLocType& SetLocType(void);
    
        ///alignment qualiity
        /// optional
        /// typedef double TAlnQuality
        ///  Check whether the AlnQuality data member has been assigned a value.
        bool IsSetAlnQuality(void) const;
        /// Check whether it is safe or not to call GetAlnQuality method.
        bool CanGetAlnQuality(void) const;
        void ResetAlnQuality(void);
        TAlnQuality GetAlnQuality(void) const;
        void SetAlnQuality(TAlnQuality value);
        TAlnQuality& SetAlnQuality(void);
    
        /// optional
        /// typedef EAttlist_orient TOrient
        ///  Check whether the Orient data member has been assigned a value.
        bool IsSetOrient(void) const;
        /// Check whether it is safe or not to call GetOrient method.
        bool CanGetOrient(void) const;
        void ResetOrient(void);
        TOrient GetOrient(void) const;
        void SetOrient(TOrient value);
        TOrient& SetOrient(void);
    
        ///chromosome position as integer for
        ///						sorting
        /// optional
        /// typedef int TPhysMapInt
        ///  Check whether the PhysMapInt data member has been assigned a value.
        bool IsSetPhysMapInt(void) const;
        /// Check whether it is safe or not to call GetPhysMapInt method.
        bool CanGetPhysMapInt(void) const;
        void ResetPhysMapInt(void);
        TPhysMapInt GetPhysMapInt(void) const;
        void SetPhysMapInt(TPhysMapInt value);
        TPhysMapInt& SetPhysMapInt(void);
    
        ///nearest aligned position in 5' flanking sequence of
        ///						snp
        /// optional
        /// typedef int TLeftFlankNeighborPos
        ///  Check whether the LeftFlankNeighborPos data member has been assigned a value.
        bool IsSetLeftFlankNeighborPos(void) const;
        /// Check whether it is safe or not to call GetLeftFlankNeighborPos method.
        bool CanGetLeftFlankNeighborPos(void) const;
        void ResetLeftFlankNeighborPos(void);
        TLeftFlankNeighborPos GetLeftFlankNeighborPos(void) const;
        void SetLeftFlankNeighborPos(TLeftFlankNeighborPos value);
        TLeftFlankNeighborPos& SetLeftFlankNeighborPos(void);
    
        ///nearest aligned position in 3' flanking sequence of snp
        /// optional
        /// typedef int TRightFlankNeighborPos
        ///  Check whether the RightFlankNeighborPos data member has been assigned a value.
        bool IsSetRightFlankNeighborPos(void) const;
        /// Check whether it is safe or not to call GetRightFlankNeighborPos method.
        bool CanGetRightFlankNeighborPos(void) const;
        void ResetRightFlankNeighborPos(void);
        TRightFlankNeighborPos GetRightFlankNeighborPos(void) const;
        void SetRightFlankNeighborPos(TRightFlankNeighborPos value);
        TRightFlankNeighborPos& SetRightFlankNeighborPos(void);
    
        ///nearest aligned position in 5' contig alignment of
        ///						snp
        /// optional
        /// typedef int TLeftContigNeighborPos
        ///  Check whether the LeftContigNeighborPos data member has been assigned a value.
        bool IsSetLeftContigNeighborPos(void) const;
        /// Check whether it is safe or not to call GetLeftContigNeighborPos method.
        bool CanGetLeftContigNeighborPos(void) const;
        void ResetLeftContigNeighborPos(void);
        TLeftContigNeighborPos GetLeftContigNeighborPos(void) const;
        void SetLeftContigNeighborPos(TLeftContigNeighborPos value);
        TLeftContigNeighborPos& SetLeftContigNeighborPos(void);
    
        ///nearest aligned position in 3' contig alignment of
        ///						snp
        /// optional
        /// typedef int TRightContigNeighborPos
        ///  Check whether the RightContigNeighborPos data member has been assigned a value.
        bool IsSetRightContigNeighborPos(void) const;
        /// Check whether it is safe or not to call GetRightContigNeighborPos method.
        bool CanGetRightContigNeighborPos(void) const;
        void ResetRightContigNeighborPos(void);
        TRightContigNeighborPos GetRightContigNeighborPos(void) const;
        void SetRightContigNeighborPos(TRightContigNeighborPos value);
        TRightContigNeighborPos& SetRightContigNeighborPos(void);
    
        ///number of Mismatched positions in this
        ///						alignment
        /// optional
        /// typedef int TNumberOfMismatches
        ///  Check whether the NumberOfMismatches data member has been assigned a value.
        bool IsSetNumberOfMismatches(void) const;
        /// Check whether it is safe or not to call GetNumberOfMismatches method.
        bool CanGetNumberOfMismatches(void) const;
        void ResetNumberOfMismatches(void);
        TNumberOfMismatches GetNumberOfMismatches(void) const;
        void SetNumberOfMismatches(TNumberOfMismatches value);
        TNumberOfMismatches& SetNumberOfMismatches(void);
    
        ///number of deletions in this alignment
        /// optional
        /// typedef int TNumberOfDeletions
        ///  Check whether the NumberOfDeletions data member has been assigned a value.
        bool IsSetNumberOfDeletions(void) const;
        /// Check whether it is safe or not to call GetNumberOfDeletions method.
        bool CanGetNumberOfDeletions(void) const;
        void ResetNumberOfDeletions(void);
        TNumberOfDeletions GetNumberOfDeletions(void) const;
        void SetNumberOfDeletions(TNumberOfDeletions value);
        TNumberOfDeletions& SetNumberOfDeletions(void);
    
        ///number of insetions in this alignment
        /// optional
        /// typedef int TNumberOfInsertions
        ///  Check whether the NumberOfInsertions data member has been assigned a value.
        bool IsSetNumberOfInsertions(void) const;
        /// Check whether it is safe or not to call GetNumberOfInsertions method.
        bool CanGetNumberOfInsertions(void) const;
        void ResetNumberOfInsertions(void);
        TNumberOfInsertions GetNumberOfInsertions(void) const;
        void SetNumberOfInsertions(TNumberOfInsertions value);
        TNumberOfInsertions& SetNumberOfInsertions(void);
    
        /// optional
        /// typedef string TRefAllele
        ///  Check whether the RefAllele data member has been assigned a value.
        bool IsSetRefAllele(void) const;
        /// Check whether it is safe or not to call GetRefAllele method.
        bool CanGetRefAllele(void) const;
        void ResetRefAllele(void);
        const TRefAllele& GetRefAllele(void) const;
        void SetRefAllele(const TRefAllele& value);
        void SetRefAllele(TRefAllele&& value);
        TRefAllele& SetRefAllele(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        int m_AsnFrom;
        int m_AsnTo;
        EAttlist_locType m_LocType;
        double m_AlnQuality;
        EAttlist_orient m_Orient;
        int m_PhysMapInt;
        int m_LeftFlankNeighborPos;
        int m_RightFlankNeighborPos;
        int m_LeftContigNeighborPos;
        int m_RightContigNeighborPos;
        int m_NumberOfMismatches;
        int m_NumberOfDeletions;
        int m_NumberOfInsertions;
        string m_RefAllele;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef list< CRef< CFxnSet > > TFxnSet;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_fxnSet
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef list< CRef< CFxnSet > > TFxnSet
    ///  Check whether the FxnSet data member has been assigned a value.
    bool IsSetFxnSet(void) const;
    /// Check whether it is safe or not to call GetFxnSet method.
    bool CanGetFxnSet(void) const;
    void ResetFxnSet(void);
    const TFxnSet& GetFxnSet(void) const;
    TFxnSet& SetFxnSet(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMapLoc_Base(const CMapLoc_Base&);
    CMapLoc_Base& operator=(const CMapLoc_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
    list< CRef< CFxnSet > > m_FxnSet;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMapLoc_Base::C_Attlist::IsSetAsnFrom(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetAsnFrom(void) const
{
    return IsSetAsnFrom();
}

inline
void CMapLoc_Base::C_Attlist::ResetAsnFrom(void)
{
    m_AsnFrom = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMapLoc_Base::C_Attlist::TAsnFrom CMapLoc_Base::C_Attlist::GetAsnFrom(void) const
{
    if (!CanGetAsnFrom()) {
        ThrowUnassigned(0);
    }
    return m_AsnFrom;
}

inline
void CMapLoc_Base::C_Attlist::SetAsnFrom(CMapLoc_Base::C_Attlist::TAsnFrom value)
{
    m_AsnFrom = value;
    m_set_State[0] |= 0x3;
}

inline
CMapLoc_Base::C_Attlist::TAsnFrom& CMapLoc_Base::C_Attlist::SetAsnFrom(void)
{
#ifdef _DEBUG
    if (!IsSetAsnFrom()) {
        memset(&m_AsnFrom,UnassignedByte(),sizeof(m_AsnFrom));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_AsnFrom;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetAsnTo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetAsnTo(void) const
{
    return IsSetAsnTo();
}

inline
void CMapLoc_Base::C_Attlist::ResetAsnTo(void)
{
    m_AsnTo = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMapLoc_Base::C_Attlist::TAsnTo CMapLoc_Base::C_Attlist::GetAsnTo(void) const
{
    if (!CanGetAsnTo()) {
        ThrowUnassigned(1);
    }
    return m_AsnTo;
}

inline
void CMapLoc_Base::C_Attlist::SetAsnTo(CMapLoc_Base::C_Attlist::TAsnTo value)
{
    m_AsnTo = value;
    m_set_State[0] |= 0xc;
}

inline
CMapLoc_Base::C_Attlist::TAsnTo& CMapLoc_Base::C_Attlist::SetAsnTo(void)
{
#ifdef _DEBUG
    if (!IsSetAsnTo()) {
        memset(&m_AsnTo,UnassignedByte(),sizeof(m_AsnTo));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_AsnTo;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetLocType(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetLocType(void) const
{
    return IsSetLocType();
}

inline
void CMapLoc_Base::C_Attlist::ResetLocType(void)
{
    m_LocType = (EAttlist_locType)(0);
    m_set_State[0] &= ~0x30;
}

inline
CMapLoc_Base::C_Attlist::TLocType CMapLoc_Base::C_Attlist::GetLocType(void) const
{
    if (!CanGetLocType()) {
        ThrowUnassigned(2);
    }
    return m_LocType;
}

inline
void CMapLoc_Base::C_Attlist::SetLocType(CMapLoc_Base::C_Attlist::TLocType value)
{
    m_LocType = value;
    m_set_State[0] |= 0x30;
}

inline
CMapLoc_Base::C_Attlist::TLocType& CMapLoc_Base::C_Attlist::SetLocType(void)
{
#ifdef _DEBUG
    if (!IsSetLocType()) {
        memset(&m_LocType,UnassignedByte(),sizeof(m_LocType));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_LocType;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetAlnQuality(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetAlnQuality(void) const
{
    return IsSetAlnQuality();
}

inline
void CMapLoc_Base::C_Attlist::ResetAlnQuality(void)
{
    m_AlnQuality = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CMapLoc_Base::C_Attlist::TAlnQuality CMapLoc_Base::C_Attlist::GetAlnQuality(void) const
{
    if (!CanGetAlnQuality()) {
        ThrowUnassigned(3);
    }
    return m_AlnQuality;
}

inline
void CMapLoc_Base::C_Attlist::SetAlnQuality(CMapLoc_Base::C_Attlist::TAlnQuality value)
{
    m_AlnQuality = value;
    m_set_State[0] |= 0xc0;
}

inline
CMapLoc_Base::C_Attlist::TAlnQuality& CMapLoc_Base::C_Attlist::SetAlnQuality(void)
{
#ifdef _DEBUG
    if (!IsSetAlnQuality()) {
        memset(&m_AlnQuality,UnassignedByte(),sizeof(m_AlnQuality));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_AlnQuality;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetOrient(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetOrient(void) const
{
    return IsSetOrient();
}

inline
void CMapLoc_Base::C_Attlist::ResetOrient(void)
{
    m_Orient = (EAttlist_orient)(0);
    m_set_State[0] &= ~0x300;
}

inline
CMapLoc_Base::C_Attlist::TOrient CMapLoc_Base::C_Attlist::GetOrient(void) const
{
    if (!CanGetOrient()) {
        ThrowUnassigned(4);
    }
    return m_Orient;
}

inline
void CMapLoc_Base::C_Attlist::SetOrient(CMapLoc_Base::C_Attlist::TOrient value)
{
    m_Orient = value;
    m_set_State[0] |= 0x300;
}

inline
CMapLoc_Base::C_Attlist::TOrient& CMapLoc_Base::C_Attlist::SetOrient(void)
{
#ifdef _DEBUG
    if (!IsSetOrient()) {
        memset(&m_Orient,UnassignedByte(),sizeof(m_Orient));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Orient;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetPhysMapInt(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetPhysMapInt(void) const
{
    return IsSetPhysMapInt();
}

inline
void CMapLoc_Base::C_Attlist::ResetPhysMapInt(void)
{
    m_PhysMapInt = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CMapLoc_Base::C_Attlist::TPhysMapInt CMapLoc_Base::C_Attlist::GetPhysMapInt(void) const
{
    if (!CanGetPhysMapInt()) {
        ThrowUnassigned(5);
    }
    return m_PhysMapInt;
}

inline
void CMapLoc_Base::C_Attlist::SetPhysMapInt(CMapLoc_Base::C_Attlist::TPhysMapInt value)
{
    m_PhysMapInt = value;
    m_set_State[0] |= 0xc00;
}

inline
CMapLoc_Base::C_Attlist::TPhysMapInt& CMapLoc_Base::C_Attlist::SetPhysMapInt(void)
{
#ifdef _DEBUG
    if (!IsSetPhysMapInt()) {
        memset(&m_PhysMapInt,UnassignedByte(),sizeof(m_PhysMapInt));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_PhysMapInt;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetLeftFlankNeighborPos(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetLeftFlankNeighborPos(void) const
{
    return IsSetLeftFlankNeighborPos();
}

inline
void CMapLoc_Base::C_Attlist::ResetLeftFlankNeighborPos(void)
{
    m_LeftFlankNeighborPos = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CMapLoc_Base::C_Attlist::TLeftFlankNeighborPos CMapLoc_Base::C_Attlist::GetLeftFlankNeighborPos(void) const
{
    if (!CanGetLeftFlankNeighborPos()) {
        ThrowUnassigned(6);
    }
    return m_LeftFlankNeighborPos;
}

inline
void CMapLoc_Base::C_Attlist::SetLeftFlankNeighborPos(CMapLoc_Base::C_Attlist::TLeftFlankNeighborPos value)
{
    m_LeftFlankNeighborPos = value;
    m_set_State[0] |= 0x3000;
}

inline
CMapLoc_Base::C_Attlist::TLeftFlankNeighborPos& CMapLoc_Base::C_Attlist::SetLeftFlankNeighborPos(void)
{
#ifdef _DEBUG
    if (!IsSetLeftFlankNeighborPos()) {
        memset(&m_LeftFlankNeighborPos,UnassignedByte(),sizeof(m_LeftFlankNeighborPos));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_LeftFlankNeighborPos;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetRightFlankNeighborPos(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetRightFlankNeighborPos(void) const
{
    return IsSetRightFlankNeighborPos();
}

inline
void CMapLoc_Base::C_Attlist::ResetRightFlankNeighborPos(void)
{
    m_RightFlankNeighborPos = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CMapLoc_Base::C_Attlist::TRightFlankNeighborPos CMapLoc_Base::C_Attlist::GetRightFlankNeighborPos(void) const
{
    if (!CanGetRightFlankNeighborPos()) {
        ThrowUnassigned(7);
    }
    return m_RightFlankNeighborPos;
}

inline
void CMapLoc_Base::C_Attlist::SetRightFlankNeighborPos(CMapLoc_Base::C_Attlist::TRightFlankNeighborPos value)
{
    m_RightFlankNeighborPos = value;
    m_set_State[0] |= 0xc000;
}

inline
CMapLoc_Base::C_Attlist::TRightFlankNeighborPos& CMapLoc_Base::C_Attlist::SetRightFlankNeighborPos(void)
{
#ifdef _DEBUG
    if (!IsSetRightFlankNeighborPos()) {
        memset(&m_RightFlankNeighborPos,UnassignedByte(),sizeof(m_RightFlankNeighborPos));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_RightFlankNeighborPos;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetLeftContigNeighborPos(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetLeftContigNeighborPos(void) const
{
    return IsSetLeftContigNeighborPos();
}

inline
void CMapLoc_Base::C_Attlist::ResetLeftContigNeighborPos(void)
{
    m_LeftContigNeighborPos = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CMapLoc_Base::C_Attlist::TLeftContigNeighborPos CMapLoc_Base::C_Attlist::GetLeftContigNeighborPos(void) const
{
    if (!CanGetLeftContigNeighborPos()) {
        ThrowUnassigned(8);
    }
    return m_LeftContigNeighborPos;
}

inline
void CMapLoc_Base::C_Attlist::SetLeftContigNeighborPos(CMapLoc_Base::C_Attlist::TLeftContigNeighborPos value)
{
    m_LeftContigNeighborPos = value;
    m_set_State[0] |= 0x30000;
}

inline
CMapLoc_Base::C_Attlist::TLeftContigNeighborPos& CMapLoc_Base::C_Attlist::SetLeftContigNeighborPos(void)
{
#ifdef _DEBUG
    if (!IsSetLeftContigNeighborPos()) {
        memset(&m_LeftContigNeighborPos,UnassignedByte(),sizeof(m_LeftContigNeighborPos));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_LeftContigNeighborPos;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetRightContigNeighborPos(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetRightContigNeighborPos(void) const
{
    return IsSetRightContigNeighborPos();
}

inline
void CMapLoc_Base::C_Attlist::ResetRightContigNeighborPos(void)
{
    m_RightContigNeighborPos = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CMapLoc_Base::C_Attlist::TRightContigNeighborPos CMapLoc_Base::C_Attlist::GetRightContigNeighborPos(void) const
{
    if (!CanGetRightContigNeighborPos()) {
        ThrowUnassigned(9);
    }
    return m_RightContigNeighborPos;
}

inline
void CMapLoc_Base::C_Attlist::SetRightContigNeighborPos(CMapLoc_Base::C_Attlist::TRightContigNeighborPos value)
{
    m_RightContigNeighborPos = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMapLoc_Base::C_Attlist::TRightContigNeighborPos& CMapLoc_Base::C_Attlist::SetRightContigNeighborPos(void)
{
#ifdef _DEBUG
    if (!IsSetRightContigNeighborPos()) {
        memset(&m_RightContigNeighborPos,UnassignedByte(),sizeof(m_RightContigNeighborPos));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_RightContigNeighborPos;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetNumberOfMismatches(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetNumberOfMismatches(void) const
{
    return IsSetNumberOfMismatches();
}

inline
void CMapLoc_Base::C_Attlist::ResetNumberOfMismatches(void)
{
    m_NumberOfMismatches = 0;
    m_set_State[0] &= ~0x300000;
}

inline
CMapLoc_Base::C_Attlist::TNumberOfMismatches CMapLoc_Base::C_Attlist::GetNumberOfMismatches(void) const
{
    if (!CanGetNumberOfMismatches()) {
        ThrowUnassigned(10);
    }
    return m_NumberOfMismatches;
}

inline
void CMapLoc_Base::C_Attlist::SetNumberOfMismatches(CMapLoc_Base::C_Attlist::TNumberOfMismatches value)
{
    m_NumberOfMismatches = value;
    m_set_State[0] |= 0x300000;
}

inline
CMapLoc_Base::C_Attlist::TNumberOfMismatches& CMapLoc_Base::C_Attlist::SetNumberOfMismatches(void)
{
#ifdef _DEBUG
    if (!IsSetNumberOfMismatches()) {
        memset(&m_NumberOfMismatches,UnassignedByte(),sizeof(m_NumberOfMismatches));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_NumberOfMismatches;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetNumberOfDeletions(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetNumberOfDeletions(void) const
{
    return IsSetNumberOfDeletions();
}

inline
void CMapLoc_Base::C_Attlist::ResetNumberOfDeletions(void)
{
    m_NumberOfDeletions = 0;
    m_set_State[0] &= ~0xc00000;
}

inline
CMapLoc_Base::C_Attlist::TNumberOfDeletions CMapLoc_Base::C_Attlist::GetNumberOfDeletions(void) const
{
    if (!CanGetNumberOfDeletions()) {
        ThrowUnassigned(11);
    }
    return m_NumberOfDeletions;
}

inline
void CMapLoc_Base::C_Attlist::SetNumberOfDeletions(CMapLoc_Base::C_Attlist::TNumberOfDeletions value)
{
    m_NumberOfDeletions = value;
    m_set_State[0] |= 0xc00000;
}

inline
CMapLoc_Base::C_Attlist::TNumberOfDeletions& CMapLoc_Base::C_Attlist::SetNumberOfDeletions(void)
{
#ifdef _DEBUG
    if (!IsSetNumberOfDeletions()) {
        memset(&m_NumberOfDeletions,UnassignedByte(),sizeof(m_NumberOfDeletions));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_NumberOfDeletions;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetNumberOfInsertions(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetNumberOfInsertions(void) const
{
    return IsSetNumberOfInsertions();
}

inline
void CMapLoc_Base::C_Attlist::ResetNumberOfInsertions(void)
{
    m_NumberOfInsertions = 0;
    m_set_State[0] &= ~0x3000000;
}

inline
CMapLoc_Base::C_Attlist::TNumberOfInsertions CMapLoc_Base::C_Attlist::GetNumberOfInsertions(void) const
{
    if (!CanGetNumberOfInsertions()) {
        ThrowUnassigned(12);
    }
    return m_NumberOfInsertions;
}

inline
void CMapLoc_Base::C_Attlist::SetNumberOfInsertions(CMapLoc_Base::C_Attlist::TNumberOfInsertions value)
{
    m_NumberOfInsertions = value;
    m_set_State[0] |= 0x3000000;
}

inline
CMapLoc_Base::C_Attlist::TNumberOfInsertions& CMapLoc_Base::C_Attlist::SetNumberOfInsertions(void)
{
#ifdef _DEBUG
    if (!IsSetNumberOfInsertions()) {
        memset(&m_NumberOfInsertions,UnassignedByte(),sizeof(m_NumberOfInsertions));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_NumberOfInsertions;
}

inline
bool CMapLoc_Base::C_Attlist::IsSetRefAllele(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMapLoc_Base::C_Attlist::CanGetRefAllele(void) const
{
    return IsSetRefAllele();
}

inline
const CMapLoc_Base::C_Attlist::TRefAllele& CMapLoc_Base::C_Attlist::GetRefAllele(void) const
{
    if (!CanGetRefAllele()) {
        ThrowUnassigned(13);
    }
    return m_RefAllele;
}

inline
void CMapLoc_Base::C_Attlist::SetRefAllele(const CMapLoc_Base::C_Attlist::TRefAllele& value)
{
    m_RefAllele = value;
    m_set_State[0] |= 0xc000000;
}

inline
void CMapLoc_Base::C_Attlist::SetRefAllele(CMapLoc_Base::C_Attlist::TRefAllele&& value)
{
    m_RefAllele = std::forward<CMapLoc_Base::C_Attlist::TRefAllele>(value);
    m_set_State[0] |= 0xc000000;
}

inline
CMapLoc_Base::C_Attlist::TRefAllele& CMapLoc_Base::C_Attlist::SetRefAllele(void)
{
#ifdef _DEBUG
    if (!IsSetRefAllele()) {
        m_RefAllele = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_RefAllele;
}

inline
bool CMapLoc_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMapLoc_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMapLoc_Base::TAttlist& CMapLoc_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMapLoc_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMapLoc_Base::TAttlist& CMapLoc_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMapLoc_Base::IsSetFxnSet(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMapLoc_Base::CanGetFxnSet(void) const
{
    return true;
}

inline
const CMapLoc_Base::TFxnSet& CMapLoc_Base::GetFxnSet(void) const
{
    return m_FxnSet;
}

inline
CMapLoc_Base::TFxnSet& CMapLoc_Base::SetFxnSet(void)
{
    m_set_State[0] |= 0x4;
    return m_FxnSet;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_MAPLOC_BASE_HPP
