/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Component_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_COMPONENT_BASE_HPP
#define OBJECTS_DOCSUM_COMPONENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMapLoc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_DOCSUM_EXPORT CComponent_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CComponent_Base(void);
    // destructor
    virtual ~CComponent_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        ///type of component: chromosome, contig, gene_region,
        ///						etc.
        enum EAttlist_componentType {
            eAttlist_componentType_contig = 1,
            eAttlist_componentType_mrna   = 2
        };
        
        /// Access to EAttlist_componentType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_componentType)(void);
        
        ///orientation of this component to chromosome, forward (fwd) =
        ///						0, reverse (rev) = 1, unknown = NULL in
        ///						ContigInfo.orient.
        enum EAttlist_orientation {
            eAttlist_orientation_fwd     = 1,
            eAttlist_orientation_rev     = 2,
            eAttlist_orientation_unknown = 3
        };
        
        /// Access to EAttlist_orientation's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_orientation)(void);
        
        // types
        typedef EAttlist_componentType TComponentType;
        typedef int TCtgId;
        typedef string TAccession;
        typedef string TName;
        typedef string TChromosome;
        typedef int TStart;
        typedef int TEnd;
        typedef EAttlist_orientation TOrientation;
        typedef string TGi;
        typedef string TGroupTerm;
        typedef string TContigLabel;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_componentType,
            e_ctgId,
            e_accession,
            e_name,
            e_chromosome,
            e_start,
            e_end,
            e_orientation,
            e_gi,
            e_groupTerm,
            e_contigLabel
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 12> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef EAttlist_componentType TComponentType
        ///  Check whether the ComponentType data member has been assigned a value.
        bool IsSetComponentType(void) const;
        /// Check whether it is safe or not to call GetComponentType method.
        bool CanGetComponentType(void) const;
        void ResetComponentType(void);
        TComponentType GetComponentType(void) const;
        void SetComponentType(TComponentType value);
        TComponentType& SetComponentType(void);
    
        ///dbSNP contig_id used to join on contig hit / mapset data to
        ///						these assembly properties
        /// optional
        /// typedef int TCtgId
        ///  Check whether the CtgId data member has been assigned a value.
        bool IsSetCtgId(void) const;
        /// Check whether it is safe or not to call GetCtgId method.
        bool CanGetCtgId(void) const;
        void ResetCtgId(void);
        TCtgId GetCtgId(void) const;
        void SetCtgId(TCtgId value);
        TCtgId& SetCtgId(void);
    
        ///Accession[.version] for the sequence
        ///						component
        /// optional
        /// typedef string TAccession
        ///  Check whether the Accession data member has been assigned a value.
        bool IsSetAccession(void) const;
        /// Check whether it is safe or not to call GetAccession method.
        bool CanGetAccession(void) const;
        void ResetAccession(void);
        const TAccession& GetAccession(void) const;
        void SetAccession(const TAccession& value);
        void SetAccession(TAccession&& value);
        TAccession& SetAccession(void);
    
        ///contig name defined as either a submitter local id, element
        ///						of a whole genome assembly set, or internal NCBI local
        ///						id
        /// optional
        /// typedef string TName
        ///  Check whether the Name data member has been assigned a value.
        bool IsSetName(void) const;
        /// Check whether it is safe or not to call GetName method.
        bool CanGetName(void) const;
        void ResetName(void);
        const TName& GetName(void) const;
        void SetName(const TName& value);
        void SetName(TName&& value);
        TName& SetName(void);
    
        ///Organism appropriate chromosome tag, 'Un' reserved for
        ///						default case of unplaced components
        /// optional
        /// typedef string TChromosome
        ///  Check whether the Chromosome data member has been assigned a value.
        bool IsSetChromosome(void) const;
        /// Check whether it is safe or not to call GetChromosome method.
        bool CanGetChromosome(void) const;
        void ResetChromosome(void);
        const TChromosome& GetChromosome(void) const;
        void SetChromosome(const TChromosome& value);
        void SetChromosome(TChromosome&& value);
        TChromosome& SetChromosome(void);
    
        ///component starting position on the chromosome (base 0
        ///						inclusive)
        /// optional
        /// typedef int TStart
        ///  Check whether the Start data member has been assigned a value.
        bool IsSetStart(void) const;
        /// Check whether it is safe or not to call GetStart method.
        bool CanGetStart(void) const;
        void ResetStart(void);
        TStart GetStart(void) const;
        void SetStart(TStart value);
        TStart& SetStart(void);
    
        ///component ending position on the chromosome (base 0
        ///						inclusive)
        /// optional
        /// typedef int TEnd
        ///  Check whether the End data member has been assigned a value.
        bool IsSetEnd(void) const;
        /// Check whether it is safe or not to call GetEnd method.
        bool CanGetEnd(void) const;
        void ResetEnd(void);
        TEnd GetEnd(void) const;
        void SetEnd(TEnd value);
        TEnd& SetEnd(void);
    
        /// optional
        /// typedef EAttlist_orientation TOrientation
        ///  Check whether the Orientation data member has been assigned a value.
        bool IsSetOrientation(void) const;
        /// Check whether it is safe or not to call GetOrientation method.
        bool CanGetOrientation(void) const;
        void ResetOrientation(void);
        TOrientation GetOrientation(void) const;
        void SetOrientation(TOrientation value);
        TOrientation& SetOrientation(void);
    
        ///NCBI gi for component sequence (equivalent to
        ///						accession.version) for nucleotide sequence.
        /// optional
        /// typedef string TGi
        ///  Check whether the Gi data member has been assigned a value.
        bool IsSetGi(void) const;
        /// Check whether it is safe or not to call GetGi method.
        bool CanGetGi(void) const;
        void ResetGi(void);
        const TGi& GetGi(void) const;
        void SetGi(const TGi& value);
        void SetGi(TGi&& value);
        TGi& SetGi(void);
    
        ///Identifier label for the genome assembly that defines the
        ///						contigs in this mapset and their placement within the organism genome.
        /// optional
        /// typedef string TGroupTerm
        ///  Check whether the GroupTerm data member has been assigned a value.
        bool IsSetGroupTerm(void) const;
        /// Check whether it is safe or not to call GetGroupTerm method.
        bool CanGetGroupTerm(void) const;
        void ResetGroupTerm(void);
        const TGroupTerm& GetGroupTerm(void) const;
        void SetGroupTerm(const TGroupTerm& value);
        void SetGroupTerm(TGroupTerm&& value);
        TGroupTerm& SetGroupTerm(void);
    
        ///Display label for component
        /// optional
        /// typedef string TContigLabel
        ///  Check whether the ContigLabel data member has been assigned a value.
        bool IsSetContigLabel(void) const;
        /// Check whether it is safe or not to call GetContigLabel method.
        bool CanGetContigLabel(void) const;
        void ResetContigLabel(void);
        const TContigLabel& GetContigLabel(void) const;
        void SetContigLabel(const TContigLabel& value);
        void SetContigLabel(TContigLabel&& value);
        TContigLabel& SetContigLabel(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_componentType m_ComponentType;
        int m_CtgId;
        string m_Accession;
        string m_Name;
        string m_Chromosome;
        int m_Start;
        int m_End;
        EAttlist_orientation m_Orientation;
        string m_Gi;
        string m_GroupTerm;
        string m_ContigLabel;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef list< CRef< CMapLoc > > TMapLoc;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_mapLoc
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef list< CRef< CMapLoc > > TMapLoc
    ///  Check whether the MapLoc data member has been assigned a value.
    bool IsSetMapLoc(void) const;
    /// Check whether it is safe or not to call GetMapLoc method.
    bool CanGetMapLoc(void) const;
    void ResetMapLoc(void);
    const TMapLoc& GetMapLoc(void) const;
    TMapLoc& SetMapLoc(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CComponent_Base(const CComponent_Base&);
    CComponent_Base& operator=(const CComponent_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
    list< CRef< CMapLoc > > m_MapLoc;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CComponent_Base::C_Attlist::IsSetComponentType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetComponentType(void) const
{
    return IsSetComponentType();
}

inline
void CComponent_Base::C_Attlist::ResetComponentType(void)
{
    m_ComponentType = (EAttlist_componentType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CComponent_Base::C_Attlist::TComponentType CComponent_Base::C_Attlist::GetComponentType(void) const
{
    if (!CanGetComponentType()) {
        ThrowUnassigned(0);
    }
    return m_ComponentType;
}

inline
void CComponent_Base::C_Attlist::SetComponentType(CComponent_Base::C_Attlist::TComponentType value)
{
    m_ComponentType = value;
    m_set_State[0] |= 0x3;
}

inline
CComponent_Base::C_Attlist::TComponentType& CComponent_Base::C_Attlist::SetComponentType(void)
{
#ifdef _DEBUG
    if (!IsSetComponentType()) {
        memset(&m_ComponentType,UnassignedByte(),sizeof(m_ComponentType));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_ComponentType;
}

inline
bool CComponent_Base::C_Attlist::IsSetCtgId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetCtgId(void) const
{
    return IsSetCtgId();
}

inline
void CComponent_Base::C_Attlist::ResetCtgId(void)
{
    m_CtgId = 0;
    m_set_State[0] &= ~0xc;
}

inline
CComponent_Base::C_Attlist::TCtgId CComponent_Base::C_Attlist::GetCtgId(void) const
{
    if (!CanGetCtgId()) {
        ThrowUnassigned(1);
    }
    return m_CtgId;
}

inline
void CComponent_Base::C_Attlist::SetCtgId(CComponent_Base::C_Attlist::TCtgId value)
{
    m_CtgId = value;
    m_set_State[0] |= 0xc;
}

inline
CComponent_Base::C_Attlist::TCtgId& CComponent_Base::C_Attlist::SetCtgId(void)
{
#ifdef _DEBUG
    if (!IsSetCtgId()) {
        memset(&m_CtgId,UnassignedByte(),sizeof(m_CtgId));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_CtgId;
}

inline
bool CComponent_Base::C_Attlist::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CComponent_Base::C_Attlist::TAccession& CComponent_Base::C_Attlist::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(2);
    }
    return m_Accession;
}

inline
void CComponent_Base::C_Attlist::SetAccession(const CComponent_Base::C_Attlist::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0x30;
}

inline
void CComponent_Base::C_Attlist::SetAccession(CComponent_Base::C_Attlist::TAccession&& value)
{
    m_Accession = std::forward<CComponent_Base::C_Attlist::TAccession>(value);
    m_set_State[0] |= 0x30;
}

inline
CComponent_Base::C_Attlist::TAccession& CComponent_Base::C_Attlist::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Accession;
}

inline
bool CComponent_Base::C_Attlist::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetName(void) const
{
    return IsSetName();
}

inline
const CComponent_Base::C_Attlist::TName& CComponent_Base::C_Attlist::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(3);
    }
    return m_Name;
}

inline
void CComponent_Base::C_Attlist::SetName(const CComponent_Base::C_Attlist::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc0;
}

inline
void CComponent_Base::C_Attlist::SetName(CComponent_Base::C_Attlist::TName&& value)
{
    m_Name = std::forward<CComponent_Base::C_Attlist::TName>(value);
    m_set_State[0] |= 0xc0;
}

inline
CComponent_Base::C_Attlist::TName& CComponent_Base::C_Attlist::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Name;
}

inline
bool CComponent_Base::C_Attlist::IsSetChromosome(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetChromosome(void) const
{
    return IsSetChromosome();
}

inline
const CComponent_Base::C_Attlist::TChromosome& CComponent_Base::C_Attlist::GetChromosome(void) const
{
    if (!CanGetChromosome()) {
        ThrowUnassigned(4);
    }
    return m_Chromosome;
}

inline
void CComponent_Base::C_Attlist::SetChromosome(const CComponent_Base::C_Attlist::TChromosome& value)
{
    m_Chromosome = value;
    m_set_State[0] |= 0x300;
}

inline
void CComponent_Base::C_Attlist::SetChromosome(CComponent_Base::C_Attlist::TChromosome&& value)
{
    m_Chromosome = std::forward<CComponent_Base::C_Attlist::TChromosome>(value);
    m_set_State[0] |= 0x300;
}

inline
CComponent_Base::C_Attlist::TChromosome& CComponent_Base::C_Attlist::SetChromosome(void)
{
#ifdef _DEBUG
    if (!IsSetChromosome()) {
        m_Chromosome = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Chromosome;
}

inline
bool CComponent_Base::C_Attlist::IsSetStart(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetStart(void) const
{
    return IsSetStart();
}

inline
void CComponent_Base::C_Attlist::ResetStart(void)
{
    m_Start = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CComponent_Base::C_Attlist::TStart CComponent_Base::C_Attlist::GetStart(void) const
{
    if (!CanGetStart()) {
        ThrowUnassigned(5);
    }
    return m_Start;
}

inline
void CComponent_Base::C_Attlist::SetStart(CComponent_Base::C_Attlist::TStart value)
{
    m_Start = value;
    m_set_State[0] |= 0xc00;
}

inline
CComponent_Base::C_Attlist::TStart& CComponent_Base::C_Attlist::SetStart(void)
{
#ifdef _DEBUG
    if (!IsSetStart()) {
        memset(&m_Start,UnassignedByte(),sizeof(m_Start));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Start;
}

inline
bool CComponent_Base::C_Attlist::IsSetEnd(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetEnd(void) const
{
    return IsSetEnd();
}

inline
void CComponent_Base::C_Attlist::ResetEnd(void)
{
    m_End = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CComponent_Base::C_Attlist::TEnd CComponent_Base::C_Attlist::GetEnd(void) const
{
    if (!CanGetEnd()) {
        ThrowUnassigned(6);
    }
    return m_End;
}

inline
void CComponent_Base::C_Attlist::SetEnd(CComponent_Base::C_Attlist::TEnd value)
{
    m_End = value;
    m_set_State[0] |= 0x3000;
}

inline
CComponent_Base::C_Attlist::TEnd& CComponent_Base::C_Attlist::SetEnd(void)
{
#ifdef _DEBUG
    if (!IsSetEnd()) {
        memset(&m_End,UnassignedByte(),sizeof(m_End));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_End;
}

inline
bool CComponent_Base::C_Attlist::IsSetOrientation(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetOrientation(void) const
{
    return IsSetOrientation();
}

inline
void CComponent_Base::C_Attlist::ResetOrientation(void)
{
    m_Orientation = (EAttlist_orientation)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CComponent_Base::C_Attlist::TOrientation CComponent_Base::C_Attlist::GetOrientation(void) const
{
    if (!CanGetOrientation()) {
        ThrowUnassigned(7);
    }
    return m_Orientation;
}

inline
void CComponent_Base::C_Attlist::SetOrientation(CComponent_Base::C_Attlist::TOrientation value)
{
    m_Orientation = value;
    m_set_State[0] |= 0xc000;
}

inline
CComponent_Base::C_Attlist::TOrientation& CComponent_Base::C_Attlist::SetOrientation(void)
{
#ifdef _DEBUG
    if (!IsSetOrientation()) {
        memset(&m_Orientation,UnassignedByte(),sizeof(m_Orientation));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Orientation;
}

inline
bool CComponent_Base::C_Attlist::IsSetGi(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetGi(void) const
{
    return IsSetGi();
}

inline
const CComponent_Base::C_Attlist::TGi& CComponent_Base::C_Attlist::GetGi(void) const
{
    if (!CanGetGi()) {
        ThrowUnassigned(8);
    }
    return m_Gi;
}

inline
void CComponent_Base::C_Attlist::SetGi(const CComponent_Base::C_Attlist::TGi& value)
{
    m_Gi = value;
    m_set_State[0] |= 0x30000;
}

inline
void CComponent_Base::C_Attlist::SetGi(CComponent_Base::C_Attlist::TGi&& value)
{
    m_Gi = std::forward<CComponent_Base::C_Attlist::TGi>(value);
    m_set_State[0] |= 0x30000;
}

inline
CComponent_Base::C_Attlist::TGi& CComponent_Base::C_Attlist::SetGi(void)
{
#ifdef _DEBUG
    if (!IsSetGi()) {
        m_Gi = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Gi;
}

inline
bool CComponent_Base::C_Attlist::IsSetGroupTerm(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetGroupTerm(void) const
{
    return IsSetGroupTerm();
}

inline
const CComponent_Base::C_Attlist::TGroupTerm& CComponent_Base::C_Attlist::GetGroupTerm(void) const
{
    if (!CanGetGroupTerm()) {
        ThrowUnassigned(9);
    }
    return m_GroupTerm;
}

inline
void CComponent_Base::C_Attlist::SetGroupTerm(const CComponent_Base::C_Attlist::TGroupTerm& value)
{
    m_GroupTerm = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CComponent_Base::C_Attlist::SetGroupTerm(CComponent_Base::C_Attlist::TGroupTerm&& value)
{
    m_GroupTerm = std::forward<CComponent_Base::C_Attlist::TGroupTerm>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CComponent_Base::C_Attlist::TGroupTerm& CComponent_Base::C_Attlist::SetGroupTerm(void)
{
#ifdef _DEBUG
    if (!IsSetGroupTerm()) {
        m_GroupTerm = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_GroupTerm;
}

inline
bool CComponent_Base::C_Attlist::IsSetContigLabel(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CComponent_Base::C_Attlist::CanGetContigLabel(void) const
{
    return IsSetContigLabel();
}

inline
const CComponent_Base::C_Attlist::TContigLabel& CComponent_Base::C_Attlist::GetContigLabel(void) const
{
    if (!CanGetContigLabel()) {
        ThrowUnassigned(10);
    }
    return m_ContigLabel;
}

inline
void CComponent_Base::C_Attlist::SetContigLabel(const CComponent_Base::C_Attlist::TContigLabel& value)
{
    m_ContigLabel = value;
    m_set_State[0] |= 0x300000;
}

inline
void CComponent_Base::C_Attlist::SetContigLabel(CComponent_Base::C_Attlist::TContigLabel&& value)
{
    m_ContigLabel = std::forward<CComponent_Base::C_Attlist::TContigLabel>(value);
    m_set_State[0] |= 0x300000;
}

inline
CComponent_Base::C_Attlist::TContigLabel& CComponent_Base::C_Attlist::SetContigLabel(void)
{
#ifdef _DEBUG
    if (!IsSetContigLabel()) {
        m_ContigLabel = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_ContigLabel;
}

inline
bool CComponent_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CComponent_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CComponent_Base::TAttlist& CComponent_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CComponent_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CComponent_Base::TAttlist& CComponent_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CComponent_Base::IsSetMapLoc(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CComponent_Base::CanGetMapLoc(void) const
{
    return true;
}

inline
const CComponent_Base::TMapLoc& CComponent_Base::GetMapLoc(void) const
{
    return m_MapLoc;
}

inline
CComponent_Base::TMapLoc& CComponent_Base::SetMapLoc(void)
{
    m_set_State[0] |= 0x4;
    return m_MapLoc;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_COMPONENT_BASE_HPP
