/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_backbone_style_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_BACKBONE_STYLE_BASE_HPP
#define OBJECTS_CN3D_CN3D_BACKBONE_STYLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/cn3d/Cn3d_backbone_type.hpp>
#include <objects/cn3d/Cn3d_color_scheme.hpp>
#include <objects/cn3d/Cn3d_drawing_style.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCn3d_color;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// style blob for backbones only
class NCBI_CN3D_EXPORT CCn3d_backbone_style_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_backbone_style_Base(void);
    // destructor
    virtual ~CCn3d_backbone_style_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef ECn3d_backbone_type TType;
    typedef ECn3d_drawing_style TStyle;
    typedef ECn3d_color_scheme TColor_scheme;
    typedef CCn3d_color TUser_color;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_style,
        e_color_scheme,
        e_user_color
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef ECn3d_backbone_type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef ECn3d_drawing_style TStyle
    ///  Check whether the Style data member has been assigned a value.
    bool IsSetStyle(void) const;
    /// Check whether it is safe or not to call GetStyle method.
    bool CanGetStyle(void) const;
    void ResetStyle(void);
    TStyle GetStyle(void) const;
    void SetStyle(TStyle value);
    TStyle& SetStyle(void);

    /// mandatory
    /// typedef ECn3d_color_scheme TColor_scheme
    ///  Check whether the Color_scheme data member has been assigned a value.
    bool IsSetColor_scheme(void) const;
    /// Check whether it is safe or not to call GetColor_scheme method.
    bool CanGetColor_scheme(void) const;
    void ResetColor_scheme(void);
    TColor_scheme GetColor_scheme(void) const;
    void SetColor_scheme(TColor_scheme value);
    TColor_scheme& SetColor_scheme(void);

    /// mandatory
    /// typedef CCn3d_color TUser_color
    ///  Check whether the User_color data member has been assigned a value.
    bool IsSetUser_color(void) const;
    /// Check whether it is safe or not to call GetUser_color method.
    bool CanGetUser_color(void) const;
    void ResetUser_color(void);
    const TUser_color& GetUser_color(void) const;
    void SetUser_color(TUser_color& value);
    TUser_color& SetUser_color(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_backbone_style_Base(const CCn3d_backbone_style_Base&);
    CCn3d_backbone_style_Base& operator=(const CCn3d_backbone_style_Base&);

    // data
    Uint4 m_set_State[1];
    ECn3d_backbone_type m_Type;
    ECn3d_drawing_style m_Style;
    ECn3d_color_scheme m_Color_scheme;
    CRef< TUser_color > m_User_color;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_backbone_style_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_backbone_style_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CCn3d_backbone_style_Base::ResetType(void)
{
    m_Type = (ncbi::objects::ECn3d_backbone_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CCn3d_backbone_style_Base::TType CCn3d_backbone_style_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CCn3d_backbone_style_Base::SetType(CCn3d_backbone_style_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_backbone_style_Base::TType& CCn3d_backbone_style_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CCn3d_backbone_style_Base::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_backbone_style_Base::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
void CCn3d_backbone_style_Base::ResetStyle(void)
{
    m_Style = (ncbi::objects::ECn3d_drawing_style)(0);
    m_set_State[0] &= ~0xc;
}

inline
CCn3d_backbone_style_Base::TStyle CCn3d_backbone_style_Base::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(1);
    }
    return m_Style;
}

inline
void CCn3d_backbone_style_Base::SetStyle(CCn3d_backbone_style_Base::TStyle value)
{
    m_Style = value;
    m_set_State[0] |= 0xc;
}

inline
CCn3d_backbone_style_Base::TStyle& CCn3d_backbone_style_Base::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        memset(&m_Style,UnassignedByte(),sizeof(m_Style));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Style;
}

inline
bool CCn3d_backbone_style_Base::IsSetColor_scheme(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCn3d_backbone_style_Base::CanGetColor_scheme(void) const
{
    return IsSetColor_scheme();
}

inline
void CCn3d_backbone_style_Base::ResetColor_scheme(void)
{
    m_Color_scheme = (ncbi::objects::ECn3d_color_scheme)(0);
    m_set_State[0] &= ~0x30;
}

inline
CCn3d_backbone_style_Base::TColor_scheme CCn3d_backbone_style_Base::GetColor_scheme(void) const
{
    if (!CanGetColor_scheme()) {
        ThrowUnassigned(2);
    }
    return m_Color_scheme;
}

inline
void CCn3d_backbone_style_Base::SetColor_scheme(CCn3d_backbone_style_Base::TColor_scheme value)
{
    m_Color_scheme = value;
    m_set_State[0] |= 0x30;
}

inline
CCn3d_backbone_style_Base::TColor_scheme& CCn3d_backbone_style_Base::SetColor_scheme(void)
{
#ifdef _DEBUG
    if (!IsSetColor_scheme()) {
        memset(&m_Color_scheme,UnassignedByte(),sizeof(m_Color_scheme));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Color_scheme;
}

inline
bool CCn3d_backbone_style_Base::IsSetUser_color(void) const
{
    return m_User_color.NotEmpty();
}

inline
bool CCn3d_backbone_style_Base::CanGetUser_color(void) const
{
    return true;
}

inline
const CCn3d_backbone_style_Base::TUser_color& CCn3d_backbone_style_Base::GetUser_color(void) const
{
    if ( !m_User_color ) {
        const_cast<CCn3d_backbone_style_Base*>(this)->ResetUser_color();
    }
    return (*m_User_color);
}

inline
CCn3d_backbone_style_Base::TUser_color& CCn3d_backbone_style_Base::SetUser_color(void)
{
    if ( !m_User_color ) {
        ResetUser_color();
    }
    return (*m_User_color);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_BACKBONE_STYLE_BASE_HPP
