/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Statistics_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML2_STATISTICS_BASE_HPP
#define OBJECTS_BLASTXML2_STATISTICS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_blastxml2_SCOPE
#  define BEGIN_blastxml2_SCOPE BEGIN_SCOPE(blastxml2)
#  define END_blastxml2_SCOPE END_SCOPE(blastxml2)
#endif
BEGIN_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTXML2_EXPORT CStatistics_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CStatistics_Base(void);
    // destructor
    virtual ~CStatistics_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef Int8 TDb_num;
    typedef Int8 TDb_len;
    typedef int THsp_len;
    typedef Int8 TEff_space;
    typedef double TKappa;
    typedef double TLambda;
    typedef double TEntropy;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_db_num,
        e_db_len,
        e_hsp_len,
        e_eff_space,
        e_kappa,
        e_lambda,
        e_entropy
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// Number of sequences in BLAST db
    /// optional
    /// typedef Int8 TDb_num
    ///  Check whether the Db_num data member has been assigned a value.
    bool IsSetDb_num(void) const;
    /// Check whether it is safe or not to call GetDb_num method.
    bool CanGetDb_num(void) const;
    void ResetDb_num(void);
    TDb_num GetDb_num(void) const;
    void SetDb_num(TDb_num value);
    TDb_num& SetDb_num(void);

    /// Length of BLAST db
    /// optional
    /// typedef Int8 TDb_len
    ///  Check whether the Db_len data member has been assigned a value.
    bool IsSetDb_len(void) const;
    /// Check whether it is safe or not to call GetDb_len method.
    bool CanGetDb_len(void) const;
    void ResetDb_len(void);
    TDb_len GetDb_len(void) const;
    void SetDb_len(TDb_len value);
    TDb_len& SetDb_len(void);

    /// Effective HSP length
    /// mandatory
    /// typedef int THsp_len
    ///  Check whether the Hsp_len data member has been assigned a value.
    bool IsSetHsp_len(void) const;
    /// Check whether it is safe or not to call GetHsp_len method.
    bool CanGetHsp_len(void) const;
    void ResetHsp_len(void);
    THsp_len GetHsp_len(void) const;
    void SetHsp_len(THsp_len value);
    THsp_len& SetHsp_len(void);

    /// Effective search space
    /// mandatory
    /// typedef Int8 TEff_space
    ///  Check whether the Eff_space data member has been assigned a value.
    bool IsSetEff_space(void) const;
    /// Check whether it is safe or not to call GetEff_space method.
    bool CanGetEff_space(void) const;
    void ResetEff_space(void);
    TEff_space GetEff_space(void) const;
    void SetEff_space(TEff_space value);
    TEff_space& SetEff_space(void);

    /// Karlin-Altschul parameter K
    /// mandatory
    /// typedef double TKappa
    ///  Check whether the Kappa data member has been assigned a value.
    bool IsSetKappa(void) const;
    /// Check whether it is safe or not to call GetKappa method.
    bool CanGetKappa(void) const;
    void ResetKappa(void);
    TKappa GetKappa(void) const;
    void SetKappa(TKappa value);
    TKappa& SetKappa(void);

    /// Karlin-Altschul parameter Lambda
    /// mandatory
    /// typedef double TLambda
    ///  Check whether the Lambda data member has been assigned a value.
    bool IsSetLambda(void) const;
    /// Check whether it is safe or not to call GetLambda method.
    bool CanGetLambda(void) const;
    void ResetLambda(void);
    TLambda GetLambda(void) const;
    void SetLambda(TLambda value);
    TLambda& SetLambda(void);

    /// Karlin-Altschul parameter H
    /// mandatory
    /// typedef double TEntropy
    ///  Check whether the Entropy data member has been assigned a value.
    bool IsSetEntropy(void) const;
    /// Check whether it is safe or not to call GetEntropy method.
    bool CanGetEntropy(void) const;
    void ResetEntropy(void);
    TEntropy GetEntropy(void) const;
    void SetEntropy(TEntropy value);
    TEntropy& SetEntropy(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CStatistics_Base(const CStatistics_Base&);
    CStatistics_Base& operator=(const CStatistics_Base&);

    // data
    Uint4 m_set_State[1];
    Int8 m_Db_num;
    Int8 m_Db_len;
    int m_Hsp_len;
    Int8 m_Eff_space;
    double m_Kappa;
    double m_Lambda;
    double m_Entropy;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CStatistics_Base::IsSetDb_num(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CStatistics_Base::CanGetDb_num(void) const
{
    return IsSetDb_num();
}

inline
void CStatistics_Base::ResetDb_num(void)
{
    m_Db_num = 0;
    m_set_State[0] &= ~0x3;
}

inline
CStatistics_Base::TDb_num CStatistics_Base::GetDb_num(void) const
{
    if (!CanGetDb_num()) {
        ThrowUnassigned(0);
    }
    return m_Db_num;
}

inline
void CStatistics_Base::SetDb_num(CStatistics_Base::TDb_num value)
{
    m_Db_num = value;
    m_set_State[0] |= 0x3;
}

inline
CStatistics_Base::TDb_num& CStatistics_Base::SetDb_num(void)
{
#ifdef _DEBUG
    if (!IsSetDb_num()) {
        memset(&m_Db_num,UnassignedByte(),sizeof(m_Db_num));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Db_num;
}

inline
bool CStatistics_Base::IsSetDb_len(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CStatistics_Base::CanGetDb_len(void) const
{
    return IsSetDb_len();
}

inline
void CStatistics_Base::ResetDb_len(void)
{
    m_Db_len = 0;
    m_set_State[0] &= ~0xc;
}

inline
CStatistics_Base::TDb_len CStatistics_Base::GetDb_len(void) const
{
    if (!CanGetDb_len()) {
        ThrowUnassigned(1);
    }
    return m_Db_len;
}

inline
void CStatistics_Base::SetDb_len(CStatistics_Base::TDb_len value)
{
    m_Db_len = value;
    m_set_State[0] |= 0xc;
}

inline
CStatistics_Base::TDb_len& CStatistics_Base::SetDb_len(void)
{
#ifdef _DEBUG
    if (!IsSetDb_len()) {
        memset(&m_Db_len,UnassignedByte(),sizeof(m_Db_len));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Db_len;
}

inline
bool CStatistics_Base::IsSetHsp_len(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CStatistics_Base::CanGetHsp_len(void) const
{
    return IsSetHsp_len();
}

inline
void CStatistics_Base::ResetHsp_len(void)
{
    m_Hsp_len = 0;
    m_set_State[0] &= ~0x30;
}

inline
CStatistics_Base::THsp_len CStatistics_Base::GetHsp_len(void) const
{
    if (!CanGetHsp_len()) {
        ThrowUnassigned(2);
    }
    return m_Hsp_len;
}

inline
void CStatistics_Base::SetHsp_len(CStatistics_Base::THsp_len value)
{
    m_Hsp_len = value;
    m_set_State[0] |= 0x30;
}

inline
CStatistics_Base::THsp_len& CStatistics_Base::SetHsp_len(void)
{
#ifdef _DEBUG
    if (!IsSetHsp_len()) {
        memset(&m_Hsp_len,UnassignedByte(),sizeof(m_Hsp_len));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Hsp_len;
}

inline
bool CStatistics_Base::IsSetEff_space(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CStatistics_Base::CanGetEff_space(void) const
{
    return IsSetEff_space();
}

inline
void CStatistics_Base::ResetEff_space(void)
{
    m_Eff_space = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CStatistics_Base::TEff_space CStatistics_Base::GetEff_space(void) const
{
    if (!CanGetEff_space()) {
        ThrowUnassigned(3);
    }
    return m_Eff_space;
}

inline
void CStatistics_Base::SetEff_space(CStatistics_Base::TEff_space value)
{
    m_Eff_space = value;
    m_set_State[0] |= 0xc0;
}

inline
CStatistics_Base::TEff_space& CStatistics_Base::SetEff_space(void)
{
#ifdef _DEBUG
    if (!IsSetEff_space()) {
        memset(&m_Eff_space,UnassignedByte(),sizeof(m_Eff_space));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Eff_space;
}

inline
bool CStatistics_Base::IsSetKappa(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CStatistics_Base::CanGetKappa(void) const
{
    return IsSetKappa();
}

inline
void CStatistics_Base::ResetKappa(void)
{
    m_Kappa = 0;
    m_set_State[0] &= ~0x300;
}

inline
CStatistics_Base::TKappa CStatistics_Base::GetKappa(void) const
{
    if (!CanGetKappa()) {
        ThrowUnassigned(4);
    }
    return m_Kappa;
}

inline
void CStatistics_Base::SetKappa(CStatistics_Base::TKappa value)
{
    m_Kappa = value;
    m_set_State[0] |= 0x300;
}

inline
CStatistics_Base::TKappa& CStatistics_Base::SetKappa(void)
{
#ifdef _DEBUG
    if (!IsSetKappa()) {
        memset(&m_Kappa,UnassignedByte(),sizeof(m_Kappa));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Kappa;
}

inline
bool CStatistics_Base::IsSetLambda(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CStatistics_Base::CanGetLambda(void) const
{
    return IsSetLambda();
}

inline
void CStatistics_Base::ResetLambda(void)
{
    m_Lambda = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CStatistics_Base::TLambda CStatistics_Base::GetLambda(void) const
{
    if (!CanGetLambda()) {
        ThrowUnassigned(5);
    }
    return m_Lambda;
}

inline
void CStatistics_Base::SetLambda(CStatistics_Base::TLambda value)
{
    m_Lambda = value;
    m_set_State[0] |= 0xc00;
}

inline
CStatistics_Base::TLambda& CStatistics_Base::SetLambda(void)
{
#ifdef _DEBUG
    if (!IsSetLambda()) {
        memset(&m_Lambda,UnassignedByte(),sizeof(m_Lambda));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Lambda;
}

inline
bool CStatistics_Base::IsSetEntropy(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CStatistics_Base::CanGetEntropy(void) const
{
    return IsSetEntropy();
}

inline
void CStatistics_Base::ResetEntropy(void)
{
    m_Entropy = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CStatistics_Base::TEntropy CStatistics_Base::GetEntropy(void) const
{
    if (!CanGetEntropy()) {
        ThrowUnassigned(6);
    }
    return m_Entropy;
}

inline
void CStatistics_Base::SetEntropy(CStatistics_Base::TEntropy value)
{
    m_Entropy = value;
    m_set_State[0] |= 0x3000;
}

inline
CStatistics_Base::TEntropy& CStatistics_Base::SetEntropy(void)
{
#ifdef _DEBUG
    if (!IsSetEntropy()) {
        memset(&m_Entropy,UnassignedByte(),sizeof(m_Entropy));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Entropy;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML2_STATISTICS_BASE_HPP
