/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Results_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML2_RESULTS_BASE_HPP
#define OBJECTS_BLASTXML2_RESULTS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_blastxml2_SCOPE
#  define BEGIN_blastxml2_SCOPE BEGIN_SCOPE(blastxml2)
#  define END_blastxml2_SCOPE END_SCOPE(blastxml2)
#endif
BEGIN_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::


// forward declarations
class CIteration;
class CSearch;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTXML2_EXPORT CResults_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CResults_Base(void);
    // destructor
    virtual ~CResults_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Iterations,
        e_Search,       ///<  iterative search (psi and delta blast)   db search   
        e_Bl2seq        ///<  bl2seq
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Bl2seq+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef list< CRef< CIteration > > TIterations;
    typedef CSearch TSearch;
    typedef list< CRef< CSearch > > TBl2seq;

    // getters
    // setters

    // typedef list< CRef< CIteration > > TIterations
    bool IsIterations(void) const;
    const TIterations& GetIterations(void) const;
    TIterations& SetIterations(void);

    // typedef CSearch TSearch
    bool IsSearch(void) const;
    const TSearch& GetSearch(void) const;
    TSearch& SetSearch(void);
    void SetSearch(TSearch& value);

    // typedef list< CRef< CSearch > > TBl2seq
    bool IsBl2seq(void) const;
    const TBl2seq& GetBl2seq(void) const;
    TBl2seq& SetBl2seq(void);


private:
    // copy constructor and assignment operator
    CResults_Base(const CResults_Base& );
    CResults_Base& operator=(const CResults_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TIterations> m_Iterations;
        NCBI_NS_NCBI::CUnionBuffer<TBl2seq> m_Bl2seq;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CResults_Base::E_Choice CResults_Base::Which(void) const
{
    return m_choice;
}

inline
void CResults_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CResults_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CResults_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CResults_Base::IsIterations(void) const
{
    return m_choice == e_Iterations;
}

inline
const CResults_Base::TIterations& CResults_Base::GetIterations(void) const
{
    CheckSelected(e_Iterations);
    return *m_Iterations;
}

inline
CResults_Base::TIterations& CResults_Base::SetIterations(void)
{
    Select(e_Iterations, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Iterations;
}

inline
bool CResults_Base::IsSearch(void) const
{
    return m_choice == e_Search;
}

inline
bool CResults_Base::IsBl2seq(void) const
{
    return m_choice == e_Bl2seq;
}

inline
const CResults_Base::TBl2seq& CResults_Base::GetBl2seq(void) const
{
    CheckSelected(e_Bl2seq);
    return *m_Bl2seq;
}

inline
CResults_Base::TBl2seq& CResults_Base::SetBl2seq(void)
{
    Select(e_Bl2seq, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Bl2seq;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML2_RESULTS_BASE_HPP
