/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Report_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML2_REPORT_BASE_HPP
#define OBJECTS_BLASTXML2_REPORT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_blastxml2_SCOPE
#  define BEGIN_blastxml2_SCOPE BEGIN_SCOPE(blastxml2)
#  define END_blastxml2_SCOPE END_SCOPE(blastxml2)
#endif
BEGIN_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::


// forward declarations
class CParameters;
class CResults;
class CTarget;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTXML2_EXPORT CReport_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CReport_Base(void);
    // destructor
    virtual ~CReport_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TProgram;
    typedef string TVersion;
    typedef string TReference;
    typedef CTarget TSearch_target;
    typedef CParameters TParams;
    typedef CResults TResults;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_program,
        e_version,
        e_reference,
        e_search_target,
        e_params,
        e_results
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// BLAST program: blastp, tblastx etc.
    /// mandatory
    /// typedef string TProgram
    ///  Check whether the Program data member has been assigned a value.
    bool IsSetProgram(void) const;
    /// Check whether it is safe or not to call GetProgram method.
    bool CanGetProgram(void) const;
    void ResetProgram(void);
    const TProgram& GetProgram(void) const;
    void SetProgram(const TProgram& value);
    void SetProgram(TProgram&& value);
    TProgram& SetProgram(void);

    /// Program version 
    /// mandatory
    /// typedef string TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    const TVersion& GetVersion(void) const;
    void SetVersion(const TVersion& value);
    void SetVersion(TVersion&& value);
    TVersion& SetVersion(void);

    /// Steven, David, Tom and others
    /// mandatory
    /// typedef string TReference
    ///  Check whether the Reference data member has been assigned a value.
    bool IsSetReference(void) const;
    /// Check whether it is safe or not to call GetReference method.
    bool CanGetReference(void) const;
    void ResetReference(void);
    const TReference& GetReference(void) const;
    void SetReference(const TReference& value);
    void SetReference(TReference&& value);
    TReference& SetReference(void);

    /// mandatory
    /// typedef CTarget TSearch_target
    ///  Check whether the Search_target data member has been assigned a value.
    bool IsSetSearch_target(void) const;
    /// Check whether it is safe or not to call GetSearch_target method.
    bool CanGetSearch_target(void) const;
    void ResetSearch_target(void);
    const TSearch_target& GetSearch_target(void) const;
    void SetSearch_target(TSearch_target& value);
    TSearch_target& SetSearch_target(void);

    /// search parameters
    /// mandatory
    /// typedef CParameters TParams
    ///  Check whether the Params data member has been assigned a value.
    bool IsSetParams(void) const;
    /// Check whether it is safe or not to call GetParams method.
    bool CanGetParams(void) const;
    void ResetParams(void);
    const TParams& GetParams(void) const;
    void SetParams(TParams& value);
    TParams& SetParams(void);

    /// mandatory
    /// typedef CResults TResults
    ///  Check whether the Results data member has been assigned a value.
    bool IsSetResults(void) const;
    /// Check whether it is safe or not to call GetResults method.
    bool CanGetResults(void) const;
    void ResetResults(void);
    const TResults& GetResults(void) const;
    void SetResults(TResults& value);
    TResults& SetResults(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CReport_Base(const CReport_Base&);
    CReport_Base& operator=(const CReport_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Program;
    string m_Version;
    string m_Reference;
    CRef< TSearch_target > m_Search_target;
    CRef< TParams > m_Params;
    CRef< TResults > m_Results;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CReport_Base::IsSetProgram(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CReport_Base::CanGetProgram(void) const
{
    return IsSetProgram();
}

inline
const CReport_Base::TProgram& CReport_Base::GetProgram(void) const
{
    if (!CanGetProgram()) {
        ThrowUnassigned(0);
    }
    return m_Program;
}

inline
void CReport_Base::SetProgram(const CReport_Base::TProgram& value)
{
    m_Program = value;
    m_set_State[0] |= 0x3;
}

inline
void CReport_Base::SetProgram(CReport_Base::TProgram&& value)
{
    m_Program = std::forward<CReport_Base::TProgram>(value);
    m_set_State[0] |= 0x3;
}

inline
CReport_Base::TProgram& CReport_Base::SetProgram(void)
{
#ifdef _DEBUG
    if (!IsSetProgram()) {
        m_Program = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Program;
}

inline
bool CReport_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CReport_Base::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
const CReport_Base::TVersion& CReport_Base::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(1);
    }
    return m_Version;
}

inline
void CReport_Base::SetVersion(const CReport_Base::TVersion& value)
{
    m_Version = value;
    m_set_State[0] |= 0xc;
}

inline
void CReport_Base::SetVersion(CReport_Base::TVersion&& value)
{
    m_Version = std::forward<CReport_Base::TVersion>(value);
    m_set_State[0] |= 0xc;
}

inline
CReport_Base::TVersion& CReport_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        m_Version = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Version;
}

inline
bool CReport_Base::IsSetReference(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CReport_Base::CanGetReference(void) const
{
    return IsSetReference();
}

inline
const CReport_Base::TReference& CReport_Base::GetReference(void) const
{
    if (!CanGetReference()) {
        ThrowUnassigned(2);
    }
    return m_Reference;
}

inline
void CReport_Base::SetReference(const CReport_Base::TReference& value)
{
    m_Reference = value;
    m_set_State[0] |= 0x30;
}

inline
void CReport_Base::SetReference(CReport_Base::TReference&& value)
{
    m_Reference = std::forward<CReport_Base::TReference>(value);
    m_set_State[0] |= 0x30;
}

inline
CReport_Base::TReference& CReport_Base::SetReference(void)
{
#ifdef _DEBUG
    if (!IsSetReference()) {
        m_Reference = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Reference;
}

inline
bool CReport_Base::IsSetSearch_target(void) const
{
    return m_Search_target.NotEmpty();
}

inline
bool CReport_Base::CanGetSearch_target(void) const
{
    return true;
}

inline
const CReport_Base::TSearch_target& CReport_Base::GetSearch_target(void) const
{
    if ( !m_Search_target ) {
        const_cast<CReport_Base*>(this)->ResetSearch_target();
    }
    return (*m_Search_target);
}

inline
CReport_Base::TSearch_target& CReport_Base::SetSearch_target(void)
{
    if ( !m_Search_target ) {
        ResetSearch_target();
    }
    return (*m_Search_target);
}

inline
bool CReport_Base::IsSetParams(void) const
{
    return m_Params.NotEmpty();
}

inline
bool CReport_Base::CanGetParams(void) const
{
    return true;
}

inline
const CReport_Base::TParams& CReport_Base::GetParams(void) const
{
    if ( !m_Params ) {
        const_cast<CReport_Base*>(this)->ResetParams();
    }
    return (*m_Params);
}

inline
CReport_Base::TParams& CReport_Base::SetParams(void)
{
    if ( !m_Params ) {
        ResetParams();
    }
    return (*m_Params);
}

inline
bool CReport_Base::IsSetResults(void) const
{
    return m_Results.NotEmpty();
}

inline
bool CReport_Base::CanGetResults(void) const
{
    return true;
}

inline
const CReport_Base::TResults& CReport_Base::GetResults(void) const
{
    if ( !m_Results ) {
        const_cast<CReport_Base*>(this)->ResetResults();
    }
    return (*m_Results);
}

inline
CReport_Base::TResults& CReport_Base::SetResults(void)
{
    if ( !m_Results ) {
        ResetResults();
    }
    return (*m_Results);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML2_REPORT_BASE_HPP
