/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast_finish_params_reques_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST_FINISH_PARAMS_REQUES_BASE_HPP
#define OBJECTS_BLAST_BLAST_FINISH_PARAMS_REQUES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_parameters;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// END ADD EXT INFO
class NCBI_BLAST_EXPORT CBlast4_finish_params_request_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_finish_params_request_Base(void);
    // destructor
    virtual ~CBlast4_finish_params_request_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TProgram;
    typedef string TService;
    typedef string TParamset;
    typedef CBlast4_parameters TParams;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_program,
        e_service,
        e_paramset,
        e_params
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TProgram
    ///  Check whether the Program data member has been assigned a value.
    bool IsSetProgram(void) const;
    /// Check whether it is safe or not to call GetProgram method.
    bool CanGetProgram(void) const;
    void ResetProgram(void);
    const TProgram& GetProgram(void) const;
    void SetProgram(const TProgram& value);
    void SetProgram(TProgram&& value);
    TProgram& SetProgram(void);

    /// mandatory
    /// typedef string TService
    ///  Check whether the Service data member has been assigned a value.
    bool IsSetService(void) const;
    /// Check whether it is safe or not to call GetService method.
    bool CanGetService(void) const;
    void ResetService(void);
    const TService& GetService(void) const;
    void SetService(const TService& value);
    void SetService(TService&& value);
    TService& SetService(void);

    /// optional
    /// typedef string TParamset
    ///  Check whether the Paramset data member has been assigned a value.
    bool IsSetParamset(void) const;
    /// Check whether it is safe or not to call GetParamset method.
    bool CanGetParamset(void) const;
    void ResetParamset(void);
    const TParamset& GetParamset(void) const;
    void SetParamset(const TParamset& value);
    void SetParamset(TParamset&& value);
    TParamset& SetParamset(void);

    /// optional
    /// typedef CBlast4_parameters TParams
    ///  Check whether the Params data member has been assigned a value.
    bool IsSetParams(void) const;
    /// Check whether it is safe or not to call GetParams method.
    bool CanGetParams(void) const;
    void ResetParams(void);
    const TParams& GetParams(void) const;
    void SetParams(TParams& value);
    TParams& SetParams(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_finish_params_request_Base(const CBlast4_finish_params_request_Base&);
    CBlast4_finish_params_request_Base& operator=(const CBlast4_finish_params_request_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Program;
    string m_Service;
    string m_Paramset;
    CRef< TParams > m_Params;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_finish_params_request_Base::IsSetProgram(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_finish_params_request_Base::CanGetProgram(void) const
{
    return IsSetProgram();
}

inline
const CBlast4_finish_params_request_Base::TProgram& CBlast4_finish_params_request_Base::GetProgram(void) const
{
    if (!CanGetProgram()) {
        ThrowUnassigned(0);
    }
    return m_Program;
}

inline
void CBlast4_finish_params_request_Base::SetProgram(const CBlast4_finish_params_request_Base::TProgram& value)
{
    m_Program = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast4_finish_params_request_Base::SetProgram(CBlast4_finish_params_request_Base::TProgram&& value)
{
    m_Program = std::forward<CBlast4_finish_params_request_Base::TProgram>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast4_finish_params_request_Base::TProgram& CBlast4_finish_params_request_Base::SetProgram(void)
{
#ifdef _DEBUG
    if (!IsSetProgram()) {
        m_Program = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Program;
}

inline
bool CBlast4_finish_params_request_Base::IsSetService(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_finish_params_request_Base::CanGetService(void) const
{
    return IsSetService();
}

inline
const CBlast4_finish_params_request_Base::TService& CBlast4_finish_params_request_Base::GetService(void) const
{
    if (!CanGetService()) {
        ThrowUnassigned(1);
    }
    return m_Service;
}

inline
void CBlast4_finish_params_request_Base::SetService(const CBlast4_finish_params_request_Base::TService& value)
{
    m_Service = value;
    m_set_State[0] |= 0xc;
}

inline
void CBlast4_finish_params_request_Base::SetService(CBlast4_finish_params_request_Base::TService&& value)
{
    m_Service = std::forward<CBlast4_finish_params_request_Base::TService>(value);
    m_set_State[0] |= 0xc;
}

inline
CBlast4_finish_params_request_Base::TService& CBlast4_finish_params_request_Base::SetService(void)
{
#ifdef _DEBUG
    if (!IsSetService()) {
        m_Service = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Service;
}

inline
bool CBlast4_finish_params_request_Base::IsSetParamset(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast4_finish_params_request_Base::CanGetParamset(void) const
{
    return IsSetParamset();
}

inline
const CBlast4_finish_params_request_Base::TParamset& CBlast4_finish_params_request_Base::GetParamset(void) const
{
    if (!CanGetParamset()) {
        ThrowUnassigned(2);
    }
    return m_Paramset;
}

inline
void CBlast4_finish_params_request_Base::SetParamset(const CBlast4_finish_params_request_Base::TParamset& value)
{
    m_Paramset = value;
    m_set_State[0] |= 0x30;
}

inline
void CBlast4_finish_params_request_Base::SetParamset(CBlast4_finish_params_request_Base::TParamset&& value)
{
    m_Paramset = std::forward<CBlast4_finish_params_request_Base::TParamset>(value);
    m_set_State[0] |= 0x30;
}

inline
CBlast4_finish_params_request_Base::TParamset& CBlast4_finish_params_request_Base::SetParamset(void)
{
#ifdef _DEBUG
    if (!IsSetParamset()) {
        m_Paramset = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Paramset;
}

inline
bool CBlast4_finish_params_request_Base::IsSetParams(void) const
{
    return m_Params.NotEmpty();
}

inline
bool CBlast4_finish_params_request_Base::CanGetParams(void) const
{
    return IsSetParams();
}

inline
const CBlast4_finish_params_request_Base::TParams& CBlast4_finish_params_request_Base::GetParams(void) const
{
    if (!CanGetParams()) {
        ThrowUnassigned(3);
    }
    return (*m_Params);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST_FINISH_PARAMS_REQUES_BASE_HPP
