/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_seq_part_data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_SEQ_PART_DATA_BASE_HPP
#define OBJECTS_BLAST_BLAST4_SEQ_PART_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_data;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Bundles Seq-ids and sequence data to fulfill requests of type
/// Blast4-get-seq-parts-request
class NCBI_BLAST_EXPORT CBlast4_seq_part_data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_seq_part_data_Base(void);
    // destructor
    virtual ~CBlast4_seq_part_data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_id TId;
    typedef CSeq_data TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Sequence identifier
    /// mandatory
    /// typedef CSeq_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// Its sequence data (may be partial)
    /// mandatory
    /// typedef CSeq_data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_seq_part_data_Base(const CBlast4_seq_part_data_Base&);
    CBlast4_seq_part_data_Base& operator=(const CBlast4_seq_part_data_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_seq_part_data_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CBlast4_seq_part_data_Base::CanGetId(void) const
{
    return true;
}

inline
const CBlast4_seq_part_data_Base::TId& CBlast4_seq_part_data_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CBlast4_seq_part_data_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CBlast4_seq_part_data_Base::TId& CBlast4_seq_part_data_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CBlast4_seq_part_data_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CBlast4_seq_part_data_Base::CanGetData(void) const
{
    return true;
}

inline
const CBlast4_seq_part_data_Base::TData& CBlast4_seq_part_data_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CBlast4_seq_part_data_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CBlast4_seq_part_data_Base::TData& CBlast4_seq_part_data_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_SEQ_PART_DATA_BASE_HPP
