/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_request_body_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_REQUEST_BODY_BASE_HPP
#define OBJECTS_BLAST_BLAST4_REQUEST_BODY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_finish_params_request;
class CBlast4_get_databases_ex_request;
class CBlast4_get_protocol_info_request;
class CBlast4_get_request_info_request;
class CBlast4_get_search_info_request;
class CBlast4_get_search_results_request;
class CBlast4_get_seq_parts_request;
class CBlast4_get_sequences_request;
class CBlast4_queue_search_request;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_request_body_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_request_body_Base(void);
    // destructor
    virtual ~CBlast4_request_body_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,              ///< No variant selected
        e_Finish_params,
        e_Get_databases,            ///< Get all available BLAST databases
        e_Get_matrices,             ///< Get supported scoring matrices
        e_Get_parameters,
        e_Get_paramsets,
        e_Get_programs,
        e_Get_search_results,
        e_Get_sequences,
        e_Queue_search,
        e_Get_request_info,
        e_Get_sequence_parts,
        e_Get_windowmasked_taxids,
        e_Get_protocol_info,        ///< Get version and info about some extended methods
        e_Get_search_info,          ///< Get search info: status, title and etc.
        e_Get_databases_ex          ///< OLD OK get-databases-ex           NULL
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 16 ///< == e_Get_databases_ex+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CBlast4_finish_params_request TFinish_params;
    typedef CBlast4_get_search_results_request TGet_search_results;
    typedef CBlast4_get_sequences_request TGet_sequences;
    typedef CBlast4_queue_search_request TQueue_search;
    typedef CBlast4_get_request_info_request TGet_request_info;
    typedef CBlast4_get_seq_parts_request TGet_sequence_parts;
    typedef CBlast4_get_protocol_info_request TGet_protocol_info;
    typedef CBlast4_get_search_info_request TGet_search_info;
    typedef CBlast4_get_databases_ex_request TGet_databases_ex;

    // getters
    // setters

    // typedef CBlast4_finish_params_request TFinish_params
    bool IsFinish_params(void) const;
    const TFinish_params& GetFinish_params(void) const;
    TFinish_params& SetFinish_params(void);
    void SetFinish_params(TFinish_params& value);


    bool IsGet_databases(void) const;
    void SetGet_databases(void);


    bool IsGet_matrices(void) const;
    void SetGet_matrices(void);


    bool IsGet_parameters(void) const;
    void SetGet_parameters(void);


    bool IsGet_paramsets(void) const;
    void SetGet_paramsets(void);


    bool IsGet_programs(void) const;
    void SetGet_programs(void);

    // typedef CBlast4_get_search_results_request TGet_search_results
    bool IsGet_search_results(void) const;
    const TGet_search_results& GetGet_search_results(void) const;
    TGet_search_results& SetGet_search_results(void);
    void SetGet_search_results(TGet_search_results& value);

    // typedef CBlast4_get_sequences_request TGet_sequences
    bool IsGet_sequences(void) const;
    const TGet_sequences& GetGet_sequences(void) const;
    TGet_sequences& SetGet_sequences(void);
    void SetGet_sequences(TGet_sequences& value);

    // typedef CBlast4_queue_search_request TQueue_search
    bool IsQueue_search(void) const;
    const TQueue_search& GetQueue_search(void) const;
    TQueue_search& SetQueue_search(void);
    void SetQueue_search(TQueue_search& value);

    // typedef CBlast4_get_request_info_request TGet_request_info
    bool IsGet_request_info(void) const;
    const TGet_request_info& GetGet_request_info(void) const;
    TGet_request_info& SetGet_request_info(void);
    void SetGet_request_info(TGet_request_info& value);

    // typedef CBlast4_get_seq_parts_request TGet_sequence_parts
    bool IsGet_sequence_parts(void) const;
    const TGet_sequence_parts& GetGet_sequence_parts(void) const;
    TGet_sequence_parts& SetGet_sequence_parts(void);
    void SetGet_sequence_parts(TGet_sequence_parts& value);


    bool IsGet_windowmasked_taxids(void) const;
    void SetGet_windowmasked_taxids(void);

    // typedef CBlast4_get_protocol_info_request TGet_protocol_info
    bool IsGet_protocol_info(void) const;
    const TGet_protocol_info& GetGet_protocol_info(void) const;
    TGet_protocol_info& SetGet_protocol_info(void);
    void SetGet_protocol_info(TGet_protocol_info& value);

    // typedef CBlast4_get_search_info_request TGet_search_info
    bool IsGet_search_info(void) const;
    const TGet_search_info& GetGet_search_info(void) const;
    TGet_search_info& SetGet_search_info(void);
    void SetGet_search_info(TGet_search_info& value);

    // typedef CBlast4_get_databases_ex_request TGet_databases_ex
    bool IsGet_databases_ex(void) const;
    const TGet_databases_ex& GetGet_databases_ex(void) const;
    TGet_databases_ex& SetGet_databases_ex(void);
    void SetGet_databases_ex(TGet_databases_ex& value);


private:
    // copy constructor and assignment operator
    CBlast4_request_body_Base(const CBlast4_request_body_Base& );
    CBlast4_request_body_Base& operator=(const CBlast4_request_body_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBlast4_request_body_Base::E_Choice CBlast4_request_body_Base::Which(void) const
{
    return m_choice;
}

inline
void CBlast4_request_body_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBlast4_request_body_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBlast4_request_body_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBlast4_request_body_Base::IsFinish_params(void) const
{
    return m_choice == e_Finish_params;
}

inline
bool CBlast4_request_body_Base::IsGet_databases(void) const
{
    return m_choice == e_Get_databases;
}

inline
void CBlast4_request_body_Base::SetGet_databases(void)
{
    Select(e_Get_databases, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CBlast4_request_body_Base::IsGet_matrices(void) const
{
    return m_choice == e_Get_matrices;
}

inline
void CBlast4_request_body_Base::SetGet_matrices(void)
{
    Select(e_Get_matrices, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CBlast4_request_body_Base::IsGet_parameters(void) const
{
    return m_choice == e_Get_parameters;
}

inline
void CBlast4_request_body_Base::SetGet_parameters(void)
{
    Select(e_Get_parameters, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CBlast4_request_body_Base::IsGet_paramsets(void) const
{
    return m_choice == e_Get_paramsets;
}

inline
void CBlast4_request_body_Base::SetGet_paramsets(void)
{
    Select(e_Get_paramsets, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CBlast4_request_body_Base::IsGet_programs(void) const
{
    return m_choice == e_Get_programs;
}

inline
void CBlast4_request_body_Base::SetGet_programs(void)
{
    Select(e_Get_programs, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CBlast4_request_body_Base::IsGet_search_results(void) const
{
    return m_choice == e_Get_search_results;
}

inline
bool CBlast4_request_body_Base::IsGet_sequences(void) const
{
    return m_choice == e_Get_sequences;
}

inline
bool CBlast4_request_body_Base::IsQueue_search(void) const
{
    return m_choice == e_Queue_search;
}

inline
bool CBlast4_request_body_Base::IsGet_request_info(void) const
{
    return m_choice == e_Get_request_info;
}

inline
bool CBlast4_request_body_Base::IsGet_sequence_parts(void) const
{
    return m_choice == e_Get_sequence_parts;
}

inline
bool CBlast4_request_body_Base::IsGet_windowmasked_taxids(void) const
{
    return m_choice == e_Get_windowmasked_taxids;
}

inline
void CBlast4_request_body_Base::SetGet_windowmasked_taxids(void)
{
    Select(e_Get_windowmasked_taxids, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CBlast4_request_body_Base::IsGet_protocol_info(void) const
{
    return m_choice == e_Get_protocol_info;
}

inline
bool CBlast4_request_body_Base::IsGet_search_info(void) const
{
    return m_choice == e_Get_search_info;
}

inline
bool CBlast4_request_body_Base::IsGet_databases_ex(void) const
{
    return m_choice == e_Get_databases_ex;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_REQUEST_BODY_BASE_HPP
