/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_request_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_REQUEST_BASE_HPP
#define OBJECTS_BLAST_BLAST4_REQUEST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_request_body;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///  
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///  Requests
///
///  
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
class NCBI_BLAST_EXPORT CBlast4_request_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_request_Base(void);
    // destructor
    virtual ~CBlast4_request_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TIdent;
    typedef CBlast4_request_body TBody;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_ident,
        e_body
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Client identifier (email address, organization name, program/script
    /// name, or any other form of contacting the owner of this request)
    /// optional
    /// typedef string TIdent
    ///  Check whether the Ident data member has been assigned a value.
    bool IsSetIdent(void) const;
    /// Check whether it is safe or not to call GetIdent method.
    bool CanGetIdent(void) const;
    void ResetIdent(void);
    const TIdent& GetIdent(void) const;
    void SetIdent(const TIdent& value);
    void SetIdent(TIdent&& value);
    TIdent& SetIdent(void);

    /// Payload of the request
    /// mandatory
    /// typedef CBlast4_request_body TBody
    ///  Check whether the Body data member has been assigned a value.
    bool IsSetBody(void) const;
    /// Check whether it is safe or not to call GetBody method.
    bool CanGetBody(void) const;
    void ResetBody(void);
    const TBody& GetBody(void) const;
    void SetBody(TBody& value);
    TBody& SetBody(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_request_Base(const CBlast4_request_Base&);
    CBlast4_request_Base& operator=(const CBlast4_request_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Ident;
    CRef< TBody > m_Body;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_request_Base::IsSetIdent(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_request_Base::CanGetIdent(void) const
{
    return IsSetIdent();
}

inline
const CBlast4_request_Base::TIdent& CBlast4_request_Base::GetIdent(void) const
{
    if (!CanGetIdent()) {
        ThrowUnassigned(0);
    }
    return m_Ident;
}

inline
void CBlast4_request_Base::SetIdent(const CBlast4_request_Base::TIdent& value)
{
    m_Ident = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast4_request_Base::SetIdent(CBlast4_request_Base::TIdent&& value)
{
    m_Ident = std::forward<CBlast4_request_Base::TIdent>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast4_request_Base::TIdent& CBlast4_request_Base::SetIdent(void)
{
#ifdef _DEBUG
    if (!IsSetIdent()) {
        m_Ident = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Ident;
}

inline
bool CBlast4_request_Base::IsSetBody(void) const
{
    return m_Body.NotEmpty();
}

inline
bool CBlast4_request_Base::CanGetBody(void) const
{
    return true;
}

inline
const CBlast4_request_Base::TBody& CBlast4_request_Base::GetBody(void) const
{
    if ( !m_Body ) {
        const_cast<CBlast4_request_Base*>(this)->ResetBody();
    }
    return (*m_Body);
}

inline
CBlast4_request_Base::TBody& CBlast4_request_Base::SetBody(void)
{
    if ( !m_Body ) {
        ResetBody();
    }
    return (*m_Body);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_REQUEST_BASE_HPP
