/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_program_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_PROGRAM_INFO_BASE_HPP
#define OBJECTS_BLAST_BLAST4_PROGRAM_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_program_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_program_info_Base(void);
    // destructor
    virtual ~CBlast4_program_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TProgram;
    typedef list< string > TServices;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_program,
        e_services
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TProgram
    ///  Check whether the Program data member has been assigned a value.
    bool IsSetProgram(void) const;
    /// Check whether it is safe or not to call GetProgram method.
    bool CanGetProgram(void) const;
    void ResetProgram(void);
    const TProgram& GetProgram(void) const;
    void SetProgram(const TProgram& value);
    void SetProgram(TProgram&& value);
    TProgram& SetProgram(void);

    /// mandatory
    /// typedef list< string > TServices
    ///  Check whether the Services data member has been assigned a value.
    bool IsSetServices(void) const;
    /// Check whether it is safe or not to call GetServices method.
    bool CanGetServices(void) const;
    void ResetServices(void);
    const TServices& GetServices(void) const;
    TServices& SetServices(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_program_info_Base(const CBlast4_program_info_Base&);
    CBlast4_program_info_Base& operator=(const CBlast4_program_info_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Program;
    list< string > m_Services;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_program_info_Base::IsSetProgram(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_program_info_Base::CanGetProgram(void) const
{
    return IsSetProgram();
}

inline
const CBlast4_program_info_Base::TProgram& CBlast4_program_info_Base::GetProgram(void) const
{
    if (!CanGetProgram()) {
        ThrowUnassigned(0);
    }
    return m_Program;
}

inline
void CBlast4_program_info_Base::SetProgram(const CBlast4_program_info_Base::TProgram& value)
{
    m_Program = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast4_program_info_Base::SetProgram(CBlast4_program_info_Base::TProgram&& value)
{
    m_Program = std::forward<CBlast4_program_info_Base::TProgram>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast4_program_info_Base::TProgram& CBlast4_program_info_Base::SetProgram(void)
{
#ifdef _DEBUG
    if (!IsSetProgram()) {
        m_Program = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Program;
}

inline
bool CBlast4_program_info_Base::IsSetServices(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_program_info_Base::CanGetServices(void) const
{
    return true;
}

inline
const CBlast4_program_info_Base::TServices& CBlast4_program_info_Base::GetServices(void) const
{
    return m_Services;
}

inline
CBlast4_program_info_Base::TServices& CBlast4_program_info_Base::SetServices(void)
{
    m_set_State[0] |= 0x4;
    return m_Services;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_PROGRAM_INFO_BASE_HPP
