/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_phi_alignments_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_PHI_ALIGNMENTS_BASE_HPP
#define OBJECTS_BLAST_BLAST4_PHI_ALIGNMENTS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_phi_alignments_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_phi_alignments_Base(void);
    // destructor
    virtual ~CBlast4_phi_alignments_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNum_alignments;
    typedef list< CRef< CSeq_loc > > TSeq_locs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_num_alignments,
        e_seq_locs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TNum_alignments
    ///  Check whether the Num_alignments data member has been assigned a value.
    bool IsSetNum_alignments(void) const;
    /// Check whether it is safe or not to call GetNum_alignments method.
    bool CanGetNum_alignments(void) const;
    void ResetNum_alignments(void);
    TNum_alignments GetNum_alignments(void) const;
    void SetNum_alignments(TNum_alignments value);
    TNum_alignments& SetNum_alignments(void);

    /// mandatory
    /// typedef list< CRef< CSeq_loc > > TSeq_locs
    ///  Check whether the Seq_locs data member has been assigned a value.
    bool IsSetSeq_locs(void) const;
    /// Check whether it is safe or not to call GetSeq_locs method.
    bool CanGetSeq_locs(void) const;
    void ResetSeq_locs(void);
    const TSeq_locs& GetSeq_locs(void) const;
    TSeq_locs& SetSeq_locs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_phi_alignments_Base(const CBlast4_phi_alignments_Base&);
    CBlast4_phi_alignments_Base& operator=(const CBlast4_phi_alignments_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Num_alignments;
    list< CRef< CSeq_loc > > m_Seq_locs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_phi_alignments_Base::IsSetNum_alignments(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_phi_alignments_Base::CanGetNum_alignments(void) const
{
    return IsSetNum_alignments();
}

inline
void CBlast4_phi_alignments_Base::ResetNum_alignments(void)
{
    m_Num_alignments = 0;
    m_set_State[0] &= ~0x3;
}

inline
CBlast4_phi_alignments_Base::TNum_alignments CBlast4_phi_alignments_Base::GetNum_alignments(void) const
{
    if (!CanGetNum_alignments()) {
        ThrowUnassigned(0);
    }
    return m_Num_alignments;
}

inline
void CBlast4_phi_alignments_Base::SetNum_alignments(CBlast4_phi_alignments_Base::TNum_alignments value)
{
    m_Num_alignments = value;
    m_set_State[0] |= 0x3;
}

inline
CBlast4_phi_alignments_Base::TNum_alignments& CBlast4_phi_alignments_Base::SetNum_alignments(void)
{
#ifdef _DEBUG
    if (!IsSetNum_alignments()) {
        memset(&m_Num_alignments,UnassignedByte(),sizeof(m_Num_alignments));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Num_alignments;
}

inline
bool CBlast4_phi_alignments_Base::IsSetSeq_locs(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_phi_alignments_Base::CanGetSeq_locs(void) const
{
    return true;
}

inline
const CBlast4_phi_alignments_Base::TSeq_locs& CBlast4_phi_alignments_Base::GetSeq_locs(void) const
{
    return m_Seq_locs;
}

inline
CBlast4_phi_alignments_Base::TSeq_locs& CBlast4_phi_alignments_Base::SetSeq_locs(void)
{
    m_set_State[0] |= 0x4;
    return m_Seq_locs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_PHI_ALIGNMENTS_BASE_HPP
