/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_error_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_ERROR_BASE_HPP
#define OBJECTS_BLAST_BLAST4_ERROR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///  
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///  Errors
///
///  
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
class NCBI_BLAST_EXPORT CBlast4_error_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_error_Base(void);
    // destructor
    virtual ~CBlast4_error_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TCode;
    typedef string TMessage;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_code,
        e_message
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// This is an integer to allow for flexibility, but the values assigned
    /// should be of type Blast4-error-code
    /// mandatory
    /// typedef int TCode
    ///  Check whether the Code data member has been assigned a value.
    bool IsSetCode(void) const;
    /// Check whether it is safe or not to call GetCode method.
    bool CanGetCode(void) const;
    void ResetCode(void);
    TCode GetCode(void) const;
    void SetCode(TCode value);
    TCode& SetCode(void);

    /// optional
    /// typedef string TMessage
    ///  Check whether the Message data member has been assigned a value.
    bool IsSetMessage(void) const;
    /// Check whether it is safe or not to call GetMessage method.
    bool CanGetMessage(void) const;
    void ResetMessage(void);
    const TMessage& GetMessage(void) const;
    void SetMessage(const TMessage& value);
    void SetMessage(TMessage&& value);
    TMessage& SetMessage(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_error_Base(const CBlast4_error_Base&);
    CBlast4_error_Base& operator=(const CBlast4_error_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Code;
    string m_Message;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_error_Base::IsSetCode(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_error_Base::CanGetCode(void) const
{
    return IsSetCode();
}

inline
void CBlast4_error_Base::ResetCode(void)
{
    m_Code = 0;
    m_set_State[0] &= ~0x3;
}

inline
CBlast4_error_Base::TCode CBlast4_error_Base::GetCode(void) const
{
    if (!CanGetCode()) {
        ThrowUnassigned(0);
    }
    return m_Code;
}

inline
void CBlast4_error_Base::SetCode(CBlast4_error_Base::TCode value)
{
    m_Code = value;
    m_set_State[0] |= 0x3;
}

inline
CBlast4_error_Base::TCode& CBlast4_error_Base::SetCode(void)
{
#ifdef _DEBUG
    if (!IsSetCode()) {
        memset(&m_Code,UnassignedByte(),sizeof(m_Code));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Code;
}

inline
bool CBlast4_error_Base::IsSetMessage(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_error_Base::CanGetMessage(void) const
{
    return IsSetMessage();
}

inline
const CBlast4_error_Base::TMessage& CBlast4_error_Base::GetMessage(void) const
{
    if (!CanGetMessage()) {
        ThrowUnassigned(1);
    }
    return m_Message;
}

inline
void CBlast4_error_Base::SetMessage(const CBlast4_error_Base::TMessage& value)
{
    m_Message = value;
    m_set_State[0] |= 0xc;
}

inline
void CBlast4_error_Base::SetMessage(CBlast4_error_Base::TMessage&& value)
{
    m_Message = std::forward<CBlast4_error_Base::TMessage>(value);
    m_set_State[0] |= 0xc;
}

inline
CBlast4_error_Base::TMessage& CBlast4_error_Base::SetMessage(void)
{
#ifdef _DEBUG
    if (!IsSetMessage()) {
        m_Message = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Message;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_ERROR_BASE_HPP
