/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cit_proc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_CIT_PROC_BASE_HPP
#define OBJECTS_BIBLIO_CIT_PROC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCit_book;
class CMeeting;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Meeting proceedings
class NCBI_BIBLIO_EXPORT CCit_proc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCit_proc_Base(void);
    // destructor
    virtual ~CCit_proc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CCit_book TBook;
    typedef CMeeting TMeet;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_book,
        e_meet
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// citation to meeting
    /// mandatory
    /// typedef CCit_book TBook
    ///  Check whether the Book data member has been assigned a value.
    bool IsSetBook(void) const;
    /// Check whether it is safe or not to call GetBook method.
    bool CanGetBook(void) const;
    void ResetBook(void);
    const TBook& GetBook(void) const;
    void SetBook(TBook& value);
    TBook& SetBook(void);

    /// time and location of meeting
    /// mandatory
    /// typedef CMeeting TMeet
    ///  Check whether the Meet data member has been assigned a value.
    bool IsSetMeet(void) const;
    /// Check whether it is safe or not to call GetMeet method.
    bool CanGetMeet(void) const;
    void ResetMeet(void);
    const TMeet& GetMeet(void) const;
    void SetMeet(TMeet& value);
    TMeet& SetMeet(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCit_proc_Base(const CCit_proc_Base&);
    CCit_proc_Base& operator=(const CCit_proc_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TBook > m_Book;
    CRef< TMeet > m_Meet;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCit_proc_Base::IsSetBook(void) const
{
    return m_Book.NotEmpty();
}

inline
bool CCit_proc_Base::CanGetBook(void) const
{
    return true;
}

inline
const CCit_proc_Base::TBook& CCit_proc_Base::GetBook(void) const
{
    if ( !m_Book ) {
        const_cast<CCit_proc_Base*>(this)->ResetBook();
    }
    return (*m_Book);
}

inline
CCit_proc_Base::TBook& CCit_proc_Base::SetBook(void)
{
    if ( !m_Book ) {
        ResetBook();
    }
    return (*m_Book);
}

inline
bool CCit_proc_Base::IsSetMeet(void) const
{
    return m_Meet.NotEmpty();
}

inline
bool CCit_proc_Base::CanGetMeet(void) const
{
    return true;
}

inline
const CCit_proc_Base::TMeet& CCit_proc_Base::GetMeet(void) const
{
    if ( !m_Meet ) {
        const_cast<CCit_proc_Base*>(this)->ResetMeet();
    }
    return (*m_Meet);
}

inline
CCit_proc_Base::TMeet& CCit_proc_Base::SetMeet(void)
{
    if ( !m_Meet ) {
        ResetMeet();
    }
    return (*m_Meet);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_CIT_PROC_BASE_HPP
