/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cit_art_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_CIT_ART_BASE_HPP
#define OBJECTS_BIBLIO_CIT_ART_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CArticleIdSet;
class CAuth_list;
class CCit_book;
class CCit_jour;
class CCit_proc;
class CTitle;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Citation Types
/// article in journal or book
class NCBI_BIBLIO_EXPORT CCit_art_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCit_art_Base(void);
    // destructor
    virtual ~CCit_art_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// journal or book
    class NCBI_BIBLIO_EXPORT C_From : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_From(void);
        // destructor
        ~C_From(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Journal,
            e_Book,
            e_Proc
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Proc+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CCit_jour TJournal;
        typedef CCit_book TBook;
        typedef CCit_proc TProc;
    
        // getters
        // setters
    
        // typedef CCit_jour TJournal
        bool IsJournal(void) const;
        const TJournal& GetJournal(void) const;
        TJournal& SetJournal(void);
        void SetJournal(TJournal& value);
    
        // typedef CCit_book TBook
        bool IsBook(void) const;
        const TBook& GetBook(void) const;
        TBook& SetBook(void);
        void SetBook(TBook& value);
    
        // typedef CCit_proc TProc
        bool IsProc(void) const;
        const TProc& GetProc(void) const;
        TProc& SetProc(void);
        void SetProc(TProc& value);
    
    
    private:
        // copy constructor and assignment operator
        C_From(const C_From& );
        C_From& operator=(const C_From& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef CTitle TTitle;
    typedef CAuth_list TAuthors;
    typedef C_From TFrom;
    typedef CArticleIdSet TIds;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_title,
        e_authors,
        e_from,
        e_ids
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// title of paper (ANSI requires)
    /// optional
    /// typedef CTitle TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(TTitle& value);
    TTitle& SetTitle(void);

    /// authors (ANSI requires)
    /// optional
    /// typedef CAuth_list TAuthors
    ///  Check whether the Authors data member has been assigned a value.
    bool IsSetAuthors(void) const;
    /// Check whether it is safe or not to call GetAuthors method.
    bool CanGetAuthors(void) const;
    void ResetAuthors(void);
    const TAuthors& GetAuthors(void) const;
    void SetAuthors(TAuthors& value);
    TAuthors& SetAuthors(void);

    /// mandatory
    /// typedef C_From TFrom
    ///  Check whether the From data member has been assigned a value.
    bool IsSetFrom(void) const;
    /// Check whether it is safe or not to call GetFrom method.
    bool CanGetFrom(void) const;
    void ResetFrom(void);
    const TFrom& GetFrom(void) const;
    void SetFrom(TFrom& value);
    TFrom& SetFrom(void);

    /// lots of ids
    /// optional
    /// typedef CArticleIdSet TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    void SetIds(TIds& value);
    TIds& SetIds(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCit_art_Base(const CCit_art_Base&);
    CCit_art_Base& operator=(const CCit_art_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TTitle > m_Title;
    CRef< TAuthors > m_Authors;
    CRef< TFrom > m_From;
    CRef< TIds > m_Ids;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CCit_art_Base::C_From::E_Choice CCit_art_Base::C_From::Which(void) const
{
    return m_choice;
}

inline
void CCit_art_Base::C_From::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CCit_art_Base::C_From::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CCit_art_Base::C_From::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CCit_art_Base::C_From::IsJournal(void) const
{
    return m_choice == e_Journal;
}

inline
bool CCit_art_Base::C_From::IsBook(void) const
{
    return m_choice == e_Book;
}

inline
bool CCit_art_Base::C_From::IsProc(void) const
{
    return m_choice == e_Proc;
}

inline
bool CCit_art_Base::IsSetTitle(void) const
{
    return m_Title.NotEmpty();
}

inline
bool CCit_art_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CCit_art_Base::TTitle& CCit_art_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(0);
    }
    return (*m_Title);
}

inline
bool CCit_art_Base::IsSetAuthors(void) const
{
    return m_Authors.NotEmpty();
}

inline
bool CCit_art_Base::CanGetAuthors(void) const
{
    return IsSetAuthors();
}

inline
const CCit_art_Base::TAuthors& CCit_art_Base::GetAuthors(void) const
{
    if (!CanGetAuthors()) {
        ThrowUnassigned(1);
    }
    return (*m_Authors);
}

inline
bool CCit_art_Base::IsSetFrom(void) const
{
    return m_From.NotEmpty();
}

inline
bool CCit_art_Base::CanGetFrom(void) const
{
    return true;
}

inline
const CCit_art_Base::TFrom& CCit_art_Base::GetFrom(void) const
{
    if ( !m_From ) {
        const_cast<CCit_art_Base*>(this)->ResetFrom();
    }
    return (*m_From);
}

inline
CCit_art_Base::TFrom& CCit_art_Base::SetFrom(void)
{
    if ( !m_From ) {
        ResetFrom();
    }
    return (*m_From);
}

inline
bool CCit_art_Base::IsSetIds(void) const
{
    return m_Ids.NotEmpty();
}

inline
bool CCit_art_Base::CanGetIds(void) const
{
    return IsSetIds();
}

inline
const CCit_art_Base::TIds& CCit_art_Base::GetIds(void) const
{
    if (!CanGetIds()) {
        ThrowUnassigned(3);
    }
    return (*m_Ids);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_CIT_ART_BASE_HPP
