/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Author_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_AUTHOR_BASE_HPP
#define OBJECTS_BIBLIO_AUTHOR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAffil;
class CPerson_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BIBLIO_EXPORT CAuthor_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAuthor_Base(void);
    // destructor
    virtual ~CAuthor_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ELevel {
        eLevel_primary   = 1,
        eLevel_secondary = 2
    };
    
    /// Access to ELevel's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ELevel)(void);
    
    /// Author Role Indicator
    enum ERole {
        eRole_compiler        = 1,
        eRole_editor          = 2,
        eRole_patent_assignee = 3,
        eRole_translator      = 4
    };
    
    /// Access to ERole's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ERole)(void);
    
    // types
    typedef CPerson_id TName;
    typedef ELevel TLevel;
    typedef ERole TRole;
    typedef CAffil TAffil;
    typedef bool TIs_corr;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_level,
        e_role,
        e_affil,
        e_is_corr
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// Author, Primary or Secondary
    /// mandatory
    /// typedef CPerson_id TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(TName& value);
    TName& SetName(void);

    /// optional
    /// typedef ELevel TLevel
    ///  Check whether the Level data member has been assigned a value.
    bool IsSetLevel(void) const;
    /// Check whether it is safe or not to call GetLevel method.
    bool CanGetLevel(void) const;
    void ResetLevel(void);
    TLevel GetLevel(void) const;
    void SetLevel(TLevel value);
    TLevel& SetLevel(void);

    /// optional
    /// typedef ERole TRole
    ///  Check whether the Role data member has been assigned a value.
    bool IsSetRole(void) const;
    /// Check whether it is safe or not to call GetRole method.
    bool CanGetRole(void) const;
    void ResetRole(void);
    TRole GetRole(void) const;
    void SetRole(TRole value);
    TRole& SetRole(void);

    /// optional
    /// typedef CAffil TAffil
    ///  Check whether the Affil data member has been assigned a value.
    bool IsSetAffil(void) const;
    /// Check whether it is safe or not to call GetAffil method.
    bool CanGetAffil(void) const;
    void ResetAffil(void);
    const TAffil& GetAffil(void) const;
    void SetAffil(TAffil& value);
    TAffil& SetAffil(void);

    /// TRUE if corresponding author
    /// optional
    /// typedef bool TIs_corr
    ///  Check whether the Is_corr data member has been assigned a value.
    bool IsSetIs_corr(void) const;
    /// Check whether it is safe or not to call GetIs_corr method.
    bool CanGetIs_corr(void) const;
    void ResetIs_corr(void);
    TIs_corr GetIs_corr(void) const;
    void SetIs_corr(TIs_corr value);
    TIs_corr& SetIs_corr(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAuthor_Base(const CAuthor_Base&);
    CAuthor_Base& operator=(const CAuthor_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TName > m_Name;
    ELevel m_Level;
    ERole m_Role;
    CRef< TAffil > m_Affil;
    bool m_Is_corr;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAuthor_Base::IsSetName(void) const
{
    return m_Name.NotEmpty();
}

inline
bool CAuthor_Base::CanGetName(void) const
{
    return true;
}

inline
const CAuthor_Base::TName& CAuthor_Base::GetName(void) const
{
    if ( !m_Name ) {
        const_cast<CAuthor_Base*>(this)->ResetName();
    }
    return (*m_Name);
}

inline
CAuthor_Base::TName& CAuthor_Base::SetName(void)
{
    if ( !m_Name ) {
        ResetName();
    }
    return (*m_Name);
}

inline
bool CAuthor_Base::IsSetLevel(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAuthor_Base::CanGetLevel(void) const
{
    return IsSetLevel();
}

inline
void CAuthor_Base::ResetLevel(void)
{
    m_Level = (ELevel)(0);
    m_set_State[0] &= ~0xc;
}

inline
CAuthor_Base::TLevel CAuthor_Base::GetLevel(void) const
{
    if (!CanGetLevel()) {
        ThrowUnassigned(1);
    }
    return m_Level;
}

inline
void CAuthor_Base::SetLevel(CAuthor_Base::TLevel value)
{
    m_Level = value;
    m_set_State[0] |= 0xc;
}

inline
CAuthor_Base::TLevel& CAuthor_Base::SetLevel(void)
{
#ifdef _DEBUG
    if (!IsSetLevel()) {
        memset(&m_Level,UnassignedByte(),sizeof(m_Level));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Level;
}

inline
bool CAuthor_Base::IsSetRole(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAuthor_Base::CanGetRole(void) const
{
    return IsSetRole();
}

inline
void CAuthor_Base::ResetRole(void)
{
    m_Role = (ERole)(0);
    m_set_State[0] &= ~0x30;
}

inline
CAuthor_Base::TRole CAuthor_Base::GetRole(void) const
{
    if (!CanGetRole()) {
        ThrowUnassigned(2);
    }
    return m_Role;
}

inline
void CAuthor_Base::SetRole(CAuthor_Base::TRole value)
{
    m_Role = value;
    m_set_State[0] |= 0x30;
}

inline
CAuthor_Base::TRole& CAuthor_Base::SetRole(void)
{
#ifdef _DEBUG
    if (!IsSetRole()) {
        memset(&m_Role,UnassignedByte(),sizeof(m_Role));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Role;
}

inline
bool CAuthor_Base::IsSetAffil(void) const
{
    return m_Affil.NotEmpty();
}

inline
bool CAuthor_Base::CanGetAffil(void) const
{
    return IsSetAffil();
}

inline
const CAuthor_Base::TAffil& CAuthor_Base::GetAffil(void) const
{
    if (!CanGetAffil()) {
        ThrowUnassigned(3);
    }
    return (*m_Affil);
}

inline
bool CAuthor_Base::IsSetIs_corr(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAuthor_Base::CanGetIs_corr(void) const
{
    return IsSetIs_corr();
}

inline
void CAuthor_Base::ResetIs_corr(void)
{
    m_Is_corr = 0;
    m_set_State[0] &= ~0x300;
}

inline
CAuthor_Base::TIs_corr CAuthor_Base::GetIs_corr(void) const
{
    if (!CanGetIs_corr()) {
        ThrowUnassigned(4);
    }
    return m_Is_corr;
}

inline
void CAuthor_Base::SetIs_corr(CAuthor_Base::TIs_corr value)
{
    m_Is_corr = value;
    m_set_State[0] |= 0x300;
}

inline
CAuthor_Base::TIs_corr& CAuthor_Base::SetIs_corr(void)
{
#ifdef _DEBUG
    if (!IsSetIs_corr()) {
        memset(&m_Is_corr,UnassignedByte(),sizeof(m_Is_corr));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Is_corr;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_AUTHOR_BASE_HPP
