/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.util.StringUtil;
import java.util.Arrays;

public class EncodingDescriptor {
    private final EncodingID encodingID;
    private final byte[] encodingParameters;

    public EncodingDescriptor(EncodingID encodingID, byte[] encodingParameters) {
        this.encodingID = encodingID;
        this.encodingParameters = encodingParameters;
    }

    public EncodingID getEncodingID() {
        return this.encodingID;
    }

    public byte[] getEncodingParameters() {
        return this.encodingParameters;
    }

    public String toString() {
        return String.format("%s: (%s)", this.getEncodingID().name(), StringUtil.bytesToHexString(Arrays.copyOfRange(this.getEncodingParameters(), 0, Math.max(20, this.getEncodingParameters().length))));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingDescriptor that = (EncodingDescriptor)o;
        if (this.getEncodingID() != that.getEncodingID()) {
            return false;
        }
        return Arrays.equals(this.getEncodingParameters(), that.getEncodingParameters());
    }

    public int hashCode() {
        int result = this.getEncodingID().hashCode();
        result = 31 * result + Arrays.hashCode(this.getEncodingParameters());
        return result;
    }
}

