//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _WAYPOINTLIST_H 
#define _WAYPOINTLIST_H 

#include "wpt_type.h"
#include <vector>


namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// This class holds a list of waypoints.
class Waypointlist : GPDLineTool, Constants
{
   
   public: 
      typedef vector<Wpt_Type> Waypoints;
      
      /// creates an empty waypoint list
      Waypointlist(void); 

      /// returns the gpd-string of the i-th waypoint 
      string operator[] (int t);        //

      /// returns the number of waypoints in the list
      int size(void);


      /// add data in gpd format
      void is(string);
      /// same as is , for convenience
      void operator<<(string);

      /// adds an additionanl waypoint
      void add(Wpt_Type);

      /// output the whole data as a String
      string os(void);

      /// 
      void os(ostream &);

      /// Sorts and uniquefies the waypoint names to n-letters. (TODO)
      /** 
       This is usefull  for devices tha will overwrite identically named waypoints.
       KARLSRUHE and KARLSRUHE-BAHNHOF will be renamed to KARLS1 and KARLS2
       other wise the second would overwrite the first in the gps-device.
      */
      void makeUnique(int n);

      /// return the ith waypoint
      const Wpt_Type &get(unsigned int i) const { return waypointlist[i]; }

      /// return the ith waypoint
      Wpt_Type &get(unsigned int i) { return waypointlist[i]; }

      /// return the list name
      const string &getName() const { return name; }

      /// return the vector of waypoints
      const Waypoints &getList() const { return waypointlist; }
      
      /// check whether the waypoints list is empty
      bool empty() const { return waypointlist.empty(); }
      
      /// clear the list
      void clear() { waypointlist.clear(); } 

   protected:
      Waypoints waypointlist;
      string name;

   private:

};

}
#endif 
