/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.ClasspathToolkit;
import java.awt.AWTException;
import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.peer.RobotPeer;
import java.lang.reflect.InvocationTargetException;

public class Robot {
    private boolean waitForIdle;
    private int autoDelay;
    private RobotPeer peer;

    public void mouseMove(int x, int y) {
        this.peer.mouseMove(x, y);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void mousePress(int buttons) {
        if ((buttons & 0x10) == 0 && (buttons & 8) == 0 && (buttons & 4) == 0) {
            throw new IllegalArgumentException("Robot: mousePress: invalid button mask");
        }
        this.peer.mousePress(buttons);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void mouseRelease(int buttons) {
        if ((buttons & 0x10) == 0 && (buttons & 8) == 0 && (buttons & 4) == 0) {
            throw new IllegalArgumentException("Robot: mouseRelease: invalid button mask");
        }
        this.peer.mouseRelease(buttons);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void mouseWheel(int wheelAmt) {
        this.peer.mouseWheel(wheelAmt);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void keyPress(int keycode) {
        this.peer.keyPress(keycode);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public void keyRelease(int keycode) {
        this.peer.keyRelease(keycode);
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        if (this.autoDelay > 0) {
            this.delay(this.autoDelay);
        }
    }

    public Color getPixelColor(int x, int y) {
        return new Color(this.peer.getRGBPixel(x, y));
    }

    public BufferedImage createScreenCapture(Rectangle screenRect) {
        if (screenRect.width <= 0) {
            throw new IllegalArgumentException("Robot: capture width is <= 0");
        }
        if (screenRect.height <= 0) {
            throw new IllegalArgumentException("Robot: capture height is <= 0");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("readDisplayPixels"));
        }
        int[] pixels = this.peer.getRGBPixels(screenRect);
        BufferedImage bufferedImage = new BufferedImage(screenRect.width, screenRect.height, 2);
        bufferedImage.setRGB(0, 0, screenRect.width, screenRect.height, pixels, 0, screenRect.width);
        return bufferedImage;
    }

    public boolean isAutoWaitForIdle() {
        return this.waitForIdle;
    }

    public void setAutoWaitForIdle(boolean isOn) {
        this.waitForIdle = isOn;
    }

    public int getAutoDelay() {
        return this.autoDelay;
    }

    public void setAutoDelay(int ms) {
        if (ms <= 0 || ms >= 60000) {
            throw new IllegalArgumentException("Robot: delay length out-of-bounds");
        }
        this.autoDelay = ms;
    }

    public void delay(int ms) {
        if (ms < 0 || ms > 60000) {
            throw new IllegalArgumentException("Robot: delay length out-of-bounds");
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            System.err.println("Robot: delay interrupted");
        }
    }

    public void waitForIdle() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Robot: waitForIdle called from the event dispatch thread");
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public final void run() {
                }
            });
        }
        catch (InterruptedException e) {
            System.err.println("Robot: waitForIdle interrupted");
        }
        catch (InvocationTargetException e) {
            System.err.println("Robot: waitForIdle cannot invoke target");
        }
    }

    public String toString() {
        return this.getClass().getName() + "[ autoDelay = " + this.autoDelay + ", autoWaitForIdle = " + this.waitForIdle + " ]";
    }

    public Robot() throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new AWTException("Robot: headless graphics environment");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("createRobot"));
        }
        ClasspathToolkit tk = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = tk.createRobot(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public Robot(GraphicsDevice screen) throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new AWTException("Robot: headless graphics environment");
        }
        if (screen.getType() != 0) {
            throw new IllegalArgumentException("Robot: graphics device is not a screen");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("createRobot"));
        }
        ClasspathToolkit tk = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = tk.createRobot(screen);
    }
}

