# Code Review plugin for Redmine
# Copyright (C) 2009-2023  Haruyuki Iida
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

require_dependency 'issue'

module CodeReviewIssuePatch
  def self.included(base) # :nodoc:
    base.send(:include, IssueInstanceMethodsCodeReview)

    base.class_eval do
      has_one :code_review, :dependent => :destroy
      has_one :code_review_assignment, :dependent => :destroy
    end
  end
end

module IssueInstanceMethodsCodeReview
end

Issue.send(:include, CodeReviewIssuePatch)