// Generated by gmmproc 2.50.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_TASK_H
#define _GSTREAMERMM_TASK_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2015 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/object.h>
#include <glibmm/threads.h>
#include <memory>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstTask = struct _GstTask;
using GstTaskClass = struct _GstTaskClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class Task_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var TaskState TASK_STARTED
 * The task is started and running.
 * 
 *  @var TaskState TASK_STOPPED
 * The task is stopped.
 * 
 *  @var TaskState TASK_PAUSED
 * The task is paused.
 * 
 *  @enum TaskState
 * 
 * The different states a task can be in
 *
 * @ingroup gstreamermmEnums
 */
enum TaskState
{
  TASK_STARTED,
  TASK_STOPPED,
  TASK_PAUSED
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TaskState> : public Glib::Value_Enum<Gst::TaskState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


class TaskPool;

/** A class representing GStreamer streaming threads.
 * Gst::Task is used by Gst::Element and Gst::Pad to provide the data passing
 * threads in a Gst::Pipeline.
 *
 * A Gst::Pad will typically start a Gst::Task to push or pull data to/from the
 * peer pads. Most source elements start a Gst::Task to push data. In some
 * cases a demuxer element can start a Gst::Task to pull data from a peer
 * element. This is typically done when the demuxer can perform random access
 * on the upstream peer element for improved performance.
 *
 * Although convenience functions exist on Gst::Pad to start/pause/stop tasks,
 * it might sometimes be needed to create a Gst::Task manually if it is not
 * related to a Gst::Pad.
 *
 * Before the Gst::Task can be run, it needs a Glib::StaticRecMutex that can be
 * set with set_lock().
 *
 * The task can be started, paused and stopped with start(), pause() and stop()
 * respectively.
 *
 * A Gst::Task will repeadedly call the Gst::Task::SlotTask that was provided
 * when creating the task with create(). Before calling the function it will
 * acquire the provided lock.
 *
 * Stopping a task with stop() will not immediatly make sure the task is not
 * running anymore. Use join() to make sure the task is completely stopped and
 * the thread is stopped.
 *
 * Task functions can send a Gst::Message to send out-of-band data to the
 * application. The application can receive messages from the Gst::Bus in its
 * mainloop.
 *
 * For debugging purposes, the task will configure its object name as the thread
 * name on Linux. Please note that the object name should be configured before the
 * task is started; changing the object name after the task has been started, has
 * no effect on the thread name.
 *
 * Last reviewed on 2015-10-14 (1.5.2)
 */

class Task : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Task;
  using CppClassType = Task_Class;
  using BaseObjectType = GstTask;
  using BaseClassType = GstTaskClass;

  // noncopyable
  Task(const Task&) = delete;
  Task& operator=(const Task&) = delete;

private:  friend class Task_Class;
  static CppClassType task_class_;

protected:
  explicit Task(const Glib::ConstructParams& construct_params);
  explicit Task(GstTask* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Task(Task&& src) noexcept;
  Task& operator=(Task&& src) noexcept;

  ~Task() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstTask*       gobj()       { return reinterpret_cast<GstTask*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstTask* gobj() const { return reinterpret_cast<GstTask*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstTask* gobj_copy();

private:


public:
  /** For example,
   * void on_do_task();.
   */
  typedef sigc::slot<void> SlotTask;

  /**
   * Bidirectional slot
   */
  typedef sigc::slot<void, const Glib::RefPtr<Gst::Task>&,
          Glib::Threads::Thread*> TaskThreadSlot;
  /** For example,
   * void on_enter(const Glib::RefPtr<Gst::Task>& task, Glib::Threads::Thread&
   * thread);.
   * A thread is entered, this slot is called when the new thread enters its
   * function.
   */
   typedef TaskThreadSlot SlotEnter;

  /** For example,
   * void on_leave(const Glib::RefPtr<Gst::Task>& task, Glib::Threads::Thread&
   * thread);.
   * A thread is exiting, this is called when the thread is about to leave its
   * function.
   */
    typedef TaskThreadSlot SlotLeave;

protected:
  explicit Task(const SlotTask& task_slot);

public:
  /** Create a new Gst::Task that will repeatedly call the provided slot as a
   * parameter. Typically the task will run in a new thread.
   *
   * The slot cannot be changed after the task has been created. You must
   * create a new Gst::Task to change the slot.
   *
   * @param task_slot The Gst::Task::SlotTask to use.
   * @return A new Gst::Task. MT safe.
   */
  
  static Glib::RefPtr<Task> create(const SlotTask& task_slot);


  /** Set the mutex used by the task. The mutex will be acquired before
   * calling the Gst::TaskFunction.
   * 
   * This function has to be called before calling pause() or
   * start().
   * 
   * MT safe.
   * 
   * @param mutex The RecMutex to use.
   */
  void set_lock(Glib::Threads::RecMutex& mutex);
  
  /** Set @a pool as the new GstTaskPool for @a task. Any new streaming threads that
   * will be created by @a task will now use @a pool.
   * 
   * MT safe.
   * 
   * @param pool A Gst::TaskPool.
   */
  void set_pool(const Glib::RefPtr<Gst::TaskPool>& pool);
  
  /** Get the Gst::TaskPool that this task will use for its streaming
   * threads.
   * 
   * MT safe.
   * 
   * @return The Gst::TaskPool used by @a task. Gst::Object::unref()
   * after usage.
   */
  Glib::RefPtr<Gst::TaskPool> get_pool();
  
  /** Get the Gst::TaskPool that this task will use for its streaming
   * threads.
   * 
   * MT safe.
   * 
   * @return The Gst::TaskPool used by @a task. Gst::Object::unref()
   * after usage.
   */
  Glib::RefPtr<const Gst::TaskPool> get_pool() const;

  /** Call enter_slot when the task function of task is entered.
   *
   * @param enter_slot
   */
  void set_enter_slot(const SlotEnter& enter_slot);
  

  /** Call leave_func when the task function of task is left.
   *
   * @param leave_slot
   */
  void set_leave_slot(const SlotLeave& leave_slot);
  

  /** Get the current state of the task.
   * 
   * @return The Gst::TaskState of the task
   * 
   * MT safe.
   */
  TaskState get_state() const;
  
  /** Sets the state of @a task to @a state.
   * 
   * The @a task must have a lock associated with it using
   * set_lock() when going to GST_TASK_STARTED or GST_TASK_PAUSED or
   * this function will return <tt>false</tt>.
   * 
   * MT safe.
   * 
   * @param state The new task state.
   * @return <tt>true</tt> if the state could be changed.
   */
  void set_state(Gst::TaskState state);
  
  /** Pauses @a task. This method can also be called on a task in the
   * stopped state, in which case a thread will be started and will remain
   * in the paused state. This function does not wait for the task to complete
   * the paused state.
   * 
   * @return <tt>true</tt> if the task could be paused.
   * 
   * MT safe.
   */
  bool pause();
  
  /** Starts @a task. The @a task must have a lock associated with it using
   * set_lock() or this function will return <tt>false</tt>.
   * 
   * @return <tt>true</tt> if the task could be started.
   * 
   * MT safe.
   */
  bool start();
  
  /** Stops @a task. This method merely schedules the task to stop and
   * will not wait for the task to have completely stopped. Use
   * join() to stop and wait for completion.
   * 
   * @return <tt>true</tt> if the task could be stopped.
   * 
   * MT safe.
   */
  bool stop();
  
  /** Joins @a task. After this call, it is safe to unref the task
   * and clean up the lock set with set_lock().
   * 
   * The task will automatically be stopped with this call.
   * 
   * This function cannot be called from within a task function as this
   * would cause a deadlock. The function will detect this and print a
   * g_warning.
   * 
   * @return <tt>true</tt> if the task could be joined.
   * 
   * MT safe.
   */
  bool join();
  
  /** Wait for all tasks to be stopped. This is mainly used internally
   * to ensure proper cleanup of internal data structures in test suites.
   * 
   * MT safe.
   */
  static void cleanup_all();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  // todo this slot should be moved in move constructor, but for now it's
  // impossible to provide custom move constructor
  // (see https://bugzilla.gnome.org/show_bug.cgi?id=756593).
  // However, task should be managed by RefPtr class, so move constructor
  // and move assignment operator will never be called.
  std::unique_ptr<SlotTask> m_slot;
#endif


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Task
   */
  Glib::RefPtr<Gst::Task> wrap(GstTask* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_TASK_H */

