/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;

public class JpegMetadataReader {
    public static Metadata readMetadata(InputStream inputStream) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(inputStream);
        return JpegMetadataReader.extractJpegSegmentReaderMetadata(jpegSegmentReader);
    }

    public static Metadata readMetadata(File file) throws FileNotFoundException, JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        return JpegMetadataReader.extractJpegSegmentReaderMetadata(jpegSegmentReader);
    }

    private static Metadata extractJpegSegmentReaderMetadata(JpegSegmentReader jpegSegmentReader) {
        byte[] byArray;
        Metadata metadata = new Metadata();
        try {
            byArray = jpegSegmentReader.readSegment((byte)-31);
            new ExifReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-19);
            new IptcReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        return metadata;
    }

    public static Metadata readMetadata(JPEGDecodeParam jPEGDecodeParam) {
        byte[][] byArray;
        Metadata metadata = new Metadata();
        byte[][] byArray2 = jPEGDecodeParam.getMarkerData(225);
        if (byArray2 != null && byArray2[0].length > 0) {
            new ExifReader(byArray2[0]).extract();
        }
        if ((byArray = jPEGDecodeParam.getMarkerData(237)) != null && byArray[0].length > 0) {
            new IptcReader(byArray[0]).extract();
        }
        return metadata;
    }

    private JpegMetadataReader() {
    }

    public static void main(String[] stringArray) {
        JpegMetadataReader jpegMetadataReader = new JpegMetadataReader();
        Metadata metadata = null;
        try {
            metadata = JpegMetadataReader.readMetadata(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
        Iterator iterator = metadata.getDirectoryIterator();
        while (iterator.hasNext()) {
            Object object;
            Directory directory = (Directory)iterator.next();
            Iterator iterator2 = directory.getTagIterator();
            while (iterator2.hasNext()) {
                object = (Tag)iterator2.next();
                try {
                    System.out.println("[" + directory.getName() + "] " + ((Tag)object).getTagName() + " = " + ((Tag)object).getDescription());
                }
                catch (MetadataException metadataException) {
                    System.err.println(metadataException.getMessage());
                    System.err.println(((Tag)object).getDirectoryName() + " " + ((Tag)object).getTagName() + " <error>");
                }
            }
            if (!directory.hasErrors()) continue;
            object = directory.getErrors();
            while (object.hasNext()) {
                System.out.println("ERROR: " + object.next());
            }
        }
    }
}

