;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Performs the Regression Example on the  Jobs Prestige data reported
;;in the Young & Bann chapter in Stein's Data Analysis book.

(when *guidemap* (send *guidemap* :close))
(show-workmap)
(load-data (strcat *examples-data-dir-name* "jobs.lsp"))

(regression-analysis
      :response '("prestige")
      :predictors '("Income" "Education"))

(regression-analysis
      :method "robust"
      :response '("prestige")
      :predictors '("Income" "Education"))

(list-observations)
(select-observations '("Minister" "Reporter" "RR Engineer" "RR Conductor"))
(remove-selected-data)
;(send *obs-window* :close)
(create-data "JobSubset")

(regression-analysis
       :response '("prestige")
       :predictors '("Education" "Income"))

(regression-analysis
       :method "monotonic"
       :response '("prestige")
       :predictors '("Education" "Income"))
(visualize-model)
(report-model)

(vista-message "Young & Bann Regression Example Finished")