var Entry = function(){
	this.initialize(arguments[0],arguments[1]);
}
Entry.currentLabel = null;
Entry.allLength = 0;
Entry.selectedLength = 0;

Entry.Render = function(){
	while($("all_entry_list").firstChild){
		$("all_entry_list").removeChild($("all_entry_list").firstChild);
	}
	Entry.allLength = 0;
	
	Entries.each(function(ele){
		
		if(!Entry.currentLabel || ele.value.label.indexOf(Entry.currentLabel) != -1){
			ele.value.buildTable($("all_entry_list"));
			
		}
	});
	
	Entry.RenderTitle();

}

Entry.RenderTitle = function(){
	$("all_entry_title").innerHTML = soycms.lang.entry_selector.entry_list +" ("+Entry.allLength+soycms.lang.entry_selector.items+")"
	$("selected_entry_title").innerHTML = soycms.lang.entry_selector.selected_entry+"( "+Entry.selectedLength+soycms.lang.entry_selector.items+")"
}


Entry.prototype = {

	id : null,
	title : null,
	label : new Array(),
	selected : false,
	order : null,
	
	initialize : function(obj){
		this.id = obj.id;
		this.title = obj.id+"\t:\t"+obj.title;
		this.label = obj.label;
	},
	
	buildTable : function(target){
		
		var option = document.createElement("option");
		option.value = this.id;
		
		option.innerHTML = this.title;
		
		option.id = "entry_"+this.id;
	
		option.setAttribute("className","free");
		option.setAttribute("class","free");
		
		target.appendChild(option);
		
		Entry.allLength++;
	},
	
	buildSelectedTable : function(target){
		var option = document.createElement("option");
		option.value = this.id;
		
		option.innerHTML = this.title;
		option.setAttribute("className","selected");
		option.setAttribute("class","selected");
		
		target.appendChild(option);
		
		Entry.selectedLength ++;
	}

}

var Entries = new Hash();

window.onload = function(){
	entryList.each(function(ele){
		var entry = new Entry(ele);
		Entries.set(ele.id,entry);
	});

	initEntries.each(function(ele){
		Entries.get(ele.id).buildSelectedTable($("selected_entry_list"));
	});
	
	//$("outlineFrame").src = outlineLink;
	
	
	$("all_entry_list").onchange = function(){
		$("up_button").disabled = "disabled";
		$("down_button").disabled = "disabled";
		$("move_button").value = soycms.lang.entry_selector.entry_add;
		$("selected_entry_list").selectedIndex = -1;
		
	}
	
	$("selected_entry_list").onchange = function(){
		$("up_button").disabled = "";
		$("down_button").disabled = "";
		$("move_button").value = soycms.lang.entry_selector.entry_delete;
		$("all_entry_list").selectedIndex = -1;
	}
	
	//For use in block setting
	if($("update")){
		$("update").onclick = function(){
			var ids = new Array();
		
			$$(".selected").each(function(ele){
				ids.push(ele.value);
			});
			
			var form = document.update_form;
			form.method = "POST";
			form.style.display = "none";

			ids.each(function(ele){
				var input = document.createElement("input");
				input.type="hidden"
				input.value = ele;
				input.name = "object[entryId][]";
				form.appendChild(input);
			});
			document.body.appendChild(form);
			form.submit();
		
		}
	}
	
	if($("move_entry_form")){
		$("move_entry_form").onclick = function(){
			window.location.href = entry_form_address;
		}
	}
	
	$("move_button").onclick = function(){
		if($("selected_entry_list").value){
			//Remove selected entry
			var option = $("selected_entry_list").childNodes[$("selected_entry_list").selectedIndex];
			$("selected_entry_list").removeChild(option);
			Entry.selectedLength--;
		}else if($("all_entry_list").value){
			//Select from all entries
			var dom_id = "entry_"+$("all_entry_list").value;
			
			var clone = $(dom_id).cloneNode(true);
			clone.id = null;
			clone.setAttribute("className","selected");
			clone.setAttribute("class","selected");
			
			
			$("selected_entry_list").appendChild(clone);
			Entry.selectedLength++;
		}else{
			//do nothing
		}
		
		Entry.RenderTitle();
	
	}
	
	$("up_button").onclick = function(){
		var option = $("selected_entry_list").childNodes[$("selected_entry_list").selectedIndex];
		if(option.previousSibling){
			$("selected_entry_list").insertBefore(option,option.previousSibling);
		}
	}
	
	$("down_button").onclick = function(){
		var option = $("selected_entry_list").childNodes[$("selected_entry_list").selectedIndex];
		if(option.nextSibling){
			$("selected_entry_list").insertBefore(option.nextSibling,option);
		}
	}
	
	$("display_outline").onclick = function(){
		var selectedEntryId = null;
		if($("selected_entry_list").value){
			selectedEntryId = $("selected_entry_list").value;
		}
		if($("all_entry_list").value){
			selectedEntryId = $("all_entry_list").value;
		}
		
		if(selectedEntryId){
			$("outlineFrame").src = outlineLink+"/"+selectedEntryId;
		}

	
	}
	
	Entry.Render();
	
	
}

function labelFilter(value){

	if(value == "##NO_FILTER##"){
		Entry.currentLabel = null;
	}else{
		Entry.currentLabel = value;
	}
	Entry.Render();
}
