require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NET_PFVAR_H_)) {
    eval 'sub _NET_PFVAR_H_ () {1;}' unless defined(&_NET_PFVAR_H_);
    if(defined(&_KERNEL_OPT)) {
	require './net/opt_inet.ph';
    }
    require 'sys/param.ph';
    require 'sys/types.ph';
    require 'sys/queue.ph';
    require 'sys/tree.ph';
    require 'sys/rwlock.ph';
    require 'net/radix.ph';
    unless(defined(&__NetBSD__)) {
	require 'net/route.ph';
	require 'netinet/ip_ipsp.ph';
    } else {
	require 'netinet/in.ph';
    }
    require 'netinet/tcp_fsm.ph';
    if(defined(&__NetBSD__)  && defined(&_KERNEL)) {
	require 'net/if_compat.ph';
	require 'net/pf_mtag.ph';
    }
    eval 'sub PF_TCPS_PROXY_SRC () {(( &TCP_NSTATES)+0);}' unless defined(&PF_TCPS_PROXY_SRC);
    eval 'sub PF_TCPS_PROXY_DST () {(( &TCP_NSTATES)+1);}' unless defined(&PF_TCPS_PROXY_DST);
    eval 'sub PF_MD5_DIGEST_LENGTH () {16;}' unless defined(&PF_MD5_DIGEST_LENGTH);
    if(defined(&MD5_DIGEST_LENGTH)) {
	if((defined(&PF_MD5_DIGEST_LENGTH) ? &PF_MD5_DIGEST_LENGTH : undef) != (defined(&MD5_DIGEST_LENGTH) ? &MD5_DIGEST_LENGTH : undef)) {
	}
    }
    eval("sub PF_INOUT () { 0; }") unless defined(&PF_INOUT);
    eval("sub PF_IN () { 1; }") unless defined(&PF_IN);
    eval("sub PF_OUT () { 2; }") unless defined(&PF_OUT);
    eval("sub PF_LAN_EXT () { 0; }") unless defined(&PF_LAN_EXT);
    eval("sub PF_EXT_GWY () { 1; }") unless defined(&PF_EXT_GWY);
    eval("sub PF_ID () { 2; }") unless defined(&PF_ID);
    eval("sub PF_PASS () { 0; }") unless defined(&PF_PASS);
    eval("sub PF_DROP () { 1; }") unless defined(&PF_DROP);
    eval("sub PF_SCRUB () { 2; }") unless defined(&PF_SCRUB);
    eval("sub PF_NOSCRUB () { 3; }") unless defined(&PF_NOSCRUB);
    eval("sub PF_NAT () { 4; }") unless defined(&PF_NAT);
    eval("sub PF_NONAT () { 5; }") unless defined(&PF_NONAT);
    eval("sub PF_BINAT () { 6; }") unless defined(&PF_BINAT);
    eval("sub PF_NOBINAT () { 7; }") unless defined(&PF_NOBINAT);
    eval("sub PF_RDR () { 8; }") unless defined(&PF_RDR);
    eval("sub PF_NORDR () { 9; }") unless defined(&PF_NORDR);
    eval("sub PF_SYNPROXY_DROP () { 10; }") unless defined(&PF_SYNPROXY_DROP);
    eval("sub PF_RULESET_SCRUB () { 0; }") unless defined(&PF_RULESET_SCRUB);
    eval("sub PF_RULESET_FILTER () { 1; }") unless defined(&PF_RULESET_FILTER);
    eval("sub PF_RULESET_NAT () { 2; }") unless defined(&PF_RULESET_NAT);
    eval("sub PF_RULESET_BINAT () { 3; }") unless defined(&PF_RULESET_BINAT);
    eval("sub PF_RULESET_RDR () { 4; }") unless defined(&PF_RULESET_RDR);
    eval("sub PF_RULESET_MAX () { 5; }") unless defined(&PF_RULESET_MAX);
    eval("sub PF_OP_NONE () { 0; }") unless defined(&PF_OP_NONE);
    eval("sub PF_OP_IRG () { 1; }") unless defined(&PF_OP_IRG);
    eval("sub PF_OP_EQ () { 2; }") unless defined(&PF_OP_EQ);
    eval("sub PF_OP_NE () { 3; }") unless defined(&PF_OP_NE);
    eval("sub PF_OP_LT () { 4; }") unless defined(&PF_OP_LT);
    eval("sub PF_OP_LE () { 5; }") unless defined(&PF_OP_LE);
    eval("sub PF_OP_GT () { 6; }") unless defined(&PF_OP_GT);
    eval("sub PF_OP_GE () { 7; }") unless defined(&PF_OP_GE);
    eval("sub PF_OP_XRG () { 8; }") unless defined(&PF_OP_XRG);
    eval("sub PF_OP_RRG () { 9; }") unless defined(&PF_OP_RRG);
    eval("sub PF_DEBUG_NONE () { 0; }") unless defined(&PF_DEBUG_NONE);
    eval("sub PF_DEBUG_URGENT () { 1; }") unless defined(&PF_DEBUG_URGENT);
    eval("sub PF_DEBUG_MISC () { 2; }") unless defined(&PF_DEBUG_MISC);
    eval("sub PF_DEBUG_NOISY () { 3; }") unless defined(&PF_DEBUG_NOISY);
    eval("sub PF_CHANGE_NONE () { 0; }") unless defined(&PF_CHANGE_NONE);
    eval("sub PF_CHANGE_ADD_HEAD () { 1; }") unless defined(&PF_CHANGE_ADD_HEAD);
    eval("sub PF_CHANGE_ADD_TAIL () { 2; }") unless defined(&PF_CHANGE_ADD_TAIL);
    eval("sub PF_CHANGE_ADD_BEFORE () { 3; }") unless defined(&PF_CHANGE_ADD_BEFORE);
    eval("sub PF_CHANGE_ADD_AFTER () { 4; }") unless defined(&PF_CHANGE_ADD_AFTER);
    eval("sub PF_CHANGE_REMOVE () { 5; }") unless defined(&PF_CHANGE_REMOVE);
    eval("sub PF_CHANGE_GET_TICKET () { 6; }") unless defined(&PF_CHANGE_GET_TICKET);
    eval("sub PF_GET_NONE () { 0; }") unless defined(&PF_GET_NONE);
    eval("sub PF_GET_CLR_CNTR () { 1; }") unless defined(&PF_GET_CLR_CNTR);
    eval("sub PFTM_TCP_FIRST_PACKET () { 0; }") unless defined(&PFTM_TCP_FIRST_PACKET);
    eval("sub PFTM_TCP_OPENING () { 1; }") unless defined(&PFTM_TCP_OPENING);
    eval("sub PFTM_TCP_ESTABLISHED () { 2; }") unless defined(&PFTM_TCP_ESTABLISHED);
    eval("sub PFTM_TCP_CLOSING () { 3; }") unless defined(&PFTM_TCP_CLOSING);
    eval("sub PFTM_TCP_FIN_WAIT () { 4; }") unless defined(&PFTM_TCP_FIN_WAIT);
    eval("sub PFTM_TCP_CLOSED () { 5; }") unless defined(&PFTM_TCP_CLOSED);
    eval("sub PFTM_UDP_FIRST_PACKET () { 6; }") unless defined(&PFTM_UDP_FIRST_PACKET);
    eval("sub PFTM_UDP_SINGLE () { 7; }") unless defined(&PFTM_UDP_SINGLE);
    eval("sub PFTM_UDP_MULTIPLE () { 8; }") unless defined(&PFTM_UDP_MULTIPLE);
    eval("sub PFTM_ICMP_FIRST_PACKET () { 9; }") unless defined(&PFTM_ICMP_FIRST_PACKET);
    eval("sub PFTM_ICMP_ERROR_REPLY () { 10; }") unless defined(&PFTM_ICMP_ERROR_REPLY);
    eval("sub PFTM_OTHER_FIRST_PACKET () { 11; }") unless defined(&PFTM_OTHER_FIRST_PACKET);
    eval("sub PFTM_OTHER_SINGLE () { 12; }") unless defined(&PFTM_OTHER_SINGLE);
    eval("sub PFTM_OTHER_MULTIPLE () { 13; }") unless defined(&PFTM_OTHER_MULTIPLE);
    eval("sub PFTM_FRAG () { 14; }") unless defined(&PFTM_FRAG);
    eval("sub PFTM_INTERVAL () { 15; }") unless defined(&PFTM_INTERVAL);
    eval("sub PFTM_ADAPTIVE_START () { 16; }") unless defined(&PFTM_ADAPTIVE_START);
    eval("sub PFTM_ADAPTIVE_END () { 17; }") unless defined(&PFTM_ADAPTIVE_END);
    eval("sub PFTM_SRC_NODE () { 18; }") unless defined(&PFTM_SRC_NODE);
    eval("sub PFTM_TS_DIFF () { 19; }") unless defined(&PFTM_TS_DIFF);
    eval("sub PFTM_MAX () { 20; }") unless defined(&PFTM_MAX);
    eval("sub PFTM_PURGE () { 21; }") unless defined(&PFTM_PURGE);
    eval("sub PFTM_UNLINKED () { 22; }") unless defined(&PFTM_UNLINKED);
    eval("sub PFTM_UNTIL_PACKET () { 23; }") unless defined(&PFTM_UNTIL_PACKET);
    eval 'sub PFTM_TCP_FIRST_PACKET_VAL () {120;}' unless defined(&PFTM_TCP_FIRST_PACKET_VAL);
    eval 'sub PFTM_TCP_OPENING_VAL () {30;}' unless defined(&PFTM_TCP_OPENING_VAL);
    eval 'sub PFTM_TCP_ESTABLISHED_VAL () {24*60*60;}' unless defined(&PFTM_TCP_ESTABLISHED_VAL);
    eval 'sub PFTM_TCP_CLOSING_VAL () {15* 60;}' unless defined(&PFTM_TCP_CLOSING_VAL);
    eval 'sub PFTM_TCP_FIN_WAIT_VAL () {45;}' unless defined(&PFTM_TCP_FIN_WAIT_VAL);
    eval 'sub PFTM_TCP_CLOSED_VAL () {90;}' unless defined(&PFTM_TCP_CLOSED_VAL);
    eval 'sub PFTM_UDP_FIRST_PACKET_VAL () {60;}' unless defined(&PFTM_UDP_FIRST_PACKET_VAL);
    eval 'sub PFTM_UDP_SINGLE_VAL () {30;}' unless defined(&PFTM_UDP_SINGLE_VAL);
    eval 'sub PFTM_UDP_MULTIPLE_VAL () {60;}' unless defined(&PFTM_UDP_MULTIPLE_VAL);
    eval 'sub PFTM_ICMP_FIRST_PACKET_VAL () {20;}' unless defined(&PFTM_ICMP_FIRST_PACKET_VAL);
    eval 'sub PFTM_ICMP_ERROR_REPLY_VAL () {10;}' unless defined(&PFTM_ICMP_ERROR_REPLY_VAL);
    eval 'sub PFTM_OTHER_FIRST_PACKET_VAL () {60;}' unless defined(&PFTM_OTHER_FIRST_PACKET_VAL);
    eval 'sub PFTM_OTHER_SINGLE_VAL () {30;}' unless defined(&PFTM_OTHER_SINGLE_VAL);
    eval 'sub PFTM_OTHER_MULTIPLE_VAL () {60;}' unless defined(&PFTM_OTHER_MULTIPLE_VAL);
    eval 'sub PFTM_FRAG_VAL () {30;}' unless defined(&PFTM_FRAG_VAL);
    eval 'sub PFTM_INTERVAL_VAL () {10;}' unless defined(&PFTM_INTERVAL_VAL);
    eval 'sub PFTM_SRC_NODE_VAL () {0;}' unless defined(&PFTM_SRC_NODE_VAL);
    eval 'sub PFTM_TS_DIFF_VAL () {30;}' unless defined(&PFTM_TS_DIFF_VAL);
    eval("sub PF_NOPFROUTE () { 0; }") unless defined(&PF_NOPFROUTE);
    eval("sub PF_FASTROUTE () { 1; }") unless defined(&PF_FASTROUTE);
    eval("sub PF_ROUTETO () { 2; }") unless defined(&PF_ROUTETO);
    eval("sub PF_DUPTO () { 3; }") unless defined(&PF_DUPTO);
    eval("sub PF_REPLYTO () { 4; }") unless defined(&PF_REPLYTO);
    eval("sub PF_LIMIT_STATES () { 0; }") unless defined(&PF_LIMIT_STATES);
    eval("sub PF_LIMIT_SRC_NODES () { 1; }") unless defined(&PF_LIMIT_SRC_NODES);
    eval("sub PF_LIMIT_FRAGS () { 2; }") unless defined(&PF_LIMIT_FRAGS);
    eval("sub PF_LIMIT_TABLES () { 3; }") unless defined(&PF_LIMIT_TABLES);
    eval("sub PF_LIMIT_TABLE_ENTRIES () { 4; }") unless defined(&PF_LIMIT_TABLE_ENTRIES);
    eval("sub PF_LIMIT_MAX () { 5; }") unless defined(&PF_LIMIT_MAX);
    eval 'sub PF_POOL_IDMASK () {0xf;}' unless defined(&PF_POOL_IDMASK);
    eval("sub PF_POOL_NONE () { 0; }") unless defined(&PF_POOL_NONE);
    eval("sub PF_POOL_BITMASK () { 1; }") unless defined(&PF_POOL_BITMASK);
    eval("sub PF_POOL_RANDOM () { 2; }") unless defined(&PF_POOL_RANDOM);
    eval("sub PF_POOL_SRCHASH () { 3; }") unless defined(&PF_POOL_SRCHASH);
    eval("sub PF_POOL_ROUNDROBIN () { 4; }") unless defined(&PF_POOL_ROUNDROBIN);
    eval("sub PF_ADDR_ADDRMASK () { 0; }") unless defined(&PF_ADDR_ADDRMASK);
    eval("sub PF_ADDR_NOROUTE () { 1; }") unless defined(&PF_ADDR_NOROUTE);
    eval("sub PF_ADDR_DYNIFTL () { 2; }") unless defined(&PF_ADDR_DYNIFTL);
    eval("sub PF_ADDR_TABLE () { 3; }") unless defined(&PF_ADDR_TABLE);
    eval("sub PF_ADDR_RTLABEL () { 4; }") unless defined(&PF_ADDR_RTLABEL);
    eval("sub PF_ADDR_URPFFAILED () { 5; }") unless defined(&PF_ADDR_URPFFAILED);
    eval 'sub PF_POOL_TYPEMASK () {0xf;}' unless defined(&PF_POOL_TYPEMASK);
    eval 'sub PF_POOL_STICKYADDR () {0x20;}' unless defined(&PF_POOL_STICKYADDR);
    eval 'sub PF_WSCALE_FLAG () {0x80;}' unless defined(&PF_WSCALE_FLAG);
    eval 'sub PF_WSCALE_MASK () {0xf;}' unless defined(&PF_WSCALE_MASK);
    eval 'sub PF_LOG () {0x1;}' unless defined(&PF_LOG);
    eval 'sub PF_LOG_ALL () {0x2;}' unless defined(&PF_LOG_ALL);
    eval 'sub PF_LOG_SOCKET_LOOKUP () {0x4;}' unless defined(&PF_LOG_SOCKET_LOOKUP);
    eval 'sub v4 () { ($pfa->{v4});}' unless defined(&v4);
    eval 'sub v6 () { ($pfa->{v6});}' unless defined(&v6);
    eval 'sub addr8 () { ($pfa->{addr8});}' unless defined(&addr8);
    eval 'sub addr16 () { ($pfa->{addr16});}' unless defined(&addr16);
    eval 'sub addr32 () { ($pfa->{addr32});}' unless defined(&addr32);
    eval 'sub PF_TABLE_NAME_SIZE () {32;}' unless defined(&PF_TABLE_NAME_SIZE);
    eval 'sub PFI_AFLAG_NETWORK () {0x1;}' unless defined(&PFI_AFLAG_NETWORK);
    eval 'sub PFI_AFLAG_BROADCAST () {0x2;}' unless defined(&PFI_AFLAG_BROADCAST);
    eval 'sub PFI_AFLAG_PEER () {0x4;}' unless defined(&PFI_AFLAG_PEER);
    eval 'sub PFI_AFLAG_MODEMASK () {0x7;}' unless defined(&PFI_AFLAG_MODEMASK);
    eval 'sub PFI_AFLAG_NOALIAS () {0x8;}' unless defined(&PFI_AFLAG_NOALIAS);
    unless(defined(&RTLABEL_LEN)) {
	eval 'sub RTLABEL_LEN () {32;}' unless defined(&RTLABEL_LEN);
    }
    if(defined(&_KERNEL)) {
	if(defined(&INET)) {
	    unless(defined(&INET6)) {
		eval 'sub PF_INET_ONLY () {1;}' unless defined(&PF_INET_ONLY);
	    }
	}
	if(defined(&INET6)) {
	    unless(defined(&INET)) {
		eval 'sub PF_INET6_ONLY () {1;}' unless defined(&PF_INET6_ONLY);
	    }
	}
	if(defined(&INET)) {
	    if(defined(&INET6)) {
		eval 'sub PF_INET_INET6 () {1;}' unless defined(&PF_INET_INET6);
	    }
	}
    } else {
	eval 'sub PF_INET_INET6 () {1;}' unless defined(&PF_INET_INET6);
    }
    if(defined(&PF_INET_INET6)) {
	eval 'sub PF_AEQ {
	    my($a, $b, $c) = @_;
    	    eval q((($c ==  &AF_INET  && ($a)-> $addr32[0] == ($b)-> $addr32[0]) || (($a)-> $addr32[3] == ($b)-> $addr32[3]  && ($a)-> $addr32[2] == ($b)-> $addr32[2]  && ($a)-> $addr32[1] == ($b)-> $addr32[1]  && ($a)-> $addr32[0] == ($b)-> $addr32[0])));
	}' unless defined(&PF_AEQ);
	eval 'sub PF_ANEQ {
	    my($a, $b, $c) = @_;
    	    eval q((($c ==  &AF_INET  && ($a)-> $addr32[0] != ($b)-> $addr32[0]) || (($a)-> $addr32[3] != ($b)-> $addr32[3] || ($a)-> $addr32[2] != ($b)-> $addr32[2] || ($a)-> $addr32[1] != ($b)-> $addr32[1] || ($a)-> $addr32[0] != ($b)-> $addr32[0])));
	}' unless defined(&PF_ANEQ);
	eval 'sub PF_AZERO {
	    my($a, $c) = @_;
    	    eval q((($c ==  &AF_INET  && !($a)-> $addr32[0]) || (!($a)-> $addr32[0]  && !($a)-> $addr32[1]  && !($a)-> $addr32[2]  && !($a)-> $addr32[3] )));
	}' unless defined(&PF_AZERO);
	eval 'sub PF_MATCHA {
	    my($n, $a, $m, $b, $f) = @_;
    	    eval q( &pf_match_addr($n, $a, $m, $b, $f));
	}' unless defined(&PF_MATCHA);
	eval 'sub PF_ACPY {
	    my($a, $b, $f) = @_;
    	    eval q( &pf_addrcpy($a, $b, $f));
	}' unless defined(&PF_ACPY);
	eval 'sub PF_AINC {
	    my($a, $f) = @_;
    	    eval q( &pf_addr_inc($a, $f));
	}' unless defined(&PF_AINC);
	eval 'sub PF_POOLMASK {
	    my($a, $b, $c, $d, $f) = @_;
    	    eval q( &pf_poolmask($a, $b, $c, $d, $f));
	}' unless defined(&PF_POOLMASK);
    } else {
	if(defined(&PF_INET6_ONLY)) {
	    eval 'sub PF_AEQ {
	        my($a, $b, $c) = @_;
    		eval q((($a)-> $addr32[3] == ($b)-> $addr32[3]  && ($a)-> $addr32[2] == ($b)-> $addr32[2]  && ($a)-> $addr32[1] == ($b)-> $addr32[1]  && ($a)-> $addr32[0] == ($b)-> $addr32[0]));
	    }' unless defined(&PF_AEQ);
	    eval 'sub PF_ANEQ {
	        my($a, $b, $c) = @_;
    		eval q((($a)-> $addr32[3] != ($b)-> $addr32[3] || ($a)-> $addr32[2] != ($b)-> $addr32[2] || ($a)-> $addr32[1] != ($b)-> $addr32[1] || ($a)-> $addr32[0] != ($b)-> $addr32[0]));
	    }' unless defined(&PF_ANEQ);
	    eval 'sub PF_AZERO {
	        my($a, $c) = @_;
    		eval q((!($a)-> $addr32[0]  && !($a)-> $addr32[1]  && !($a)-> $addr32[2]  && !($a)-> $addr32[3] ));
	    }' unless defined(&PF_AZERO);
	    eval 'sub PF_MATCHA {
	        my($n, $a, $m, $b, $f) = @_;
    		eval q( &pf_match_addr($n, $a, $m, $b, $f));
	    }' unless defined(&PF_MATCHA);
	    eval 'sub PF_ACPY {
	        my($a, $b, $f) = @_;
    		eval q( &pf_addrcpy($a, $b, $f));
	    }' unless defined(&PF_ACPY);
	    eval 'sub PF_AINC {
	        my($a, $f) = @_;
    		eval q( &pf_addr_inc($a, $f));
	    }' unless defined(&PF_AINC);
	    eval 'sub PF_POOLMASK {
	        my($a, $b, $c, $d, $f) = @_;
    		eval q( &pf_poolmask($a, $b, $c, $d, $f));
	    }' unless defined(&PF_POOLMASK);
	} else {
	    if(defined(&PF_INET_ONLY)) {
		eval 'sub PF_AEQ {
		    my($a, $b, $c) = @_;
    		    eval q((($a)-> $addr32[0] == ($b)-> $addr32[0]));
		}' unless defined(&PF_AEQ);
		eval 'sub PF_ANEQ {
		    my($a, $b, $c) = @_;
    		    eval q((($a)-> $addr32[0] != ($b)-> $addr32[0]));
		}' unless defined(&PF_ANEQ);
		eval 'sub PF_AZERO {
		    my($a, $c) = @_;
    		    eval q((!($a)-> $addr32[0]));
		}' unless defined(&PF_AZERO);
		eval 'sub PF_MATCHA {
		    my($n, $a, $m, $b, $f) = @_;
    		    eval q( &pf_match_addr($n, $a, $m, $b, $f));
		}' unless defined(&PF_MATCHA);
		eval 'sub PF_ACPY {
		    my($a, $b, $f) = @_;
    		    eval q(($a)-> ($v4->{s_addr}) = ($b)-> ($v4->{s_addr}));
		}' unless defined(&PF_ACPY);
		eval 'sub PF_AINC {
		    my($a, $f) = @_;
    		    eval q( &do { ($a)-> $addr32[0] =  &htonl( &ntohl(($a)-> $addr32[0]) + 1); }  &while (0));
		}' unless defined(&PF_AINC);
		eval 'sub PF_POOLMASK {
		    my($a, $b, $c, $d, $f) = @_;
    		    eval q( &do { ($a)-> $addr32[0] = (($b)-> $addr32[0] & ($c)-> $addr32[0]) | ((($c)-> $addr32[0] ^ 0xffffffff ) & ($d)-> $addr32[0]); }  &while (0));
		}' unless defined(&PF_POOLMASK);
	    }
	}
    }
    eval 'sub PF_MISMATCHAW {
        my($aw, $x, $af, $neg, $ifp) = @_;
	    eval q(( ((($aw)-> &type ==  &PF_ADDR_NOROUTE  &&  &pf_routable(($x), ($af),  &NULL)) || ((($aw)-> &type ==  &PF_ADDR_URPFFAILED  && ($ifp) !=  &NULL  &&  &pf_routable(($x), ($af), ($ifp))) || (($aw)-> &type ==  &PF_ADDR_RTLABEL  && ! &pf_rtlabel_match(($x), ($af), ($aw))) || (($aw)-> &type ==  &PF_ADDR_TABLE  && ! &pfr_match_addr(($aw)-> ($p->{tbl}), ($x), ($af))) || (($aw)-> &type ==  &PF_ADDR_DYNIFTL  && ! &pfi_match_addr(($aw)-> ($p->{dyn}), ($x), ($af))) || (($aw)-> &type ==  &PF_ADDR_ADDRMASK  && ! &PF_AZERO(($aw)-> ($v->{a}->{mask}), ($af))  && ! &PF_MATCHA(0, ($aw)-> ($v->{a}->{addr}), ($aw)-> ($v->{a}->{mask}), ($x), ($af))))) != ($neg) ));
    }' unless defined(&PF_MISMATCHAW);
    eval 'sub key8 () { ($pfk->{key8});}' unless defined(&key8);
    eval 'sub key16 () { ($pfk->{key16});}' unless defined(&key16);
    eval 'sub key32 () { ($pfk->{key32});}' unless defined(&key32);
    eval 'sub PF_OSFP_ANY () {(( &pf_osfp_t)0);}' unless defined(&PF_OSFP_ANY);
    eval 'sub PF_OSFP_UNKNOWN () {(( &pf_osfp_t)-1);}' unless defined(&PF_OSFP_UNKNOWN);
    eval 'sub PF_OSFP_NOMATCH () {(( &pf_osfp_t)-2);}' unless defined(&PF_OSFP_NOMATCH);
    eval 'sub PF_OSFP_EXPANDED () {0x1;}' unless defined(&PF_OSFP_EXPANDED);
    eval 'sub PF_OSFP_GENERIC () {0x2;}' unless defined(&PF_OSFP_GENERIC);
    eval 'sub PF_OSFP_NODETAIL () {0x4;}' unless defined(&PF_OSFP_NODETAIL);
    eval 'sub PF_OSFP_LEN () {32;}' unless defined(&PF_OSFP_LEN);
    eval 'sub PF_OSFP_ENTRY_EQ {
        my($a, $b) = @_;
	    eval q((($a)-> &fp_os == ($b)-> &fp_os  &&  &memcmp(($a)-> &fp_class_nm, ($b)-> &fp_class_nm,  &PF_OSFP_LEN) == 0 &&  &memcmp(($a)-> &fp_version_nm, ($b)-> &fp_version_nm,  &PF_OSFP_LEN) == 0 &&  &memcmp(($a)-> &fp_subtype_nm, ($b)-> &fp_subtype_nm,  &PF_OSFP_LEN) == 0));
    }' unless defined(&PF_OSFP_ENTRY_EQ);
    eval 'sub _FP_RESERVED_BIT () {1;}' unless defined(&_FP_RESERVED_BIT);
    eval 'sub _FP_UNUSED_BITS () {1;}' unless defined(&_FP_UNUSED_BITS);
    eval 'sub _FP_CLASS_BITS () {10;}' unless defined(&_FP_CLASS_BITS);
    eval 'sub _FP_VERSION_BITS () {10;}' unless defined(&_FP_VERSION_BITS);
    eval 'sub _FP_SUBTYPE_BITS () {10;}' unless defined(&_FP_SUBTYPE_BITS);
    eval 'sub PF_OSFP_UNPACK {
        my($osfp, $class, $version, $subtype) = @_;
	    eval q( &do { ($class) = (($osfp) >> ( &_FP_VERSION_BITS+ &_FP_SUBTYPE_BITS)) & ((1<<  &_FP_CLASS_BITS) - 1); ($version) = (($osfp) >>  &_FP_SUBTYPE_BITS) & ((1<<  &_FP_VERSION_BITS) - 1); ($subtype) = ($osfp) & ((1<<  &_FP_SUBTYPE_BITS) - 1); }  &while(0));
    }' unless defined(&PF_OSFP_UNPACK);
    eval 'sub PF_OSFP_PACK {
        my($osfp, $class, $version, $subtype) = @_;
	    eval q( &do { ($osfp) = (($class) & ((1<<  &_FP_CLASS_BITS) - 1)) << ( &_FP_VERSION_BITS +  &_FP_SUBTYPE_BITS); ($osfp) |= (($version) & ((1<<  &_FP_VERSION_BITS) - 1)) <<  &_FP_SUBTYPE_BITS; ($osfp) |= ($subtype) & ((1<<  &_FP_SUBTYPE_BITS) - 1); }  &while(0));
    }' unless defined(&PF_OSFP_PACK);
    eval 'sub PF_OSFP_WSIZE_MOD () {0x1;}' unless defined(&PF_OSFP_WSIZE_MOD);
    eval 'sub PF_OSFP_WSIZE_DC () {0x2;}' unless defined(&PF_OSFP_WSIZE_DC);
    eval 'sub PF_OSFP_WSIZE_MSS () {0x4;}' unless defined(&PF_OSFP_WSIZE_MSS);
    eval 'sub PF_OSFP_WSIZE_MTU () {0x8;}' unless defined(&PF_OSFP_WSIZE_MTU);
    eval 'sub PF_OSFP_PSIZE_MOD () {0x10;}' unless defined(&PF_OSFP_PSIZE_MOD);
    eval 'sub PF_OSFP_PSIZE_DC () {0x20;}' unless defined(&PF_OSFP_PSIZE_DC);
    eval 'sub PF_OSFP_WSCALE () {0x40;}' unless defined(&PF_OSFP_WSCALE);
    eval 'sub PF_OSFP_WSCALE_MOD () {0x80;}' unless defined(&PF_OSFP_WSCALE_MOD);
    eval 'sub PF_OSFP_WSCALE_DC () {0x100;}' unless defined(&PF_OSFP_WSCALE_DC);
    eval 'sub PF_OSFP_MSS () {0x200;}' unless defined(&PF_OSFP_MSS);
    eval 'sub PF_OSFP_MSS_MOD () {0x400;}' unless defined(&PF_OSFP_MSS_MOD);
    eval 'sub PF_OSFP_MSS_DC () {0x800;}' unless defined(&PF_OSFP_MSS_DC);
    eval 'sub PF_OSFP_DF () {0x1000;}' unless defined(&PF_OSFP_DF);
    eval 'sub PF_OSFP_TS0 () {0x2000;}' unless defined(&PF_OSFP_TS0);
    eval 'sub PF_OSFP_INET6 () {0x4000;}' unless defined(&PF_OSFP_INET6);
    eval 'sub PF_OSFP_MAXTTL_OFFSET () {40;}' unless defined(&PF_OSFP_MAXTTL_OFFSET);
    eval 'sub PF_OSFP_TCPOPT_NOP () {0x;}' unless defined(&PF_OSFP_TCPOPT_NOP);
    eval 'sub PF_OSFP_TCPOPT_WSCALE () {0x1;}' unless defined(&PF_OSFP_TCPOPT_WSCALE);
    eval 'sub PF_OSFP_TCPOPT_MSS () {0x2;}' unless defined(&PF_OSFP_TCPOPT_MSS);
    eval 'sub PF_OSFP_TCPOPT_SACK () {0x3;}' unless defined(&PF_OSFP_TCPOPT_SACK);
    eval 'sub PF_OSFP_TCPOPT_TS () {0x4;}' unless defined(&PF_OSFP_TCPOPT_TS);
    eval 'sub PF_OSFP_TCPOPT_BITS () {3;}' unless defined(&PF_OSFP_TCPOPT_BITS);
    eval 'sub PF_OSFP_MAX_OPTS () {($sizeof{(0)-> &fp_tcpopts} * 8) /  &PF_OSFP_TCPOPT_BITS;}' unless defined(&PF_OSFP_MAX_OPTS);
    eval 'sub PF_ANCHOR_NAME_SIZE () {64;}' unless defined(&PF_ANCHOR_NAME_SIZE);
    eval 'sub PF_SKIP_IFP () {0;}' unless defined(&PF_SKIP_IFP);
    eval 'sub PF_SKIP_DIR () {1;}' unless defined(&PF_SKIP_DIR);
    eval 'sub PF_SKIP_AF () {2;}' unless defined(&PF_SKIP_AF);
    eval 'sub PF_SKIP_PROTO () {3;}' unless defined(&PF_SKIP_PROTO);
    eval 'sub PF_SKIP_SRC_ADDR () {4;}' unless defined(&PF_SKIP_SRC_ADDR);
    eval 'sub PF_SKIP_SRC_PORT () {5;}' unless defined(&PF_SKIP_SRC_PORT);
    eval 'sub PF_SKIP_DST_ADDR () {6;}' unless defined(&PF_SKIP_DST_ADDR);
    eval 'sub PF_SKIP_DST_PORT () {7;}' unless defined(&PF_SKIP_DST_PORT);
    eval 'sub PF_SKIP_COUNT () {8;}' unless defined(&PF_SKIP_COUNT);
    eval 'sub PF_RULE_LABEL_SIZE () {64;}' unless defined(&PF_RULE_LABEL_SIZE);
    eval 'sub PF_QNAME_SIZE () {64;}' unless defined(&PF_QNAME_SIZE);
    eval 'sub PF_TAG_NAME_SIZE () {64;}' unless defined(&PF_TAG_NAME_SIZE);
    eval 'sub PF_STATE_NORMAL () {0x1;}' unless defined(&PF_STATE_NORMAL);
    eval 'sub PF_STATE_MODULATE () {0x2;}' unless defined(&PF_STATE_MODULATE);
    eval 'sub PF_STATE_SYNPROXY () {0x3;}' unless defined(&PF_STATE_SYNPROXY);
    eval 'sub PF_FLUSH () {0x1;}' unless defined(&PF_FLUSH);
    eval 'sub PF_FLUSH_GLOBAL () {0x2;}' unless defined(&PF_FLUSH_GLOBAL);
    eval 'sub PFRULE_DROP () {0x;}' unless defined(&PFRULE_DROP);
    eval 'sub PFRULE_RETURNRST () {0x1;}' unless defined(&PFRULE_RETURNRST);
    eval 'sub PFRULE_FRAGMENT () {0x2;}' unless defined(&PFRULE_FRAGMENT);
    eval 'sub PFRULE_RETURNICMP () {0x4;}' unless defined(&PFRULE_RETURNICMP);
    eval 'sub PFRULE_RETURN () {0x8;}' unless defined(&PFRULE_RETURN);
    eval 'sub PFRULE_NOSYNC () {0x10;}' unless defined(&PFRULE_NOSYNC);
    eval 'sub PFRULE_SRCTRACK () {0x20;}' unless defined(&PFRULE_SRCTRACK);
    eval 'sub PFRULE_RULESRCTRACK () {0x40;}' unless defined(&PFRULE_RULESRCTRACK);
    eval 'sub PFRULE_NODF () {0x100;}' unless defined(&PFRULE_NODF);
    eval 'sub PFRULE_FRAGCROP () {0x200;}' unless defined(&PFRULE_FRAGCROP);
    eval 'sub PFRULE_FRAGDROP () {0x400;}' unless defined(&PFRULE_FRAGDROP);
    eval 'sub PFRULE_RANDOMID () {0x800;}' unless defined(&PFRULE_RANDOMID);
    eval 'sub PFRULE_REASSEMBLE_TCP () {0x1000;}' unless defined(&PFRULE_REASSEMBLE_TCP);
    eval 'sub PFRULE_IFBOUND () {0x10000;}' unless defined(&PFRULE_IFBOUND);
    eval 'sub PFSTATE_HIWAT () {10000;}' unless defined(&PFSTATE_HIWAT);
    eval 'sub PFSTATE_ADAPT_START () {6000;}' unless defined(&PFSTATE_ADAPT_START);
    eval 'sub PFSTATE_ADAPT_END () {12000;}' unless defined(&PFSTATE_ADAPT_END);
    eval 'sub PF_THRESHOLD_MULT () {1000;}' unless defined(&PF_THRESHOLD_MULT);
    eval 'sub PF_THRESHOLD_MAX () {0xffffffff /  &PF_THRESHOLD_MULT;}' unless defined(&PF_THRESHOLD_MAX);
    eval 'sub PFSNODE_HIWAT () {10000;}' unless defined(&PFSNODE_HIWAT);
    eval 'sub PFSS_TIMESTAMP () {0x1;}' unless defined(&PFSS_TIMESTAMP);
    eval 'sub PFSS_PAWS () {0x10;}' unless defined(&PFSS_PAWS);
    eval 'sub PFSS_PAWS_IDLED () {0x20;}' unless defined(&PFSS_PAWS_IDLED);
    eval 'sub PFSS_DATA_TS () {0x40;}' unless defined(&PFSS_DATA_TS);
    eval 'sub PFSS_DATA_NOTS () {0x80;}' unless defined(&PFSS_DATA_NOTS);
    eval 'sub PFSTATE_NOSYNC () {0x1;}' unless defined(&PFSTATE_NOSYNC);
    eval 'sub PFSTATE_FROMSYNC () {0x2;}' unless defined(&PFSTATE_FROMSYNC);
    eval 'sub PFSTATE_STALE () {0x4;}' unless defined(&PFSTATE_STALE);
    eval 'sub PFSYNC_SCRUB_FLAG_VALID () {0x1;}' unless defined(&PFSYNC_SCRUB_FLAG_VALID);
    eval 'sub PFSYNC_FLAG_COMPRESS () {0x1;}' unless defined(&PFSYNC_FLAG_COMPRESS);
    eval 'sub PFSYNC_FLAG_STALE () {0x2;}' unless defined(&PFSYNC_FLAG_STALE);
    eval 'sub PFSYNC_FLAG_SRCNODE () {0x4;}' unless defined(&PFSYNC_FLAG_SRCNODE);
    eval 'sub PFSYNC_FLAG_NATSRCNODE () {0x8;}' unless defined(&PFSYNC_FLAG_NATSRCNODE);
    eval 'sub pf_state_peer_to_pfsync {
        my($s,$d) = @_;
	    eval q( &do { ($d)-> &seqlo = ($s)-> &seqlo; ($d)-> &seqhi = ($s)-> &seqhi; ($d)-> &seqdiff = ($s)-> &seqdiff; ($d)-> &max_win = ($s)-> &max_win; ($d)-> &mss = ($s)-> &mss; ($d)-> &state = ($s)-> &state; ($d)-> &wscale = ($s)-> &wscale;  &if (($s)-> &scrub) { ($d)-> ($scrub->{pfss_flags}) = ($s)-> ($scrub->{pfss_flags}) &  &PFSS_TIMESTAMP; ($d)-> ($scrub->{pfss_ttl}) = ($s)-> ($scrub->{pfss_ttl}); ($d)-> ($scrub->{pfss_ts_mod}) = ($s)-> ($scrub->{pfss_ts_mod}); ($d)-> ($scrub->{scrub_flag}) =  &PFSYNC_SCRUB_FLAG_VALID; } }  &while (0));
    }' unless defined(&pf_state_peer_to_pfsync);
    eval 'sub pf_state_peer_from_pfsync {
        my($s,$d) = @_;
	    eval q( &do { ($d)-> &seqlo = ($s)-> &seqlo; ($d)-> &seqhi = ($s)-> &seqhi; ($d)-> &seqdiff = ($s)-> &seqdiff; ($d)-> &max_win = ($s)-> &max_win; ($d)-> &mss =  &ntohs(($s)-> &mss); ($d)-> &state = ($s)-> &state; ($d)-> &wscale = ($s)-> &wscale;  &if (($s)-> ($scrub->{scrub_flag}) ==  &PFSYNC_SCRUB_FLAG_VALID  && ($d)-> &scrub !=  &NULL) { ($d)-> ($scrub->{pfss_flags}) =  &ntohs(($s)-> ($scrub->{pfss_flags})) &  &PFSS_TIMESTAMP; ($d)-> ($scrub->{pfss_ttl}) = ($s)-> ($scrub->{pfss_ttl}); ($d)-> ($scrub->{pfss_ts_mod}) = ($s)-> ($scrub->{pfss_ts_mod}); } }  &while (0));
    }' unless defined(&pf_state_peer_from_pfsync);
    eval 'sub pf_state_counter_to_pfsync {
        my($s,$d) = @_;
	    eval q( &do { $d->[0] = ($s>>32)&0xffffffff; $d->[1] = $s&0xffffffff; }  &while (0));
    }' unless defined(&pf_state_counter_to_pfsync);
    eval 'sub pf_state_counter_from_pfsync {
        my($s) = @_;
	    eval q(((( &u_int64_t)($s->[0])<<32) | ( &u_int64_t)($s->[1])));
    }' unless defined(&pf_state_counter_from_pfsync);
    eval 'sub PF_RESERVED_ANCHOR () {"_pf";}' unless defined(&PF_RESERVED_ANCHOR);
    eval 'sub PFR_TFLAG_PERSIST () {0x1;}' unless defined(&PFR_TFLAG_PERSIST);
    eval 'sub PFR_TFLAG_CONST () {0x2;}' unless defined(&PFR_TFLAG_CONST);
    eval 'sub PFR_TFLAG_ACTIVE () {0x4;}' unless defined(&PFR_TFLAG_ACTIVE);
    eval 'sub PFR_TFLAG_INACTIVE () {0x8;}' unless defined(&PFR_TFLAG_INACTIVE);
    eval 'sub PFR_TFLAG_REFERENCED () {0x10;}' unless defined(&PFR_TFLAG_REFERENCED);
    eval 'sub PFR_TFLAG_REFDANCHOR () {0x20;}' unless defined(&PFR_TFLAG_REFDANCHOR);
    eval 'sub PFR_TFLAG_USRMASK () {0x3;}' unless defined(&PFR_TFLAG_USRMASK);
    eval 'sub PFR_TFLAG_SETMASK () {0x3c;}' unless defined(&PFR_TFLAG_SETMASK);
    eval 'sub PFR_TFLAG_ALLMASK () {0x3f;}' unless defined(&PFR_TFLAG_ALLMASK);
    eval("sub PFR_FB_NONE () { 0; }") unless defined(&PFR_FB_NONE);
    eval("sub PFR_FB_MATCH () { 1; }") unless defined(&PFR_FB_MATCH);
    eval("sub PFR_FB_ADDED () { 2; }") unless defined(&PFR_FB_ADDED);
    eval("sub PFR_FB_DELETED () { 3; }") unless defined(&PFR_FB_DELETED);
    eval("sub PFR_FB_CHANGED () { 4; }") unless defined(&PFR_FB_CHANGED);
    eval("sub PFR_FB_CLEARED () { 5; }") unless defined(&PFR_FB_CLEARED);
    eval("sub PFR_FB_DUPLICATE () { 6; }") unless defined(&PFR_FB_DUPLICATE);
    eval("sub PFR_FB_NOTMATCH () { 7; }") unless defined(&PFR_FB_NOTMATCH);
    eval("sub PFR_FB_CONFLICT () { 8; }") unless defined(&PFR_FB_CONFLICT);
    eval("sub PFR_FB_MAX () { 9; }") unless defined(&PFR_FB_MAX);
    eval 'sub pfra_ip4addr () { ($pfra_u->{_pfra_ip4addr});}' unless defined(&pfra_ip4addr);
    eval 'sub pfra_ip6addr () { ($pfra_u->{_pfra_ip6addr});}' unless defined(&pfra_ip6addr);
    eval("sub PFR_DIR_IN () { 0; }") unless defined(&PFR_DIR_IN);
    eval("sub PFR_DIR_OUT () { 1; }") unless defined(&PFR_DIR_OUT);
    eval("sub PFR_DIR_MAX () { 2; }") unless defined(&PFR_DIR_MAX);
    eval("sub PFR_OP_BLOCK () { 0; }") unless defined(&PFR_OP_BLOCK);
    eval("sub PFR_OP_PASS () { 1; }") unless defined(&PFR_OP_PASS);
    eval("sub PFR_OP_ADDR_MAX () { 2; }") unless defined(&PFR_OP_ADDR_MAX);
    eval("sub PFR_OP_TABLE_MAX () { 3; }") unless defined(&PFR_OP_TABLE_MAX);
    eval 'sub PFR_OP_XPASS () { &PFR_OP_ADDR_MAX;}' unless defined(&PFR_OP_XPASS);
    eval("sub PFR_REFCNT_RULE () { 0; }") unless defined(&PFR_REFCNT_RULE);
    eval("sub PFR_REFCNT_ANCHOR () { 1; }") unless defined(&PFR_REFCNT_ANCHOR);
    eval("sub PFR_REFCNT_MAX () { 2; }") unless defined(&PFR_REFCNT_MAX);
    eval 'sub pfrts_name () { ($pfrts_t->{pfrt_name});}' unless defined(&pfrts_name);
    eval 'sub pfrts_flags () { ($pfrts_t->{pfrt_flags});}' unless defined(&pfrts_flags);
    unless(defined(&_SOCKADDR_UNION_DEFINED)) {
	eval 'sub _SOCKADDR_UNION_DEFINED () {1;}' unless defined(&_SOCKADDR_UNION_DEFINED);
    }
    eval 'sub pfrkt_t () { ($pfrkt_ts->{pfrts_t});}' unless defined(&pfrkt_t);
    eval 'sub pfrkt_name () { ($pfrkt_t->{pfrt_name});}' unless defined(&pfrkt_name);
    eval 'sub pfrkt_anchor () { ($pfrkt_t->{pfrt_anchor});}' unless defined(&pfrkt_anchor);
    eval 'sub pfrkt_ruleset () { ($pfrkt_t->{pfrt_ruleset});}' unless defined(&pfrkt_ruleset);
    eval 'sub pfrkt_flags () { ($pfrkt_t->{pfrt_flags});}' unless defined(&pfrkt_flags);
    eval 'sub pfrkt_cnt () { ($pfrkt_ts->{pfrts_cnt});}' unless defined(&pfrkt_cnt);
    eval 'sub pfrkt_refcnt () { ($pfrkt_ts->{pfrts_refcnt});}' unless defined(&pfrkt_refcnt);
    eval 'sub pfrkt_packets () { ($pfrkt_ts->{pfrts_packets});}' unless defined(&pfrkt_packets);
    eval 'sub pfrkt_bytes () { ($pfrkt_ts->{pfrts_bytes});}' unless defined(&pfrkt_bytes);
    eval 'sub pfrkt_match () { ($pfrkt_ts->{pfrts_match});}' unless defined(&pfrkt_match);
    eval 'sub pfrkt_nomatch () { ($pfrkt_ts->{pfrts_nomatch});}' unless defined(&pfrkt_nomatch);
    eval 'sub pfrkt_tzero () { ($pfrkt_ts->{pfrts_tzero});}' unless defined(&pfrkt_tzero);
    eval("sub PFI_KIF_REF_NONE () { 0; }") unless defined(&PFI_KIF_REF_NONE);
    eval("sub PFI_KIF_REF_STATE () { 1; }") unless defined(&PFI_KIF_REF_STATE);
    eval("sub PFI_KIF_REF_RULE () { 2; }") unless defined(&PFI_KIF_REF_RULE);
    eval 'sub PFI_IFLAG_SKIP () {0x100;}' unless defined(&PFI_IFLAG_SKIP);
    if(defined(&INET6)) {
    }
    eval 'sub PFDESC_TCP_NORM () {0x1;}' unless defined(&PFDESC_TCP_NORM);
    eval 'sub PFDESC_IP_REAS () {0x2;}' unless defined(&PFDESC_IP_REAS);
    eval 'sub PF_DPORT_RANGE () {0x1;}' unless defined(&PF_DPORT_RANGE);
    eval 'sub PF_RPORT_RANGE () {0x2;}' unless defined(&PF_RPORT_RANGE);
    eval 'sub PFRES_MATCH () {0;}' unless defined(&PFRES_MATCH);
    eval 'sub PFRES_BADOFF () {1;}' unless defined(&PFRES_BADOFF);
    eval 'sub PFRES_FRAG () {2;}' unless defined(&PFRES_FRAG);
    eval 'sub PFRES_SHORT () {3;}' unless defined(&PFRES_SHORT);
    eval 'sub PFRES_NORM () {4;}' unless defined(&PFRES_NORM);
    eval 'sub PFRES_MEMORY () {5;}' unless defined(&PFRES_MEMORY);
    eval 'sub PFRES_TS () {6;}' unless defined(&PFRES_TS);
    eval 'sub PFRES_CONGEST () {7;}' unless defined(&PFRES_CONGEST);
    eval 'sub PFRES_IPOPTIONS () {8;}' unless defined(&PFRES_IPOPTIONS);
    eval 'sub PFRES_PROTCKSUM () {9;}' unless defined(&PFRES_PROTCKSUM);
    eval 'sub PFRES_BADSTATE () {10;}' unless defined(&PFRES_BADSTATE);
    eval 'sub PFRES_STATEINS () {11;}' unless defined(&PFRES_STATEINS);
    eval 'sub PFRES_MAXSTATES () {12;}' unless defined(&PFRES_MAXSTATES);
    eval 'sub PFRES_SRCLIMIT () {13;}' unless defined(&PFRES_SRCLIMIT);
    eval 'sub PFRES_SYNPROXY () {14;}' unless defined(&PFRES_SYNPROXY);
    eval 'sub PFRES_STATELOCKED () {15;}' unless defined(&PFRES_STATELOCKED);
    eval 'sub PFRES_MAX () {16;}' unless defined(&PFRES_MAX);
    eval 'sub PFRES_NAMES () {{ "match", "bad-offset", "fragment", "short", "normalize", "memory", "bad-timestamp", "congestion", "ip-option", "proto-cksum", "state-mismatch", "state-insert", "state-limit", "src-limit", "synproxy", "state-locked",  &NULL };}' unless defined(&PFRES_NAMES);
    eval 'sub LCNT_STATES () {0;}' unless defined(&LCNT_STATES);
    eval 'sub LCNT_SRCSTATES () {1;}' unless defined(&LCNT_SRCSTATES);
    eval 'sub LCNT_SRCNODES () {2;}' unless defined(&LCNT_SRCNODES);
    eval 'sub LCNT_SRCCONN () {3;}' unless defined(&LCNT_SRCCONN);
    eval 'sub LCNT_SRCCONNRATE () {4;}' unless defined(&LCNT_SRCCONNRATE);
    eval 'sub LCNT_OVERLOAD_TABLE () {5;}' unless defined(&LCNT_OVERLOAD_TABLE);
    eval 'sub LCNT_OVERLOAD_FLUSH () {6;}' unless defined(&LCNT_OVERLOAD_FLUSH);
    eval 'sub LCNT_MAX () {7;}' unless defined(&LCNT_MAX);
    eval 'sub LCNT_NAMES () {{ "max states per rule", "max-src-states", "max-src-nodes", "max-src-conn", "max-src-conn-rate", "overload table insertion", "overload flush states",  &NULL };}' unless defined(&LCNT_NAMES);
    eval 'sub PFUDPS_NO_TRAFFIC () {0;}' unless defined(&PFUDPS_NO_TRAFFIC);
    eval 'sub PFUDPS_SINGLE () {1;}' unless defined(&PFUDPS_SINGLE);
    eval 'sub PFUDPS_MULTIPLE () {2;}' unless defined(&PFUDPS_MULTIPLE);
    eval 'sub PFUDPS_NSTATES () {3;}' unless defined(&PFUDPS_NSTATES);
    eval 'sub PFUDPS_NAMES () {{ "NO_TRAFFIC", "SINGLE", "MULTIPLE",  &NULL };}' unless defined(&PFUDPS_NAMES);
    eval 'sub PFOTHERS_NO_TRAFFIC () {0;}' unless defined(&PFOTHERS_NO_TRAFFIC);
    eval 'sub PFOTHERS_SINGLE () {1;}' unless defined(&PFOTHERS_SINGLE);
    eval 'sub PFOTHERS_MULTIPLE () {2;}' unless defined(&PFOTHERS_MULTIPLE);
    eval 'sub PFOTHERS_NSTATES () {3;}' unless defined(&PFOTHERS_NSTATES);
    eval 'sub PFOTHERS_NAMES () {{ "NO_TRAFFIC", "SINGLE", "MULTIPLE",  &NULL };}' unless defined(&PFOTHERS_NAMES);
    eval 'sub FCNT_STATE_SEARCH () {0;}' unless defined(&FCNT_STATE_SEARCH);
    eval 'sub FCNT_STATE_INSERT () {1;}' unless defined(&FCNT_STATE_INSERT);
    eval 'sub FCNT_STATE_REMOVALS () {2;}' unless defined(&FCNT_STATE_REMOVALS);
    eval 'sub FCNT_MAX () {3;}' unless defined(&FCNT_MAX);
    eval 'sub SCNT_SRC_NODE_SEARCH () {0;}' unless defined(&SCNT_SRC_NODE_SEARCH);
    eval 'sub SCNT_SRC_NODE_INSERT () {1;}' unless defined(&SCNT_SRC_NODE_INSERT);
    eval 'sub SCNT_SRC_NODE_REMOVALS () {2;}' unless defined(&SCNT_SRC_NODE_REMOVALS);
    eval 'sub SCNT_MAX () {3;}' unless defined(&SCNT_MAX);
    eval 'sub ACTION_SET {
        my($a, $x) = @_;
	    eval q( &do {  &if (($a) !=  &NULL) *($a) = ($x); }  &while (0));
    }' unless defined(&ACTION_SET);
    eval 'sub REASON_SET {
        my($a, $x) = @_;
	    eval q( &do {  &if (($a) !=  &NULL) *($a) = ($x);  &if ($x <  &PFRES_MAX)  ($pf_status->{counters[$x]})++; }  &while (0));
    }' unless defined(&REASON_SET);
    eval 'sub REASON_SET_NOPTR {
        my($a, $x) = @_;
	    eval q( &do { *($a) = ($x);  &if ($x <  &PFRES_MAX)  ($pf_status->{counters[$x]})++; }  &while (0));
    }' unless defined(&REASON_SET_NOPTR);
    eval 'sub PFFRAG_FRENT_HIWAT () {5000;}' unless defined(&PFFRAG_FRENT_HIWAT);
    eval 'sub PFFRAG_FRAG_HIWAT () {1000;}' unless defined(&PFFRAG_FRAG_HIWAT);
    eval 'sub PFFRAG_FRCENT_HIWAT () {50000;}' unless defined(&PFFRAG_FRCENT_HIWAT);
    eval 'sub PFFRAG_FRCACHE_HIWAT () {10000;}' unless defined(&PFFRAG_FRCACHE_HIWAT);
    eval 'sub PFR_KTABLE_HIWAT () {1000;}' unless defined(&PFR_KTABLE_HIWAT);
    eval 'sub PFR_KENTRY_HIWAT () {200000;}' unless defined(&PFR_KENTRY_HIWAT);
    eval 'sub PFR_KENTRY_HIWAT_SMALL () {100000;}' unless defined(&PFR_KENTRY_HIWAT_SMALL);
    eval 'sub ps_buf () { ($ps_u->{psu_buf});}' unless defined(&ps_buf);
    eval 'sub ps_states () { ($ps_u->{psu_states});}' unless defined(&ps_states);
    eval 'sub psn_buf () { ($psn_u->{psu_buf});}' unless defined(&psn_buf);
    eval 'sub psn_src_nodes () { ($psn_u->{psu_src_nodes});}' unless defined(&psn_src_nodes);
    eval 'sub PF_RULESET_ALTQ () {( &PF_RULESET_MAX);}' unless defined(&PF_RULESET_ALTQ);
    eval 'sub PF_RULESET_TABLE () {( &PF_RULESET_MAX+1);}' unless defined(&PF_RULESET_TABLE);
    eval 'sub PFR_FLAG_ATOMIC () {0x1;}' unless defined(&PFR_FLAG_ATOMIC);
    eval 'sub PFR_FLAG_DUMMY () {0x2;}' unless defined(&PFR_FLAG_DUMMY);
    eval 'sub PFR_FLAG_FEEDBACK () {0x4;}' unless defined(&PFR_FLAG_FEEDBACK);
    eval 'sub PFR_FLAG_CLSTATS () {0x8;}' unless defined(&PFR_FLAG_CLSTATS);
    eval 'sub PFR_FLAG_ADDRSTOO () {0x10;}' unless defined(&PFR_FLAG_ADDRSTOO);
    eval 'sub PFR_FLAG_REPLACE () {0x20;}' unless defined(&PFR_FLAG_REPLACE);
    eval 'sub PFR_FLAG_ALLRSETS () {0x40;}' unless defined(&PFR_FLAG_ALLRSETS);
    eval 'sub PFR_FLAG_ALLMASK () {0x7f;}' unless defined(&PFR_FLAG_ALLMASK);
    if(defined(&_KERNEL)) {
	eval 'sub PFR_FLAG_USERIOCTL () {0x10000000;}' unless defined(&PFR_FLAG_USERIOCTL);
    }
    eval 'sub pfrio_exists () { &pfrio_nadd;}' unless defined(&pfrio_exists);
    eval 'sub pfrio_nzero () { &pfrio_nadd;}' unless defined(&pfrio_nzero);
    eval 'sub pfrio_nmatch () { &pfrio_nadd;}' unless defined(&pfrio_nmatch);
    eval 'sub pfrio_naddr () { &pfrio_size2;}' unless defined(&pfrio_naddr);
    eval 'sub pfrio_setflag () { &pfrio_size2;}' unless defined(&pfrio_setflag);
    eval 'sub pfrio_clrflag () { &pfrio_nadd;}' unless defined(&pfrio_clrflag);
    eval 'sub DIOCSTART () { &_IO (ord(\'D\'), 1);}' unless defined(&DIOCSTART);
    eval 'sub DIOCSTOP () { &_IO (ord(\'D\'), 2);}' unless defined(&DIOCSTOP);
    eval 'sub DIOCADDRULE () { &_IOWR(ord(\'D\'), 4, \'struct pfioc_rule\');}' unless defined(&DIOCADDRULE);
    eval 'sub DIOCGETRULES () { &_IOWR(ord(\'D\'), 6, \'struct pfioc_rule\');}' unless defined(&DIOCGETRULES);
    eval 'sub DIOCGETRULE () { &_IOWR(ord(\'D\'), 7, \'struct pfioc_rule\');}' unless defined(&DIOCGETRULE);
    eval 'sub DIOCSETLCK () { &_IOWR(ord(\'D\'), 8,  &uint32_t);}' unless defined(&DIOCSETLCK);
    eval 'sub DIOCCLRSTATES () { &_IOWR(ord(\'D\'), 18, \'struct pfioc_state_kill\');}' unless defined(&DIOCCLRSTATES);
    eval 'sub DIOCGETSTATE () { &_IOWR(ord(\'D\'), 19, \'struct pfioc_state\');}' unless defined(&DIOCGETSTATE);
    eval 'sub DIOCSETSTATUSIF () { &_IOWR(ord(\'D\'), 20, \'struct pfioc_if\');}' unless defined(&DIOCSETSTATUSIF);
    eval 'sub DIOCGETSTATUS () { &_IOWR(ord(\'D\'), 21, \'struct pf_status\');}' unless defined(&DIOCGETSTATUS);
    eval 'sub DIOCCLRSTATUS () { &_IO (ord(\'D\'), 22);}' unless defined(&DIOCCLRSTATUS);
    eval 'sub DIOCNATLOOK () { &_IOWR(ord(\'D\'), 23, \'struct pfioc_natlook\');}' unless defined(&DIOCNATLOOK);
    eval 'sub DIOCSETDEBUG () { &_IOWR(ord(\'D\'), 24,  &u_int32_t);}' unless defined(&DIOCSETDEBUG);
    eval 'sub DIOCGETSTATES () { &_IOWR(ord(\'D\'), 25, \'struct pfioc_states\');}' unless defined(&DIOCGETSTATES);
    eval 'sub DIOCCHANGERULE () { &_IOWR(ord(\'D\'), 26, \'struct pfioc_rule\');}' unless defined(&DIOCCHANGERULE);
    eval 'sub DIOCSETTIMEOUT () { &_IOWR(ord(\'D\'), 29, \'struct pfioc_tm\');}' unless defined(&DIOCSETTIMEOUT);
    eval 'sub DIOCGETTIMEOUT () { &_IOWR(ord(\'D\'), 30, \'struct pfioc_tm\');}' unless defined(&DIOCGETTIMEOUT);
    eval 'sub DIOCADDSTATE () { &_IOWR(ord(\'D\'), 37, \'struct pfioc_state\');}' unless defined(&DIOCADDSTATE);
    eval 'sub DIOCCLRRULECTRS () { &_IO (ord(\'D\'), 38);}' unless defined(&DIOCCLRRULECTRS);
    eval 'sub DIOCGETLIMIT () { &_IOWR(ord(\'D\'), 39, \'struct pfioc_limit\');}' unless defined(&DIOCGETLIMIT);
    eval 'sub DIOCSETLIMIT () { &_IOWR(ord(\'D\'), 40, \'struct pfioc_limit\');}' unless defined(&DIOCSETLIMIT);
    eval 'sub DIOCKILLSTATES () { &_IOWR(ord(\'D\'), 41, \'struct pfioc_state_kill\');}' unless defined(&DIOCKILLSTATES);
    eval 'sub DIOCSTARTALTQ () { &_IO (ord(\'D\'), 42);}' unless defined(&DIOCSTARTALTQ);
    eval 'sub DIOCSTOPALTQ () { &_IO (ord(\'D\'), 43);}' unless defined(&DIOCSTOPALTQ);
    eval 'sub DIOCADDALTQ () { &_IOWR(ord(\'D\'), 45, \'struct pfioc_altq\');}' unless defined(&DIOCADDALTQ);
    eval 'sub DIOCGETALTQS () { &_IOWR(ord(\'D\'), 47, \'struct pfioc_altq\');}' unless defined(&DIOCGETALTQS);
    eval 'sub DIOCGETALTQ () { &_IOWR(ord(\'D\'), 48, \'struct pfioc_altq\');}' unless defined(&DIOCGETALTQ);
    eval 'sub DIOCCHANGEALTQ () { &_IOWR(ord(\'D\'), 49, \'struct pfioc_altq\');}' unless defined(&DIOCCHANGEALTQ);
    eval 'sub DIOCGETQSTATS () { &_IOWR(ord(\'D\'), 50, \'struct pfioc_qstats\');}' unless defined(&DIOCGETQSTATS);
    eval 'sub DIOCBEGINADDRS () { &_IOWR(ord(\'D\'), 51, \'struct pfioc_pooladdr\');}' unless defined(&DIOCBEGINADDRS);
    eval 'sub DIOCADDADDR () { &_IOWR(ord(\'D\'), 52, \'struct pfioc_pooladdr\');}' unless defined(&DIOCADDADDR);
    eval 'sub DIOCGETADDRS () { &_IOWR(ord(\'D\'), 53, \'struct pfioc_pooladdr\');}' unless defined(&DIOCGETADDRS);
    eval 'sub DIOCGETADDR () { &_IOWR(ord(\'D\'), 54, \'struct pfioc_pooladdr\');}' unless defined(&DIOCGETADDR);
    eval 'sub DIOCCHANGEADDR () { &_IOWR(ord(\'D\'), 55, \'struct pfioc_pooladdr\');}' unless defined(&DIOCCHANGEADDR);
    eval 'sub DIOCADDSTATES () { &_IOWR(ord(\'D\'), 56, \'struct pfioc_states\');}' unless defined(&DIOCADDSTATES);
    eval 'sub DIOCGETRULESETS () { &_IOWR(ord(\'D\'), 58, \'struct pfioc_ruleset\');}' unless defined(&DIOCGETRULESETS);
    eval 'sub DIOCGETRULESET () { &_IOWR(ord(\'D\'), 59, \'struct pfioc_ruleset\');}' unless defined(&DIOCGETRULESET);
    eval 'sub DIOCRCLRTABLES () { &_IOWR(ord(\'D\'), 60, \'struct pfioc_table\');}' unless defined(&DIOCRCLRTABLES);
    eval 'sub DIOCRADDTABLES () { &_IOWR(ord(\'D\'), 61, \'struct pfioc_table\');}' unless defined(&DIOCRADDTABLES);
    eval 'sub DIOCRDELTABLES () { &_IOWR(ord(\'D\'), 62, \'struct pfioc_table\');}' unless defined(&DIOCRDELTABLES);
    eval 'sub DIOCRGETTABLES () { &_IOWR(ord(\'D\'), 63, \'struct pfioc_table\');}' unless defined(&DIOCRGETTABLES);
    eval 'sub DIOCRGETTSTATS () { &_IOWR(ord(\'D\'), 64, \'struct pfioc_table\');}' unless defined(&DIOCRGETTSTATS);
    eval 'sub DIOCRCLRTSTATS () { &_IOWR(ord(\'D\'), 65, \'struct pfioc_table\');}' unless defined(&DIOCRCLRTSTATS);
    eval 'sub DIOCRCLRADDRS () { &_IOWR(ord(\'D\'), 66, \'struct pfioc_table\');}' unless defined(&DIOCRCLRADDRS);
    eval 'sub DIOCRADDADDRS () { &_IOWR(ord(\'D\'), 67, \'struct pfioc_table\');}' unless defined(&DIOCRADDADDRS);
    eval 'sub DIOCRDELADDRS () { &_IOWR(ord(\'D\'), 68, \'struct pfioc_table\');}' unless defined(&DIOCRDELADDRS);
    eval 'sub DIOCRSETADDRS () { &_IOWR(ord(\'D\'), 69, \'struct pfioc_table\');}' unless defined(&DIOCRSETADDRS);
    eval 'sub DIOCRGETADDRS () { &_IOWR(ord(\'D\'), 70, \'struct pfioc_table\');}' unless defined(&DIOCRGETADDRS);
    eval 'sub DIOCRGETASTATS () { &_IOWR(ord(\'D\'), 71, \'struct pfioc_table\');}' unless defined(&DIOCRGETASTATS);
    eval 'sub DIOCRCLRASTATS () { &_IOWR(ord(\'D\'), 72, \'struct pfioc_table\');}' unless defined(&DIOCRCLRASTATS);
    eval 'sub DIOCRTSTADDRS () { &_IOWR(ord(\'D\'), 73, \'struct pfioc_table\');}' unless defined(&DIOCRTSTADDRS);
    eval 'sub DIOCRSETTFLAGS () { &_IOWR(ord(\'D\'), 74, \'struct pfioc_table\');}' unless defined(&DIOCRSETTFLAGS);
    eval 'sub DIOCRINADEFINE () { &_IOWR(ord(\'D\'), 77, \'struct pfioc_table\');}' unless defined(&DIOCRINADEFINE);
    eval 'sub DIOCOSFPFLUSH () { &_IO(ord(\'D\'), 78);}' unless defined(&DIOCOSFPFLUSH);
    eval 'sub DIOCOSFPADD () { &_IOWR(ord(\'D\'), 79, \'struct pf_osfp_ioctl\');}' unless defined(&DIOCOSFPADD);
    eval 'sub DIOCOSFPGET () { &_IOWR(ord(\'D\'), 80, \'struct pf_osfp_ioctl\');}' unless defined(&DIOCOSFPGET);
    eval 'sub DIOCXBEGIN () { &_IOWR(ord(\'D\'), 81, \'struct pfioc_trans\');}' unless defined(&DIOCXBEGIN);
    eval 'sub DIOCXCOMMIT () { &_IOWR(ord(\'D\'), 82, \'struct pfioc_trans\');}' unless defined(&DIOCXCOMMIT);
    eval 'sub DIOCXROLLBACK () { &_IOWR(ord(\'D\'), 83, \'struct pfioc_trans\');}' unless defined(&DIOCXROLLBACK);
    eval 'sub DIOCGETSRCNODES () { &_IOWR(ord(\'D\'), 84, \'struct pfioc_src_nodes\');}' unless defined(&DIOCGETSRCNODES);
    eval 'sub DIOCCLRSRCNODES () { &_IO(ord(\'D\'), 85);}' unless defined(&DIOCCLRSRCNODES);
    eval 'sub DIOCSETHOSTID () { &_IOWR(ord(\'D\'), 86,  &u_int32_t);}' unless defined(&DIOCSETHOSTID);
    eval 'sub DIOCIGETIFACES () { &_IOWR(ord(\'D\'), 87, \'struct pfioc_iface\');}' unless defined(&DIOCIGETIFACES);
    eval 'sub DIOCSETIFFLAG () { &_IOWR(ord(\'D\'), 89, \'struct pfioc_iface\');}' unless defined(&DIOCSETIFFLAG);
    eval 'sub DIOCCLRIFFLAG () { &_IOWR(ord(\'D\'), 90, \'struct pfioc_iface\');}' unless defined(&DIOCCLRIFFLAG);
    eval 'sub DIOCKILLSRCNODES () { &_IOWR(ord(\'D\'), 91, \'struct pfioc_src_node_kill\');}' unless defined(&DIOCKILLSRCNODES);
    if(defined(&_KERNEL)) {
	if(defined(&INET)) {
	}
	if(defined(&INET6)) {
	}
	if(defined(&_MODULE)) {
	}
	if(defined(&_MODULE)) {
	}
	if(defined(&_MODULE)) {
	}
	if(defined(&__NetBSD__)) {
	} else {
	}
	if(!defined(&PRIu32)) {
	    eval 'sub PRIu32 () {"u";}' unless defined(&PRIu32);
	}
	if(!defined(&NO_PID)) {
	    eval 'sub NO_PID () {( &PID_MAX + 1);}' unless defined(&NO_PID);
	}
	if(defined(&__NetBSD__)) {
	    eval 'sub rw_enter_write {
	        my($a) = @_;
    		eval q( &rw_enter(($a), ( &RW_WRITER)));
	    }' unless defined(&rw_enter_write);
	    eval 'sub rw_exit_write {
	        my($a) = @_;
    		eval q( &rw_exit(($a)));
	    }' unless defined(&rw_exit_write);
	    eval 'sub rw_enter_read {
	        my($a) = @_;
    		eval q( &rw_enter(($a), ( &RW_READER)));
	    }' unless defined(&rw_enter_read);
	    eval 'sub rw_exit_read {
	        my($a) = @_;
    		eval q( &rw_exit(($a)));
	    }' unless defined(&rw_exit_read);
	}
    }
    eval 'sub pf_main_ruleset () { ($pf_main_anchor->{ruleset});}' unless defined(&pf_main_ruleset);
    if(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
    }
    if(defined(&_MODULE)) {
    }
}
1;
