; mell-extra.el: Mell functions which work with extra packages.
; $Id: mell-extra.el,v 1.1.1.1 2003/06/01 03:04:44 komatsu Exp $
;
; Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
;     All rights reserved.
;     This is free software with ABSOLUTELY NO WARRANTY.
;
; You can redistribute it and/or modify it under the terms of 
; the GNU General Public License version 2.

;;; ------------------------------------------------------------
;;; kakasi
;;; ------------------------------------------------------------
(require 'mell)
(require 'kakasi nil t)

(defun mell-skip-syntax-forward (syntax &optional limit buffer)
  (and buffer (set-buffer buffer))
  (if (and (featurep 'kakasi)
	   running-xemacs
	   (string-match "\\cj" (string (char-after))))
      (let ((word-pair (kakasi-function-current-word)))
	(goto-char (+ (cdr word-pair) (length (car word-pair))))
	)
    (skip-syntax-forward syntax limit)
    ))

(defun mell-skip-syntax-backward (syntax &optional limit buffer)
  (and buffer (set-buffer buffer))
  (if (and (featurep 'kakasi)
	   running-xemacs
	   (string-match "\\cj" (string (char-after))))
      (let ((word-pair (kakasi-function-current-word)))
	(goto-char (cdr word-pair))
	)
    (skip-syntax-backward syntax limit)
    ))

(provide 'mell-extra)