;;;; mell-alist.el: MELL for alist.
;;;; $Id: mell-alist.el,v 1.1.1.1 2003/06/01 03:04:44 komatsu Exp $
;;;;
;;;; Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
;;;;     All rights reserved.
;;;;     This is free software with ABSOLUTELY NO WARRANTY.
;;;;
;;;; You can redistribute it and/or modify it under the terms of 
;;;; the GNU General Public License version 2.

(require 'mell)

;; ------------------------------------------------------------
;; mell-alist
;; ------------------------------------------------------------

(defun mell-alist-add! (alist new-cons)
  (if (null alist)
      (error "mell-alist-add! can not deal nil as an alist.")
    (let ((current-cons (assoc (car new-cons) alist)))
      (if current-cons
	  (setcdr current-cons (cdr new-cons))
	(if (car alist)
	    (nconc alist (list new-cons))
	  (setcar alist new-cons))
	)
      alist)))
  
(defun mell-alist-add (alist new-cons)
  (if (null alist)
      (list new-cons)
    (let ((return-alist (copy-alist alist)))
      (mell-alist-add! return-alist new-cons)
      return-alist)))
  
(defun mell-alist-delete (alist key)
  (if key
      (let (return-alist)
	(mapcar '(lambda (x)
		   (or (equal key (car x))
		       (setq return-alist (cons x return-alist))))
		alist)
	(if return-alist
	    (reverse return-alist)
	  (list nil)))
    alist)
  )

(define-obsolete-function-alias
  'delete-assoc 'mell-alist-delete)

(defun mell-alist-combine (var-list val-list)
  (let ((i 0))
    (mapcar '(lambda (var) 
	       (prog1 (cons var (nth i val-list))
		 (setq i (1+ i))))
	    var-list)))

(define-obsolete-function-alias
  'mell-make-alist 'mell-alist-combine)

(defun mell-alist-get-value (key alist)
  (if (consp alist)
      (let ((assoc-pair (assoc key alist)))
	(if assoc-pair
	    (cdr assoc-pair)
	  (cdr (assoc t alist))))
    alist))

(provide 'mell-alist)
