/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DbAppendRecno;
import com.sleepycat.db.DbBtreeCompare;
import com.sleepycat.db.DbBtreePrefix;
import com.sleepycat.db.DbDupCompare;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbErrcall;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbFeedback;
import com.sleepycat.db.DbHash;
import com.sleepycat.db.DbKeyRange;
import com.sleepycat.db.DbOutputStreamErrcall;
import com.sleepycat.db.DbSecondaryKeyCreate;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import java.io.FileNotFoundException;
import java.io.OutputStream;

public class Db {
    public static final int DB_BTREE = 1;
    public static final int DB_DONOTINDEX = -30999;
    public static final int DB_HASH = 2;
    public static final int DB_INCOMPLETE = -30998;
    public static final int DB_KEYEMPTY = -30997;
    public static final int DB_KEYEXIST = -30996;
    public static final int DB_LOCK_DEADLOCK = -30995;
    public static final int DB_LOCK_NOTGRANTED = -30994;
    public static final int DB_NOSERVER = -30993;
    public static final int DB_NOSERVER_HOME = -30992;
    public static final int DB_NOSERVER_ID = -30991;
    public static final int DB_NOTFOUND = -30990;
    public static final int DB_OLD_VERSION = -30989;
    public static final int DB_PAGE_NOTFOUND = -30988;
    public static final int DB_QUEUE = 4;
    public static final int DB_RECNO = 3;
    public static final int DB_RUNRECOVERY = -30987;
    public static final int DB_SECONDARY_BAD = -30986;
    public static final int DB_TXN_ABORT = 0;
    public static final int DB_TXN_BACKWARD_ROLL = 1;
    public static final int DB_TXN_FORWARD_ROLL = 2;
    public static final int DB_UNKNOWN = 5;
    public static final int DB_VERIFY_BAD = -30985;
    public static final int DB_AFTER;
    public static final int DB_AGGRESSIVE;
    public static final int DB_APPEND;
    public static final int DB_ARCH_ABS;
    public static final int DB_ARCH_DATA;
    public static final int DB_ARCH_LOG;
    public static final int DB_BEFORE;
    public static final int DB_CACHED_COUNTS;
    public static final int DB_CDB_ALLDB;
    public static final int DB_CHECKPOINT;
    public static final int DB_CLIENT;
    public static final int DB_CONSUME;
    public static final int DB_CONSUME_WAIT;
    public static final int DB_CREATE;
    public static final int DB_CURLSN;
    public static final int DB_CURRENT;
    public static final int DB_CXX_NO_EXCEPTIONS;
    public static final int DB_DBT_MALLOC;
    public static final int DB_DBT_PARTIAL;
    public static final int DB_DBT_REALLOC;
    public static final int DB_DBT_USERMEM;
    public static final int DB_DIRTY_READ;
    public static final int DB_DUP;
    public static final int DB_DUPSORT;
    public static final int DB_EXCL;
    public static final int DB_FAST_STAT;
    public static final int DB_FIRST;
    public static final int DB_FLUSH;
    public static final int DB_FORCE;
    public static final int DB_GET_BOTH;
    public static final int DB_GET_RECNO;
    public static final int DB_INIT_CDB;
    public static final int DB_INIT_LOCK;
    public static final int DB_INIT_LOG;
    public static final int DB_INIT_MPOOL;
    public static final int DB_INIT_TXN;
    public static final int DB_JOINENV;
    public static final int DB_JOIN_ITEM;
    public static final int DB_JOIN_NOSORT;
    public static final int DB_KEYFIRST;
    public static final int DB_KEYLAST;
    public static final int DB_LAST;
    public static final int DB_LOCKDOWN;
    public static final int DB_LOCK_DEFAULT;
    public static final int DB_LOCK_GET;
    public static final int DB_LOCK_IREAD;
    public static final int DB_LOCK_IWR;
    public static final int DB_LOCK_IWRITE;
    public static final int DB_LOCK_MAXLOCKS;
    public static final int DB_LOCK_MINLOCKS;
    public static final int DB_LOCK_MINWRITE;
    public static final int DB_LOCK_NOWAIT;
    public static final int DB_LOCK_OLDEST;
    public static final int DB_LOCK_PUT;
    public static final int DB_LOCK_PUT_ALL;
    public static final int DB_LOCK_PUT_OBJ;
    public static final int DB_LOCK_RANDOM;
    public static final int DB_LOCK_READ;
    public static final int DB_LOCK_WRITE;
    public static final int DB_LOCK_YOUNGEST;
    public static final int DB_MULTIPLE;
    public static final int DB_MULTIPLE_KEY;
    public static final int DB_NEXT;
    public static final int DB_NEXT_DUP;
    public static final int DB_NEXT_NODUP;
    public static final int DB_NODUPDATA;
    public static final int DB_NOMMAP;
    public static final int DB_NOORDERCHK;
    public static final int DB_NOOVERWRITE;
    public static final int DB_NOSYNC;
    public static final int DB_ORDERCHKONLY;
    public static final int DB_POSITION;
    public static final int DB_PREV;
    public static final int DB_PREV_NODUP;
    public static final int DB_PRIVATE;
    public static final int DB_RDONLY;
    public static final int DB_RECNUM;
    public static final int DB_RECORDCOUNT;
    public static final int DB_RECOVER;
    public static final int DB_RECOVER_FATAL;
    public static final int DB_RENUMBER;
    public static final int DB_REVSPLITOFF;
    public static final int DB_RMW;
    public static final int DB_SALVAGE;
    public static final int DB_SET;
    public static final int DB_SET_RANGE;
    public static final int DB_SET_RECNO;
    public static final int DB_SNAPSHOT;
    public static final int DB_SYSTEM_MEM;
    public static final int DB_THREAD;
    public static final int DB_TRUNCATE;
    public static final int DB_TXN_NOSYNC;
    public static final int DB_TXN_NOWAIT;
    public static final int DB_TXN_SYNC;
    public static final int DB_UPGRADE;
    public static final int DB_USE_ENVIRON;
    public static final int DB_USE_ENVIRON_ROOT;
    public static final int DB_VERB_CHKPOINT;
    public static final int DB_VERB_DEADLOCK;
    public static final int DB_VERB_RECOVERY;
    public static final int DB_VERB_WAITSFOR;
    public static final int DB_VERIFY;
    public static final int DB_VERSION_MAJOR;
    public static final int DB_VERSION_MINOR;
    public static final int DB_VERSION_PATCH;
    public static final int DB_WRITECURSOR;
    public static final int DB_XA_CREATE;
    public static final int DB_XIDDATASIZE;
    private long private_dbobj_ = 0L;
    private long private_info_ = 0L;
    private DbEnv dbenv_ = null;
    private DbEnv constructor_env_ = null;
    private DbFeedback feedback_ = null;
    private DbAppendRecno append_recno_ = null;
    private DbBtreeCompare bt_compare_ = null;
    private DbBtreePrefix bt_prefix_ = null;
    private DbDupCompare dup_compare_ = null;
    private DbHash h_hash_ = null;
    private DbSecondaryKeyCreate secondary_key_create_ = null;
    private static boolean already_loaded_;

    public Db(DbEnv dbEnv, int n) throws DbException {
        this.constructor_env_ = dbEnv;
        this._init(dbEnv, n);
        this.dbenv_ = dbEnv == null ? new DbEnv(this) : dbEnv;
        this.dbenv_._add_db(this);
    }

    void _notify_dbenv_close() {
        this.dbenv_ = null;
        this._notify_internal();
    }

    private native void _init(DbEnv var1, int var2) throws DbException;

    private native void _notify_internal();

    public synchronized void associate(Db db, DbSecondaryKeyCreate dbSecondaryKeyCreate, int n) throws DbException {
        db.secondary_key_create_ = dbSecondaryKeyCreate;
        this._associate(db, dbSecondaryKeyCreate, n);
    }

    public native void _associate(Db var1, DbSecondaryKeyCreate var2, int var3) throws DbException;

    public synchronized int close(int n) throws DbException {
        this.dbenv_._remove_db(this);
        int n2 = this._close(n);
        if (this.constructor_env_ == null) {
            this.dbenv_._notify_db_close();
        }
        return n2;
    }

    public native int _close(int var1) throws DbException;

    public native Dbc cursor(DbTxn var1, int var2) throws DbException;

    public native int del(DbTxn var1, Dbt var2, int var3) throws DbException;

    public native void err(int var1, String var2);

    public native void errx(String var1);

    public native int fd() throws DbException;

    protected void finalize() throws Throwable {
        this._finalize(this.dbenv_.errcall_, this.dbenv_.errpfx_);
    }

    protected native void _finalize(DbErrcall var1, String var2) throws Throwable;

    public native int get(DbTxn var1, Dbt var2, Dbt var3, int var4) throws DbException;

    public native boolean get_byteswapped();

    public native int get_type();

    public native Dbc join(Dbc[] var1, int var2) throws DbException;

    public native void key_range(DbTxn var1, Dbt var2, DbKeyRange var3, int var4) throws DbException;

    public synchronized void open(String string, String string2, int n, int n2, int n3) throws DbException, FileNotFoundException {
        this._open(string, string2, n, n2, n3);
    }

    public native void _open(String var1, String var2, int var3, int var4, int var5) throws DbException, FileNotFoundException;

    public native int pget(DbTxn var1, Dbt var2, Dbt var3, Dbt var4, int var5) throws DbException;

    public native int put(DbTxn var1, Dbt var2, Dbt var3, int var4) throws DbException;

    public synchronized native void rename(String var1, String var2, String var3, int var4) throws DbException, FileNotFoundException;

    public synchronized native void remove(String var1, String var2, int var3) throws DbException, FileNotFoundException;

    public void set_append_recno(DbAppendRecno dbAppendRecno) throws DbException {
        this.append_recno_ = dbAppendRecno;
        this.append_recno_changed(dbAppendRecno);
    }

    private native void append_recno_changed(DbAppendRecno var1) throws DbException;

    public void set_bt_compare(DbBtreeCompare dbBtreeCompare) throws DbException {
        this.bt_compare_ = dbBtreeCompare;
        this.bt_compare_changed(dbBtreeCompare);
    }

    private native void bt_compare_changed(DbBtreeCompare var1) throws DbException;

    public native void set_bt_maxkey(int var1) throws DbException;

    public native void set_bt_minkey(int var1) throws DbException;

    public void set_bt_prefix(DbBtreePrefix dbBtreePrefix) throws DbException {
        this.bt_prefix_ = dbBtreePrefix;
        this.bt_prefix_changed(dbBtreePrefix);
    }

    private native void bt_prefix_changed(DbBtreePrefix var1) throws DbException;

    public native void set_cachesize(int var1, int var2, int var3) throws DbException;

    public void set_dup_compare(DbDupCompare dbDupCompare) throws DbException {
        this.dup_compare_ = dbDupCompare;
        this.dup_compare_changed(dbDupCompare);
    }

    private native void dup_compare_changed(DbDupCompare var1) throws DbException;

    public void set_errcall(DbErrcall dbErrcall) {
        if (this.dbenv_ != null) {
            this.dbenv_.set_errcall(dbErrcall);
        }
    }

    public void set_error_stream(OutputStream outputStream) {
        DbOutputStreamErrcall dbOutputStreamErrcall = new DbOutputStreamErrcall(outputStream);
        this.set_errcall(dbOutputStreamErrcall);
    }

    public void set_errpfx(String string) {
        if (this.dbenv_ != null) {
            this.dbenv_.set_errpfx(string);
        }
    }

    public void set_feedback(DbFeedback dbFeedback) throws DbException {
        this.feedback_ = dbFeedback;
        this.feedback_changed(dbFeedback);
    }

    private native void feedback_changed(DbFeedback var1) throws DbException;

    public native void set_flags(int var1);

    public native void set_h_ffactor(int var1);

    public void set_h_hash(DbHash dbHash) throws DbException {
        this.h_hash_ = dbHash;
        this.hash_changed(dbHash);
    }

    private native void hash_changed(DbHash var1) throws DbException;

    public native void set_h_nelem(int var1);

    public native void set_lorder(int var1);

    public native void set_pagesize(long var1);

    public native void set_re_delim(int var1);

    public native void set_re_len(int var1);

    public native void set_re_pad(int var1);

    public native void set_re_source(String var1);

    public native void set_q_extentsize(int var1);

    public native Object stat(int var1) throws DbException;

    public native int sync(int var1) throws DbException;

    public native int truncate(DbTxn var1, int var2) throws DbException;

    public native void upgrade(String var1, int var2) throws DbException;

    public native void verify(String var1, String var2, OutputStream var3, int var4) throws DbException;

    public static void load_db() {
        if (already_loaded_) {
            return;
        }
        String string = System.getProperty("sleepycat.db.libname");
        if (string != null) {
            System.loadLibrary(string);
        } else {
            String string2 = System.getProperty("os.name");
            if (string2 != null && string2.startsWith("Windows")) {
                System.loadLibrary("libdb_java33");
            } else {
                System.loadLibrary("db_java-3.3");
            }
        }
        already_loaded_ = true;
    }

    private static native void one_time_init();

    private static void check_constant(int n, int n2) {
        if (n != n2) {
            System.err.println("Db: constant mismatch");
            Thread.dumpStack();
            System.exit(1);
        }
    }

    static {
        already_loaded_ = false;
        Db.load_db();
        DB_AFTER = 1;
        DB_AGGRESSIVE = 1;
        DB_APPEND = 2;
        DB_ARCH_ABS = 1;
        DB_ARCH_DATA = 2;
        DB_ARCH_LOG = 4;
        DB_BEFORE = 3;
        DB_CACHED_COUNTS = 4;
        DB_CDB_ALLDB = 1024;
        DB_CHECKPOINT = 5;
        DB_CLIENT = 1024;
        DB_CONSUME = 7;
        DB_CONSUME_WAIT = 8;
        DB_CREATE = 1;
        DB_CURLSN = 9;
        DB_CURRENT = 10;
        DB_CXX_NO_EXCEPTIONS = 2;
        DB_DBT_MALLOC = 4;
        DB_DBT_PARTIAL = 8;
        DB_DBT_REALLOC = 16;
        DB_DBT_USERMEM = 32;
        DB_DIRTY_READ = 0x10000000;
        DB_DUP = 1;
        DB_DUPSORT = 2;
        DB_EXCL = 1024;
        DB_FAST_STAT = 11;
        DB_FIRST = 12;
        DB_FLUSH = 13;
        DB_FORCE = 4;
        DB_GET_BOTH = 14;
        DB_GET_RECNO = 16;
        DB_INIT_CDB = 1024;
        DB_INIT_LOCK = 2048;
        DB_INIT_LOG = 4096;
        DB_INIT_MPOOL = 8192;
        DB_INIT_TXN = 16384;
        DB_JOINENV = 32768;
        DB_JOIN_ITEM = 17;
        DB_JOIN_NOSORT = 1;
        DB_KEYFIRST = 18;
        DB_KEYLAST = 19;
        DB_LAST = 20;
        DB_LOCKDOWN = 65536;
        DB_LOCK_DEFAULT = 1;
        DB_LOCK_GET = 1;
        DB_LOCK_IREAD = 5;
        DB_LOCK_IWR = 6;
        DB_LOCK_IWRITE = 4;
        DB_LOCK_MAXLOCKS = 2;
        DB_LOCK_MINLOCKS = 3;
        DB_LOCK_MINWRITE = 4;
        DB_LOCK_NOWAIT = 1;
        DB_LOCK_OLDEST = 5;
        DB_LOCK_PUT = 3;
        DB_LOCK_PUT_ALL = 4;
        DB_LOCK_PUT_OBJ = 5;
        DB_LOCK_RANDOM = 6;
        DB_LOCK_READ = 1;
        DB_LOCK_WRITE = 2;
        DB_LOCK_YOUNGEST = 7;
        DB_MULTIPLE = 0x20000000;
        DB_MULTIPLE_KEY = 0x40000000;
        DB_NEXT = 21;
        DB_NEXT_DUP = 22;
        DB_NEXT_NODUP = 23;
        DB_NODUPDATA = 24;
        DB_NOMMAP = 8;
        DB_NOORDERCHK = 2;
        DB_NOOVERWRITE = 25;
        DB_NOSYNC = 26;
        DB_ORDERCHKONLY = 4;
        DB_POSITION = 27;
        DB_PREV = 29;
        DB_PREV_NODUP = 30;
        DB_PRIVATE = 131072;
        DB_RDONLY = 16;
        DB_RECNUM = 4;
        DB_RECORDCOUNT = 31;
        DB_RECOVER = 32;
        DB_RECOVER_FATAL = 262144;
        DB_RENUMBER = 8;
        DB_REVSPLITOFF = 16;
        DB_RMW = Integer.MIN_VALUE;
        DB_SALVAGE = 32;
        DB_SET = 32;
        DB_SET_RANGE = 33;
        DB_SET_RECNO = 34;
        DB_SNAPSHOT = 32;
        DB_SYSTEM_MEM = 524288;
        DB_THREAD = 64;
        DB_TRUNCATE = 16384;
        DB_TXN_NOSYNC = 128;
        DB_TXN_NOWAIT = 1024;
        DB_TXN_SYNC = 2048;
        DB_UPGRADE = 1024;
        DB_USE_ENVIRON = 256;
        DB_USE_ENVIRON_ROOT = 512;
        DB_VERB_CHKPOINT = 1;
        DB_VERB_DEADLOCK = 2;
        DB_VERB_RECOVERY = 4;
        DB_VERB_WAITSFOR = 8;
        DB_VERIFY = 2048;
        DB_VERSION_MAJOR = 3;
        DB_VERSION_MINOR = 3;
        DB_VERSION_PATCH = 11;
        DB_WRITECURSOR = 36;
        DB_XA_CREATE = 1024;
        DB_XIDDATASIZE = 128;
        Db.one_time_init();
    }
}

