/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.igoweb.go.Loc;
import org.igoweb.go.swing.StoneImages;

public class StonePrinter
extends StoneImages {
    public static final int H_LEFT = 0;
    public static final int H_MIDDLE = 1;
    public static final int H_RIGHT = 2;
    public static final int V_TOP = 0;
    public static final int V_MIDDLE = 3;
    public static final int V_BOTTOM = 6;
    public static final int HOSHI = 9;
    private final Shape wStone;
    private final Shape bStone;
    private final Shape wStoneInside;
    private final Shape[] gridShapes = new Shape[10];

    public StonePrinter(double size) {
        super(size, false);
        this.drawGrids(size, true, true);
        this.drawMarks(size);
        this.bStone = new Ellipse2D.Double(0.0, 0.0, size, size);
        double stoneBorder = size / 60.0;
        Area tempW = new Area(this.bStone);
        tempW.subtract(new Area(new Ellipse2D.Double(stoneBorder, stoneBorder, size - 2.0 * stoneBorder, size - 2.0 * stoneBorder)));
        this.wStone = tempW;
        this.wStoneInside = new Ellipse2D.Double(stoneBorder * 0.5, stoneBorder * 0.5, size - stoneBorder, size - stoneBorder);
    }

    private void drawGrids(double locSize, boolean pureLines, boolean thickenOutside) {
        double lineW = locSize / 30.0;
        double mid = !pureLines && lineW < 1.0 ? Math.floor(locSize * 0.5) + 0.5 : locSize * 0.5;
        double midLo = mid - lineW * 0.5;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 9; y += 3) {
                double shapeLo = 0.0;
                double shapeW = locSize;
                double tempLineW = lineW;
                if (thickenOutside && (y == 0 || y == 6)) {
                    tempLineW *= 2.0;
                }
                midLo = mid - tempLineW * 0.5;
                if (x == 0) {
                    shapeLo = midLo;
                    shapeW -= midLo;
                } else if (x == 2) {
                    shapeW = midLo + tempLineW;
                }
                Area grid = new Area(new Rectangle2D.Double(shapeLo, midLo, shapeW, tempLineW));
                shapeLo = 0.0;
                shapeW = locSize;
                tempLineW = lineW;
                if (thickenOutside && (x == 0 || x == 2)) {
                    tempLineW *= 2.0;
                }
                midLo = mid - tempLineW * 0.5;
                if (y == 0) {
                    shapeLo = midLo;
                    shapeW -= midLo;
                } else if (y == 6) {
                    shapeW = midLo + tempLineW;
                }
                grid.add(new Area(new Rectangle2D.Double(midLo, shapeLo, tempLineW, shapeW)));
                this.gridShapes[x + y] = grid;
            }
        }
        Area hoshi = new Area(new Ellipse2D.Double(mid -= (lineW *= 4.571428571428571) * 0.5, mid, lineW, lineW));
        hoshi.add((Area)this.gridShapes[4]);
        this.gridShapes[9] = hoshi;
    }

    @Override
    protected void drawStoneImage(Graphics2D g, int imageId) {
        if (imageId == 0 || imageId == 1) {
            g.fill(this.bStone);
        } else {
            g.setColor(Color.white);
            g.fill(this.wStoneInside);
            g.setColor(Color.black);
            g.fill(this.wStone);
        }
    }

    @Override
    protected void drawSmallStoneImage(Graphics2D g, int imageId, int offset) {
    }

    public final void paintGrid(Graphics2D g2d, Loc loc, int boardSize) {
        int gridShapeId;
        if (boardSize == 9 && (loc.x == 2 || loc.x == 6) && (loc.y == 2 || loc.y == 6) || boardSize > 9 && (loc.x == 3 || loc.x == boardSize - 4 || (boardSize & 1) == 1 && loc.x == boardSize / 2) && (loc.y == 3 || loc.y == boardSize - 4 || (boardSize & 1) == 1 && loc.y == boardSize / 2)) {
            gridShapeId = 9;
        } else {
            int hId = loc.x == 0 ? 0 : (loc.x == boardSize - 1 ? 2 : 1);
            gridShapeId = loc.y == 0 ? 0 + hId : (loc.y == boardSize - 1 ? 6 + hId : 3 + hId);
        }
        g2d.fill(this.gridShapes[gridShapeId]);
    }
}

