/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSReferenceInspectionVisitor
extends JSElementVisitor {
    @NotNull
    protected final JSReferenceInspectionProblemReporter myReporter;

    public JSReferenceInspectionVisitor(@NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            JSReferenceInspectionVisitor.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    protected boolean isAcceptable(@NotNull PsiElement element) {
        if (element == null) {
            JSReferenceInspectionVisitor.$$$reportNull$$$0(1);
        }
        return !DialectDetector.isTypeScript(element);
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkRefExpression(node);
    }

    public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ES6ExportDeclaration declaration = node.getDeclaration();
        if (declaration != null && declaration.getFromClause() == null) {
            ResolveResult result2;
            ResolveResult[] results = node.multiResolve(false);
            if (results.length == 0) {
                this.myReporter.reportUnresolvedVariableError((PsiElement)node, null, XmlHighlightVisitor.getErrorDescription((PsiReference)node), ContainerUtil.newArrayList((Object[])JSReferenceChecker.collectCreateFromUsageFixesForImportExport((ES6ImportExportDeclarationPart)node)));
            } else if (results.length == 1 && !(result2 = results[0]).isValidResult()) {
                String key;
                String message = null;
                if (result2 instanceof JSResolveResult && (key = ((JSResolveResult)result2).getResolveProblemKey()) != null) {
                    message = JSBundle.message((String)key, (Object[])new Object[0]);
                }
                String s = message != null ? message : XmlHighlightVisitor.getErrorDescription((PsiReference)node);
                this.myReporter.reportUnresolvedVariableError((PsiElement)node, null, s, null);
            }
        }
    }

    public void visitES6TaggedTemplateExpression(ES6TaggedTemplateExpression expression) {
        if (!this.isAcceptable((PsiElement)expression)) {
            return;
        }
        JSExpression tag = expression.getTag();
        if (tag instanceof JSReferenceExpression) {
            JSAnalysisHandlersFactory.forElement((PsiElement)expression).getReferenceChecker(this.myReporter).checkCallReferences((JSReferenceExpression)tag, false);
        }
    }

    public void visitJSCallExpression(JSCallExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSExpression methodExpression = node.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkCallReferences((JSReferenceExpression)methodExpression, node instanceof JSNewExpression);
        } else if (methodExpression instanceof JSNewExpression) {
            JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkNewExpressionInsideCallReferences(methodExpression);
        }
    }

    public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
        if (node == null) {
            JSReferenceInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        if (node instanceof JSXXmlLiteralExpressionImpl) {
            this.processXmlLiteralExpression((JSXXmlLiteralExpressionImpl)node);
        }
        super.visitJSLiteralExpression(node);
    }

    private void processXmlLiteralExpression(JSXmlLiteralExpression expression) {
        ASTNode nameNode;
        if (!StringUtil.isCapitalized((String)expression.getName())) {
            return;
        }
        boolean isResolved = JSXHarmonyLanguageDialect.areReferencesResolvedOrEmpty(expression);
        if (!isResolved && (DialectDetector.isTypeScript((PsiElement)expression) || ES6PsiUtil.findExternalModule((PsiElement)expression) != null) && (nameNode = expression.getNode().findChildByType(JSTokenTypes.XML_TAG_NAME)) != null) {
            PsiElement psi = nameNode.getPsi();
            this.myReporter.reportUnresolvedVariableError(psi, ProblemHighlightType.WEAK_WARNING, JSBundle.message((String)"javascript.validation.message.unresolved.component", (Object[])new Object[0]), this.getUnresolvedXmlLiteralFixes(expression, psi));
        }
    }

    @NotNull
    protected List<LocalQuickFix> getUnresolvedXmlLiteralFixes(@NotNull JSXmlLiteralExpression expression, @NotNull PsiElement psi) {
        if (expression == null) {
            JSReferenceInspectionVisitor.$$$reportNull$$$0(3);
        }
        if (psi == null) {
            JSReferenceInspectionVisitor.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSReferenceInspectionVisitor.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSReferenceInspectionVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSReferenceInspectionVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedXmlLiteralFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitJSLiteralExpression";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedXmlLiteralFixes";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

