/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.generation;

import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtilRt;
import com.jetbrains.php.joomla.generation.JoomlaProjectGeneratorSettings;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.joomla.settings.JoomlaSettingsPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JoomlaCreateProjectForm {
    private final List<WebProjectGenerator.SettingsStateListener> myStateListeners;
    private JPanel myMainPanel;
    private JoomlaSettingsPanel mySettingsPanel;

    public JoomlaCreateProjectForm() {
        this.$$$setupUI$$$();
        this.myStateListeners = ContainerUtilRt.newArrayList();
        this.fireStateChanged();
        Runnable listener = () -> this.fireStateChanged();
        this.mySettingsPanel.setPath(JoomlaDataService.getLastJoomlaPath());
        this.mySettingsPanel.setJoomlaConfigPathField(JoomlaDataService.getLastJoomlaConfigPath());
        this.mySettingsPanel.addComponentChangesListener(listener, JoomlaDataService.getLastJoomlaConfigPath());
    }

    private void createUIComponents() {
        this.mySettingsPanel = new JoomlaSettingsPanel(null, false, true);
    }

    public JComponent getContentPane() {
        return this.myMainPanel;
    }

    public JoomlaProjectGeneratorSettings getSettings() {
        JoomlaDataService.State state = new JoomlaDataService.State();
        state.setEnabled(true);
        this.mySettingsPanel.apply(state);
        return new JoomlaProjectGeneratorSettings(state);
    }

    public ValidationInfo validate() {
        String validationMessage = this.mySettingsPanel.getValidationMessage();
        if (validationMessage == null) {
            return null;
        }
        return new ValidationInfo(validationMessage);
    }

    public void addSettingsStateListener(WebProjectGenerator.SettingsStateListener listener) {
        this.myStateListeners.add(listener);
    }

    private void fireStateChanged() {
        boolean validSettings = this.validate() == null;
        for (WebProjectGenerator.SettingsStateListener listener : this.myStateListeners) {
            listener.stateChanged(validSettings);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JoomlaSettingsPanel joomlaSettingsPanel = this.mySettingsPanel;
        JComponent jComponent = joomlaSettingsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

