/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.cassandra.CassDdlParsing;
import com.intellij.sql.dialects.cassandra.CassDmlParsing;
import com.intellij.sql.dialects.cassandra.CassExpressionParsing;
import com.intellij.sql.dialects.cassandra.CassGeneratedParser;
import com.intellij.sql.dialects.cassandra.CassandraDialect;

public class CassandraParser
extends SqlParser {
    public CassandraParser() {
        super(CassandraDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b2) {
        return false;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return CassGeneratedParser.statement(builder, level);
    }

    @Override
    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return CassGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return CassDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return CassDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, CassExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = CassExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }
}

