/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDataSourceFromUrl
extends DumbAwareAction {
    private final DatabaseViewActions.DataSourceFactory myFactory;

    public AddDataSourceFromUrl(@NotNull DatabaseViewActions.DataSourceFactory factory) {
        if (factory == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(0);
        }
        super("Data Source from URL", null, DatabaseIcons.Connector);
        this.myFactory = factory;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(1);
        }
        boolean enabled = DatabaseViewActions.getDbFacade(e) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DbPsiFacade facade;
        if (e == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(2);
        }
        if ((facade = DatabaseViewActions.getDbFacade(e)) == null) {
            return;
        }
        AddDataSourceFromUrl.newDataSourceFromInput(facade.getProject(), this.myFactory, DatabaseViewActions.getDbGroupName(e));
    }

    public static void newDataSourceFromInput(@NotNull Project project, @NotNull DatabaseViewActions.DataSourceFactory factory, @Nullable String groupName) {
        if (project == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(4);
        }
        DatabaseViewActions.DataSourceFactory adjustedFactory = (facade, manager, dataSource) -> {
            if (factory == null) {
                AddDataSourceFromUrl.$$$reportNull$$$0(5);
            }
            dataSource.setGroupName(groupName);
            factory.create(facade, (DataSourceManager<LocalDataSource>)manager, dataSource);
        };
        new MyDialog(project, adjustedFactory){
            {
                this.setTitle("New Data Source from URL");
                this.getNameLabel().setText(UIUtil.replaceMnemonicAmpersand((String)"&URL:"));
            }

            @Override
            protected boolean useClipboardText(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(0);
                }
                return str.startsWith("jdbc:");
            }

            @Override
            @Nullable
            protected DatabaseDriver selectDriver(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(1);
                }
                ArrayList filtered = ContainerUtil.newArrayList();
                for (DatabaseDriver driver : this.myDrivers) {
                    if (!driver.matchesUrl(str)) continue;
                    filtered.add(driver);
                }
                if (filtered.size() < 1) {
                    return (DatabaseDriver)ContainerUtil.getFirstItem((List)filtered);
                }
                return this.disambiguate(str, (JBIterable<DatabaseDriver>)JBIterable.from((Iterable)filtered));
            }

            @Nullable
            private DatabaseDriver disambiguate(@NotNull String url, JBIterable<DatabaseDriver> filtered) {
                if (url == null) {
                    1.$$$reportNull$$$0(2);
                }
                return DbImplUtil.disambiguate(url, filtered);
            }

            @Override
            @NotNull
            protected Collection<? extends DatabaseDriver> getDatabaseDrivers() {
                Collection<? extends DatabaseDriver> collection = DatabaseDriverManager.getInstance().getDrivers();
                if (collection == null) {
                    1.$$$reportNull$$$0(3);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "url";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromUrl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDatabaseDrivers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "useClipboardText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "selectDriver";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "disambiguate";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "newDataSourceFromInput";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$newDataSourceFromInput$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class MyDialog
    extends CreateFileFromTemplateDialog {
        private final DatabaseViewActions.DataSourceFactory myFactory;
        protected final List<DatabaseDriver> myDrivers;
        protected final DbPsiFacade myFacade;
        protected final DataSourceManager myDataSourceManager;
        private boolean myKindUserEdited;
        private boolean myUpdating;

        MyDialog(@NotNull Project project, @NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (project == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            super(project);
            this.myDrivers = ContainerUtil.newArrayList();
            this.myFactory = factory;
            this.myFacade = DbPsiFacade.getInstance((Project)project);
            this.myDataSourceManager = LocalDataSourceManager.getInstance(project);
            this.setup();
        }

        private void setup() {
            this.getKindLabel().setText(UIUtil.replaceMnemonicAmpersand((String)"&Driver:"));
            this.myDrivers.addAll(this.getDatabaseDrivers());
            Collections.sort(this.myDrivers, (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
            for (DatabaseDriver driver : this.myDrivers) {
                this.getKindCombo().addItem(driver.getName(), driver.getIcon(0), driver.getName());
            }
            this.setTemplateKindComponentsVisible(true);
            this.getNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myUpdating = true;
                    try {
                        DatabaseDriver driver = this.selectDriver(this.getNameField().getText());
                        if (driver != null) {
                            this.getKindCombo().setSelectedName(driver.getName());
                        } else if (!myKindUserEdited) {
                            this.getKindCombo().getComboBox().setSelectedItem(null);
                        }
                    }
                    finally {
                        myUpdating = false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/AddDataSourceFromUrl$MyDialog$1", "textChanged"));
                }
            });
            String clipboardText = StringUtil.trim((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
            if (clipboardText != null && this.useClipboardText(clipboardText)) {
                this.getNameField().setText(clipboardText);
            }
            this.getKindCombo().getComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!myUpdating) {
                        myKindUserEdited = true;
                    }
                }
            });
        }

        @Nullable
        protected ValidationInfo doValidate() {
            if (this.getKindCombo().getComboBox().getSelectedItem() == null) {
                return new ValidationInfo("Please select driver");
            }
            return super.doValidate();
        }

        protected void doOKAction() {
            String selectedName = this.getKindCombo().getSelectedName();
            DatabaseDriver driver = (DatabaseDriver)ObjectUtils.notNull((Object)ContainerUtil.find(this.myDrivers, o -> Comparing.equal((String)selectedName, (String)o.getName())));
            String url = this.buildUrlForDriver(driver);
            ApplicationManager.getApplication().invokeLater(() -> {
                LocalDataSource dataSource = driver.createDataSource(null, null);
                dataSource.setUrlSmart(url);
                this.myFactory.create(this.myFacade, (DataSourceManager<LocalDataSource>)this.myDataSourceManager, dataSource);
            });
            super.doOKAction();
        }

        @NotNull
        protected String buildUrlForDriver(@NotNull DatabaseDriver driver) {
            if (driver == null) {
                MyDialog.$$$reportNull$$$0(2);
            }
            String string = this.getNameField().getText();
            if (string == null) {
                MyDialog.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected abstract boolean useClipboardText(@NotNull String var1);

        @Nullable
        protected abstract DatabaseDriver selectDriver(@NotNull String var1);

        @NotNull
        protected abstract Collection<? extends DatabaseDriver> getDatabaseDrivers();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromUrl$MyDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl$MyDialog";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildUrlForDriver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildUrlForDriver";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

