/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolBlackList
implements PersistentStateComponent<QualityToolBlackList> {
    private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();

    public boolean addFile(@NotNull VirtualFile file) {
        if (file == null) {
            QualityToolBlackList.$$$reportNull$$$0(0);
        }
        return !this.myFiles.contains(file) && this.myFiles.add(file);
    }

    public boolean containsFile(VirtualFile file) {
        return this.myFiles.contains(file);
    }

    @Nullable
    public QualityToolBlackList getState() {
        return this;
    }

    public void loadState(@NotNull QualityToolBlackList state) {
        if (state == null) {
            QualityToolBlackList.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public List<String> getFilePaths() {
        ArrayList<String> filePaths = new ArrayList<String>();
        this.myFiles.forEach(file -> filePaths.add(file.getPath()));
        return filePaths;
    }

    public void setFilePaths(List<String> filePaths) {
        for (String filePath : filePaths) {
            URL url = VfsUtilCore.convertToURL((String)VfsUtilCore.pathToUrl((String)filePath));
            if (url == null) continue;
            ContainerUtil.addIfNotNull(this.myFiles, (Object)VfsUtil.findFileByURL((URL)url));
        }
    }

    @NotNull
    public BlackListTableModel createTableModel() {
        BlackListTableModel blackListTableModel = new BlackListTableModel();
        if (blackListTableModel == null) {
            QualityToolBlackList.$$$reportNull$$$0(2);
        }
        return blackListTableModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolBlackList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolBlackList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class BlackListTableModel
    extends AbstractTableModel {
        private final List<VirtualFile> myEditableFileList = new ArrayList<VirtualFile>();
        private boolean myModifiedFlag = false;

        public BlackListTableModel() {
            this.myEditableFileList.addAll(QualityToolBlackList.this.myFiles);
        }

        @Override
        public int getRowCount() {
            return this.myEditableFileList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.myEditableFileList.get(rowIndex).getPresentableName();
                }
                case 1: {
                    return this.myEditableFileList.get(rowIndex).getPath();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Path";
                }
            }
            return null;
        }

        public void reset() {
            this.myEditableFileList.clear();
            this.myEditableFileList.addAll(QualityToolBlackList.this.myFiles);
            this.myModifiedFlag = false;
            this.fireTableDataChanged();
        }

        public void commit() {
            QualityToolBlackList.this.myFiles.clear();
            QualityToolBlackList.this.myFiles.addAll(this.myEditableFileList);
            this.myModifiedFlag = false;
        }

        public boolean isModified() {
            return this.myModifiedFlag;
        }

        public void removeAll(int[] indices) {
            if (indices == null || indices.length == 0) {
                return;
            }
            ArrayList<VirtualFile> toRemove = new ArrayList<VirtualFile>();
            for (int i : indices) {
                toRemove.add(this.myEditableFileList.get(i));
            }
            this.myEditableFileList.removeAll(toRemove);
            this.myModifiedFlag = true;
            this.fireTableDataChanged();
        }

        public void addAll(List<VirtualFile> files) {
            this.myEditableFileList.addAll(ContainerUtil.filter(files, file -> !this.myEditableFileList.contains(file)));
            this.myModifiedFlag = true;
            this.fireTableDataChanged();
        }

        public void clear() {
            this.myEditableFileList.clear();
            this.myModifiedFlag = true;
            this.fireTableDataChanged();
        }

        public List<VirtualFile> getEditableFileList() {
            return this.myEditableFileList;
        }
    }
}

