/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayMapCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayFillInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertArrayFilterToLoopQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpNameStyle;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayFillCanBeConvertedToLoopInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference arrayFillCall) {
                if (!PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(arrayFillCall, "array_fill")) {
                    return;
                }
                PsiElement[] arguments = arrayFillCall.getParameters();
                if (arguments.length == 3 && PhpPsiUtil.isOfType(arguments[0], new IElementType[]{PhpElementTypes.NUMBER, PhpStubElementTypes.VARIABLE}) && PhpPsiUtil.isOfType(arguments[1], new IElementType[]{PhpElementTypes.NUMBER, PhpStubElementTypes.VARIABLE})) {
                    holder.registerProblem(arrayFillCall.getFirstChild(), PhpBundle.message("inspection.arrayfill.can.be.converted.to.loop", new Object[0]), new LocalQuickFix[]{PhpConvertArrayFillToLoopQuickFix.INSTANCE});
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @Nullable
    public static String getForStatementTemplate(@NotNull String resultArrayName, @NotNull String iteratorName, @NotNull PsiElement[] arguments, @Nullable PsiElement pushedValue) {
        if (resultArrayName == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(2);
        }
        if (iteratorName == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(3);
        }
        if (arguments == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(4);
        }
        if (arguments.length != 3) {
            return null;
        }
        try {
            String initialValue = arguments[0].getText();
            String limitValue = arguments[1].getText();
            String conditionalValue = initialValue.startsWith("$") || limitValue.startsWith("$") ? initialValue + "+" + limitValue : String.valueOf(Integer.parseInt(initialValue) + Integer.parseInt(limitValue));
            return String.format("for ($%s = %s; $%s < %s; $%s++) {$%s[$%s]=%s;}", iteratorName, initialValue, iteratorName, conditionalValue, iteratorName, resultArrayName, iteratorName, pushedValue != null ? pushedValue.getText() : arguments[2].getText());
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFillCanBeConvertedToLoopInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultArrayName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteratorName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFillCanBeConvertedToLoopInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getForStatementTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpConvertArrayFillToLoopQuickFix
    extends PhpQuickFixBase {
        private static final String NAME = PhpBundle.message("quickfix.convert.arrayfill.to.loop", new Object[0]);
        private static final PhpConvertArrayFillToLoopQuickFix INSTANCE = new PhpConvertArrayFillToLoopQuickFix();
        private static final String[] ITERATOR_NAMES = "ijklmnopqrstuvwxyzabcdefgh".split("");

        private PhpConvertArrayFillToLoopQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = NAME;
            if (string == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            FunctionReference arrayFillCall;
            if (project == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(2);
            }
            if ((arrayFillCall = (FunctionReference)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF)) == null) {
                return;
            }
            Set occupiedNames = StreamEx.of(VariableImpl.collectDeclarations((PsiElement)arrayFillCall, false, null)).map(PhpNamedElement::getName).toSet();
            String resultArrayName = PhpConvertArrayFilterToLoopQuickFix.generateName((String)ContainerUtil.getFirstItem(PhpNameSuggestionUtil.nameByReference((PhpReference)arrayFillCall, PhpNameStyle.DECAPITALIZE), (Object)"x"), occupiedNames, new String[0]);
            occupiedNames.add(resultArrayName);
            String iteratorName = PhpConvertArrayFilterToLoopQuickFix.generateName("i", occupiedNames, ITERATOR_NAMES);
            PsiElement[] arguments = arrayFillCall.getParameters();
            Statement extractedVariableAssignment = this.extractVariableIfRequired(project, arguments[2], occupiedNames);
            String template = PhpArrayFillCanBeConvertedToLoopInspection.getForStatementTemplate(resultArrayName, iteratorName, arguments, PsiTreeUtil.findChildOfType((PsiElement)extractedVariableAssignment, Variable.class));
            if (template == null) {
                return;
            }
            if (extractedVariableAssignment != null) {
                PhpConvertArrayFilterToLoopQuickFix.replaceCallWithStatement(project, arrayFillCall, resultArrayName, (PsiElement)PhpPsiElementFactory.createFromText(project, For.class, template), new PsiElement[]{extractedVariableAssignment});
            } else {
                PhpConvertArrayFilterToLoopQuickFix.replaceCallWithStatement(project, arrayFillCall, resultArrayName, (PsiElement)PhpPsiElementFactory.createFromText(project, For.class, template), new PsiElement[0]);
            }
        }

        @Nullable
        public Statement extractVariableIfRequired(@NotNull Project project, PsiElement argument, Set<String> occupiedNames) {
            boolean scalarOrVariable;
            if (project == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(3);
            }
            if (scalarOrVariable = PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable((PsiElement)ObjectUtils.tryCast((Object)argument, PhpPsiElement.class), 0, new String[0])) {
                return null;
            }
            String name = PhpConvertArrayFilterToLoopQuickFix.generateName((String)ContainerUtil.getFirstItem(PhpNameSuggestionUtil.variableNameByPlace(argument), (Object)"x"), occupiedNames, new String[0]);
            return PhpPsiElementFactory.createStatement(project, "$" + name + " = " + argument.getText() + ";");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFillCanBeConvertedToLoopInspection$PhpConvertArrayFillToLoopQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFillCanBeConvertedToLoopInspection$PhpConvertArrayFillToLoopQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "extractVariableIfRequired";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

