/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.connection;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.FeatureSetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.SetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StdoutRedirectRequest;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XdebugConnectionConfigurator {
    protected static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.debug.xdebug.connection.XdebugConnectionConfigurator");
    private final List<FeatureSetRequest> myConfigurationCommand;
    private final boolean myWithOutputRedirect;
    private static final List<FeatureSetRequest> DEFAULT_PARAMETERS = ContainerUtil.immutableList((Object[])new FeatureSetRequest[]{DbgpRequest.setShowHidden(true), DbgpRequest.setMaxDepth(1), DbgpRequest.setMaxChildren(100), DbgpRequest.setExtendedProperties()});
    private static final List<FeatureSetRequest> DEFAULT_PARAMETERS_WITH_REDIRECT;

    private XdebugConnectionConfigurator(@NotNull List<FeatureSetRequest> configurationCommand, boolean withOutputRedirect) {
        if (configurationCommand == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(0);
        }
        this.myConfigurationCommand = configurationCommand;
        this.myWithOutputRedirect = withOutputRedirect;
    }

    @NotNull
    public static XdebugConnectionConfigurator create(boolean withRedirect) {
        XdebugConnectionConfigurator xdebugConnectionConfigurator = new XdebugConnectionConfigurator(withRedirect ? DEFAULT_PARAMETERS_WITH_REDIRECT : DEFAULT_PARAMETERS, withRedirect);
        if (xdebugConnectionConfigurator == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(1);
        }
        return xdebugConnectionConfigurator;
    }

    public void configure(@NotNull XdebugConnection connection, @NotNull Runnable onConfigured) {
        if (connection == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(2);
        }
        if (onConfigured == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(3);
        }
        if (this.myConfigurationCommand.isEmpty()) {
            this.onCompleted(connection, onConfigured);
        } else {
            this.setFeature(connection, 0, onConfigured);
        }
    }

    private void setFeature(final @NotNull XdebugConnection connection, final int index, final @NotNull Runnable onConfigured) {
        if (connection == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(4);
        }
        if (onConfigured == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(5);
        }
        final FeatureSetRequest request = this.myConfigurationCommand.get(index);
        connection.send(request, new DbgpResponseHandler<SetResponse>(){

            @Override
            public void onSuccessResponse(@NotNull SetResponse message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.onResponse();
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.info("Xdebug protocol doesn't support command: '" + request + "'");
                this.onResponse();
            }

            private void onResponse() {
                if (index < XdebugConnectionConfigurator.this.myConfigurationCommand.size() - 1) {
                    XdebugConnectionConfigurator.this.setFeature(connection, index + 1, onConfigured);
                } else {
                    XdebugConnectionConfigurator.this.onCompleted(connection, onConfigured);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnectionConfigurator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onCompleted(@NotNull XdebugConnection connection, final @NotNull Runnable onConfigured) {
        if (connection == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(6);
        }
        if (onConfigured == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(7);
        }
        if (this.myWithOutputRedirect) {
            connection.send(new StdoutRedirectRequest(), new DbgpResponseHandler<SetResponse>(){

                @Override
                public void onSuccessResponse(@NotNull SetResponse message) {
                    if (message == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!message.isSuccess()) {
                        LOG.info("Cannot redirect stdout");
                    }
                    onConfigured.run();
                }

                @Override
                public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                    if (errorResponse == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    LOG.info("Cannot redirect stdout: " + errorResponse.getErrorMessage());
                    onConfigured.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorResponse";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnectionConfigurator$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccessResponse";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onErrorResponse";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            onConfigured.run();
        }
    }

    static {
        ArrayList withRedirect = ContainerUtil.newArrayList(DEFAULT_PARAMETERS);
        withRedirect.add(DbgpRequest.setNotifications());
        DEFAULT_PARAMETERS_WITH_REDIRECT = ContainerUtil.immutableList((List)withRedirect);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationCommand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnectionConfigurator";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onConfigured";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnectionConfigurator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFeature";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onCompleted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

