/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassLookupElement
extends LookupElement {
    @NotNull
    private final PhpClass myClass;
    private final boolean myShowNamespace;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;
    @Nullable
    private String myLookupString;
    @Nullable
    private Set<String> myAllLookupStrings;
    @Nullable
    private String myTailText;

    public PhpClassLookupElement(@NotNull PhpClass phpClass, boolean showNamespace, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (phpClass == null) {
            PhpClassLookupElement.$$$reportNull$$$0(0);
        }
        this.myClass = phpClass;
        this.myShowNamespace = showNamespace;
        this.myInsertHandler = insertHandler;
    }

    @NotNull
    public String getLookupString() {
        if (this.myLookupString == null) {
            this.myLookupString = this.myClass.getName();
        }
        String string = this.myLookupString;
        if (string == null) {
            PhpClassLookupElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Set<String> getAllLookupStrings() {
        if (this.myAllLookupStrings == null) {
            this.myAllLookupStrings = Collections.singleton(this.getLookupString());
        }
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            PhpClassLookupElement.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public PhpClass getObject() {
        PhpClass phpClass = this.myClass;
        if (phpClass == null) {
            PhpClassLookupElement.$$$reportNull$$$0(3);
        }
        return phpClass;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            PhpClassLookupElement.$$$reportNull$$$0(4);
        }
        presentation.setItemText(this.getLookupString());
        String tailText = this.getTailText();
        if (!StringUtil.isEmpty((String)tailText)) {
            presentation.setTailText(tailText, (Color)JBColor.GRAY);
        }
        presentation.setIcon(this.myClass.getIcon());
    }

    @NotNull
    private String getTailText() {
        if (this.myTailText == null) {
            String namespaceName;
            this.myTailText = this.myShowNamespace ? (!StringUtil.isEmpty((String)(namespaceName = PhpLangUtil.toName(this.myClass.getNamespaceName()))) ? " (" + namespaceName + ")" : "") : "";
        }
        String string = this.myTailText;
        if (string == null) {
            PhpClassLookupElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            PhpClassLookupElement.$$$reportNull$$$0(6);
        }
        if (this.myInsertHandler != null) {
            this.myInsertHandler.handleInsert(context, (LookupElement)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PhpClassLookupElement element = (PhpClassLookupElement)((Object)o);
        if (this.myShowNamespace != element.myShowNamespace) {
            return false;
        }
        if (this.myAllLookupStrings != null ? !this.myAllLookupStrings.equals(element.myAllLookupStrings) : element.myAllLookupStrings != null) {
            return false;
        }
        if (!this.myClass.equals(element.myClass)) {
            return false;
        }
        if (this.myInsertHandler != null ? !this.myInsertHandler.equals(element.myInsertHandler) : element.myInsertHandler != null) {
            return false;
        }
        if (this.myLookupString != null ? !this.myLookupString.equals(element.myLookupString) : element.myLookupString != null) {
            return false;
        }
        return !(this.myTailText != null ? !this.myTailText.equals(element.myTailText) : element.myTailText != null);
    }

    public int hashCode() {
        int result = this.myClass.hashCode();
        result = 31 * result + (this.myShowNamespace ? 1 : 0);
        result = 31 * result + (this.myInsertHandler != null ? this.myInsertHandler.hashCode() : 0);
        result = 31 * result + (this.myLookupString != null ? this.myLookupString.hashCode() : 0);
        result = 31 * result + (this.myAllLookupStrings != null ? this.myAllLookupStrings.hashCode() : 0);
        result = 31 * result + (this.myTailText != null ? this.myTailText.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpClassLookupElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpClassLookupElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTailText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

