/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.LocalTimeCounter;

public class Expression {
    private final PsiFile myFile;
    private final LanguageFileType myFileType;
    private final PsiDocumentManager myDocMgr;
    private final Document myDocument;

    Expression(PsiFile file, LanguageFileType fileType) {
        this.myFile = file;
        this.myFileType = fileType;
        this.myDocMgr = PsiDocumentManager.getInstance((Project)file.getProject());
        this.myDocument = this.myDocMgr.getDocument(file);
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public LanguageFileType getFileType() {
        return this.myFileType;
    }

    public String getExpression() {
        this.myDocMgr.commitDocument(this.myDocument);
        String text = this.myFile.getText();
        assert (text.equals(this.myDocument.getText()));
        return text;
    }

    static Expression create(Project project, LanguageFileType fileType) {
        return Expression.create(project, fileType, "");
    }

    public static Expression create(Project project, LanguageFileType fileType, String expression) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xpath", (FileType)fileType, (CharSequence)expression, LocalTimeCounter.currentTime(), true);
        return new Expression(file, fileType);
    }
}

