/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Provider_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_PROVIDER_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_PROVIDER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CIconUrl;
class CId;
class CUrl;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CProvider_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CProvider_Base(void);
    // destructor
    virtual ~CProvider_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TName;
    typedef NCBI_NS_STD::string TNameAbbr;
    typedef CId TId;
    typedef CUrl TUrl;
    typedef CIconUrl TIconUrl;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Name,
        e_NameAbbr,
        e_Id,
        e_Url,
        e_IconUrl
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    ///ELEMENT	LinkName		(#PCDATA)
    ///defined in neighbor section
    /// \S+ 
    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// \S+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TNameAbbr
    ///  Check whether the NameAbbr data member has been assigned a value.
    bool IsSetNameAbbr(void) const;
    /// Check whether it is safe or not to call GetNameAbbr method.
    bool CanGetNameAbbr(void) const;
    void ResetNameAbbr(void);
    const TNameAbbr& GetNameAbbr(void) const;
    void SetNameAbbr(const TNameAbbr& value);
    void SetNameAbbr(TNameAbbr&& value);
    TNameAbbr& SetNameAbbr(void);

    /// \d+ 
    /// mandatory
    /// typedef CId TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);
    void SetId(const NCBI_NS_STD::string& value);

    /// cmd=llinks 
    /// \S+ 
    /// mandatory
    /// typedef CUrl TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(TUrl& value);
    TUrl& SetUrl(void);
    void SetUrl(const NCBI_NS_STD::string& value);

    /// \S+ 
    /// optional
    /// typedef CIconUrl TIconUrl
    ///  Check whether the IconUrl data member has been assigned a value.
    bool IsSetIconUrl(void) const;
    /// Check whether it is safe or not to call GetIconUrl method.
    bool CanGetIconUrl(void) const;
    void ResetIconUrl(void);
    const TIconUrl& GetIconUrl(void) const;
    void SetIconUrl(TIconUrl& value);
    TIconUrl& SetIconUrl(void);
    void SetIconUrl(const NCBI_NS_STD::string& value);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CProvider_Base(const CProvider_Base&);
    CProvider_Base& operator=(const CProvider_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_Name;
    NCBI_NS_STD::string m_NameAbbr;
    NCBI_NS_NCBI::CRef< TId > m_Id;
    NCBI_NS_NCBI::CRef< TUrl > m_Url;
    NCBI_NS_NCBI::CRef< TIconUrl > m_IconUrl;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CProvider_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CProvider_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CProvider_Base::TName& CProvider_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CProvider_Base::SetName(const CProvider_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CProvider_Base::SetName(CProvider_Base::TName&& value)
{
    m_Name = std::forward<CProvider_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CProvider_Base::TName& CProvider_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CProvider_Base::IsSetNameAbbr(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CProvider_Base::CanGetNameAbbr(void) const
{
    return IsSetNameAbbr();
}

inline
const CProvider_Base::TNameAbbr& CProvider_Base::GetNameAbbr(void) const
{
    if (!CanGetNameAbbr()) {
        ThrowUnassigned(1);
    }
    return m_NameAbbr;
}

inline
void CProvider_Base::SetNameAbbr(const CProvider_Base::TNameAbbr& value)
{
    m_NameAbbr = value;
    m_set_State[0] |= 0xc;
}

inline
void CProvider_Base::SetNameAbbr(CProvider_Base::TNameAbbr&& value)
{
    m_NameAbbr = std::forward<CProvider_Base::TNameAbbr>(value);
    m_set_State[0] |= 0xc;
}

inline
CProvider_Base::TNameAbbr& CProvider_Base::SetNameAbbr(void)
{
#ifdef _DEBUG
    if (!IsSetNameAbbr()) {
        m_NameAbbr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_NameAbbr;
}

inline
bool CProvider_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CProvider_Base::CanGetId(void) const
{
    return true;
}

inline
const CProvider_Base::TId& CProvider_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CProvider_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CProvider_Base::TId& CProvider_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CProvider_Base::IsSetUrl(void) const
{
    return m_Url.NotEmpty();
}

inline
bool CProvider_Base::CanGetUrl(void) const
{
    return true;
}

inline
const CProvider_Base::TUrl& CProvider_Base::GetUrl(void) const
{
    if ( !m_Url ) {
        const_cast<CProvider_Base*>(this)->ResetUrl();
    }
    return (*m_Url);
}

inline
CProvider_Base::TUrl& CProvider_Base::SetUrl(void)
{
    if ( !m_Url ) {
        ResetUrl();
    }
    return (*m_Url);
}

inline
bool CProvider_Base::IsSetIconUrl(void) const
{
    return m_IconUrl.NotEmpty();
}

inline
bool CProvider_Base::CanGetIconUrl(void) const
{
    return IsSetIconUrl();
}

inline
const CProvider_Base::TIconUrl& CProvider_Base::GetIconUrl(void) const
{
    if (!CanGetIconUrl()) {
        ThrowUnassigned(4);
    }
    return (*m_IconUrl);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_PROVIDER_BASE_HPP
