/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file LinkSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_LINKSET_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_LINKSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CIdCheckList;
class CIdList;
class CIdUrlList;
class CLinkSetDb;
class CLinkSetDbHistory;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Common 
class NCBI_EUTILS_EXPORT CLinkSet_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CLinkSet_Base(void);
    // destructor
    virtual ~CLinkSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_Data : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_EUTILS_EXPORT C_IE : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_IE(void);
            // destructor
            ~C_IE(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            /////////////////////////////////////////////////////////////////////////////
            class NCBI_EUTILS_EXPORT C_EL_2 : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_EL_2(void);
                // destructor
                ~C_EL_2(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                /////////////////////////////////////////////////////////////////////////////
                class NCBI_EUTILS_EXPORT C_EL : public NCBI_NS_NCBI::CSerialObject
                {
                    typedef NCBI_NS_NCBI::CSerialObject Tparent;
                public:
                    // constructor
                    C_EL(void);
                    // destructor
                    ~C_EL(void);
                
                    // type info
                    DECLARE_INTERNAL_TYPE_INFO();
                
                    /////////////////////////////////////////////////////////////////////////////
                    class NCBI_EUTILS_EXPORT C_E_EL : public NCBI_NS_NCBI::CSerialObject
                    {
                        typedef NCBI_NS_NCBI::CSerialObject Tparent;
                    public:
                        // constructor
                        C_E_EL(void);
                        // destructor
                        ~C_E_EL(void);
                    
                        // type info
                        DECLARE_INTERNAL_TYPE_INFO();
                    
                        // types
                        typedef NCBI_NS_STD::string TERROR;
                        typedef CLinkSetDb TLinkSetDb;
                    
                        // member index
                        enum class E_memberIndex {
                            e__allMandatory = 0,
                            e_ERROR,
                            e_LinkSetDb
                        };
                        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
                    
                        // getters
                        // setters
                    
                        /// .+ 
                        /// optional
                        /// typedef NCBI_NS_STD::string TERROR
                        ///  Check whether the ERROR data member has been assigned a value.
                        bool IsSetERROR(void) const;
                        /// Check whether it is safe or not to call GetERROR method.
                        bool CanGetERROR(void) const;
                        void ResetERROR(void);
                        const TERROR& GetERROR(void) const;
                        void SetERROR(const TERROR& value);
                        void SetERROR(TERROR&& value);
                        TERROR& SetERROR(void);
                    
                        /// mandatory
                        /// typedef CLinkSetDb TLinkSetDb
                        ///  Check whether the LinkSetDb data member has been assigned a value.
                        bool IsSetLinkSetDb(void) const;
                        /// Check whether it is safe or not to call GetLinkSetDb method.
                        bool CanGetLinkSetDb(void) const;
                        void ResetLinkSetDb(void);
                        const TLinkSetDb& GetLinkSetDb(void) const;
                        void SetLinkSetDb(TLinkSetDb& value);
                        TLinkSetDb& SetLinkSetDb(void);
                    
                        /// Reset the whole object
                        void Reset(void);
                    
                    
                    private:
                        // Prohibit copy constructor and assignment operator
                        C_E_EL(const C_E_EL&);
                        C_E_EL& operator=(const C_E_EL&);
                    
                        // data
                        Uint4 m_set_State[1];
                        NCBI_NS_STD::string m_ERROR;
                        NCBI_NS_NCBI::CRef< TLinkSetDb > m_LinkSetDb;
                    };
                    // types
                    typedef C_E_EL C_E;
                    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_EL > > TEL;
                
                    // member index
                    enum class E_memberIndex {
                        e__allMandatory = 0,
                        e_EL
                    };
                    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
                
                    // getters
                    // setters
                
                    /// optional
                    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_EL > > TEL
                    ///  Check whether the EL data member has been assigned a value.
                    bool IsSetEL(void) const;
                    /// Check whether it is safe or not to call GetEL method.
                    bool CanGetEL(void) const;
                    void ResetEL(void);
                    const TEL& GetEL(void) const;
                    TEL& SetEL(void);
                
                    /// Reset the whole object
                    void Reset(void);
                
                
                private:
                    // Prohibit copy constructor and assignment operator
                    C_EL(const C_EL&);
                    C_EL& operator=(const C_EL&);
                
                    // data
                    Uint4 m_set_State[1];
                    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_EL > > m_EL;
                };
                /////////////////////////////////////////////////////////////////////////////
                class NCBI_EUTILS_EXPORT C_LW : public NCBI_NS_NCBI::CSerialObject
                {
                    typedef NCBI_NS_NCBI::CSerialObject Tparent;
                public:
                    // constructor
                    C_LW(void);
                    // destructor
                    ~C_LW(void);
                
                    // type info
                    DECLARE_INTERNAL_TYPE_INFO();
                
                    // types
                    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkSetDbHistory > > TLinkSetDbHistory;
                    typedef NCBI_NS_STD::string TWebEnv;
                
                    // member index
                    enum class E_memberIndex {
                        e__allMandatory = 0,
                        e_LinkSetDbHistory,
                        e_WebEnv
                    };
                    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
                
                    // getters
                    // setters
                
                    /// optional
                    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkSetDbHistory > > TLinkSetDbHistory
                    ///  Check whether the LinkSetDbHistory data member has been assigned a value.
                    bool IsSetLinkSetDbHistory(void) const;
                    /// Check whether it is safe or not to call GetLinkSetDbHistory method.
                    bool CanGetLinkSetDbHistory(void) const;
                    void ResetLinkSetDbHistory(void);
                    const TLinkSetDbHistory& GetLinkSetDbHistory(void) const;
                    TLinkSetDbHistory& SetLinkSetDbHistory(void);
                
                    /// \S+ 
                    /// mandatory
                    /// typedef NCBI_NS_STD::string TWebEnv
                    ///  Check whether the WebEnv data member has been assigned a value.
                    bool IsSetWebEnv(void) const;
                    /// Check whether it is safe or not to call GetWebEnv method.
                    bool CanGetWebEnv(void) const;
                    void ResetWebEnv(void);
                    const TWebEnv& GetWebEnv(void) const;
                    void SetWebEnv(const TWebEnv& value);
                    void SetWebEnv(TWebEnv&& value);
                    TWebEnv& SetWebEnv(void);
                
                    /// Reset the whole object
                    void Reset(void);
                
                
                private:
                    // Prohibit copy constructor and assignment operator
                    C_LW(const C_LW&);
                    C_LW& operator=(const C_LW&);
                
                    // data
                    Uint4 m_set_State[1];
                    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkSetDbHistory > > m_LinkSetDbHistory;
                    NCBI_NS_STD::string m_WebEnv;
                };
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_EL,
                    e_LW
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 3 ///< == e_LW+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef C_EL TEL;
                typedef C_LW TLW;
            
                // getters
                // setters
            
                // typedef C_EL TEL
                bool IsEL(void) const;
                const TEL& GetEL(void) const;
                TEL& SetEL(void);
                void SetEL(TEL& value);
            
                // typedef C_LW TLW
                bool IsLW(void) const;
                const TLW& GetLW(void) const;
                TLW& SetLW(void);
                void SetLW(TLW& value);
            
            
            private:
                // copy constructor and assignment operator
                C_EL_2(const C_EL_2& );
                C_EL_2& operator=(const C_EL_2& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            // types
            typedef CIdList TIdList;
            typedef C_EL_2 TEL_2;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_IdList,
                e_EL_2
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// optional
            /// typedef CIdList TIdList
            ///  Check whether the IdList data member has been assigned a value.
            bool IsSetIdList(void) const;
            /// Check whether it is safe or not to call GetIdList method.
            bool CanGetIdList(void) const;
            void ResetIdList(void);
            const TIdList& GetIdList(void) const;
            void SetIdList(TIdList& value);
            TIdList& SetIdList(void);
        
            /// mandatory
            /// typedef C_EL_2 TEL_2
            ///  Check whether the EL_2 data member has been assigned a value.
            bool IsSetEL_2(void) const;
            /// Check whether it is safe or not to call GetEL_2 method.
            bool CanGetEL_2(void) const;
            void ResetEL_2(void);
            const TEL_2& GetEL_2(void) const;
            void SetEL_2(TEL_2& value);
            TEL_2& SetEL_2(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_IE(const C_IE&);
            C_IE& operator=(const C_IE&);
        
            // data
            Uint4 m_set_State[1];
            NCBI_NS_NCBI::CRef< TIdList > m_IdList;
            NCBI_NS_NCBI::CRef< TEL_2 > m_EL_2;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_IE,
            e_IdUrlList,
            e_IdCheckList,
            e_ERROR         ///< .+ 
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 5 ///< == e_ERROR+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef C_IE TIE;
        typedef CIdUrlList TIdUrlList;
        typedef CIdCheckList TIdCheckList;
        typedef NCBI_NS_STD::string TERROR;
    
        // getters
        // setters
    
        // typedef C_IE TIE
        bool IsIE(void) const;
        const TIE& GetIE(void) const;
        TIE& SetIE(void);
        void SetIE(TIE& value);
    
        // typedef CIdUrlList TIdUrlList
        bool IsIdUrlList(void) const;
        const TIdUrlList& GetIdUrlList(void) const;
        TIdUrlList& SetIdUrlList(void);
        void SetIdUrlList(TIdUrlList& value);
    
        // typedef CIdCheckList TIdCheckList
        bool IsIdCheckList(void) const;
        const TIdCheckList& GetIdCheckList(void) const;
        TIdCheckList& SetIdCheckList(void);
        void SetIdCheckList(TIdCheckList& value);
    
        // typedef NCBI_NS_STD::string TERROR
        bool IsERROR(void) const;
        const TERROR& GetERROR(void) const;
        TERROR& SetERROR(void);
        void SetERROR(const TERROR& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef NCBI_NS_STD::string TDbFrom;
    typedef C_Data TData;
    typedef NCBI_NS_STD::string TERROR;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_DbFrom,
        e_IIIE,
        e_ERROR
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// \S+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDbFrom
    ///  Check whether the DbFrom data member has been assigned a value.
    bool IsSetDbFrom(void) const;
    /// Check whether it is safe or not to call GetDbFrom method.
    bool CanGetDbFrom(void) const;
    void ResetDbFrom(void);
    const TDbFrom& GetDbFrom(void) const;
    void SetDbFrom(const TDbFrom& value);
    void SetDbFrom(TDbFrom&& value);
    TDbFrom& SetDbFrom(void);

    /// mandatory
    /// typedef C_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::string TERROR
    ///  Check whether the ERROR data member has been assigned a value.
    bool IsSetERROR(void) const;
    /// Check whether it is safe or not to call GetERROR method.
    bool CanGetERROR(void) const;
    void ResetERROR(void);
    const TERROR& GetERROR(void) const;
    void SetERROR(const TERROR& value);
    void SetERROR(TERROR&& value);
    TERROR& SetERROR(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CLinkSet_Base(const CLinkSet_Base&);
    CLinkSet_Base& operator=(const CLinkSet_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_DbFrom;
    NCBI_NS_NCBI::CRef< TData > m_Data;
    NCBI_NS_STD::string m_ERROR;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::IsSetERROR(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::CanGetERROR(void) const
{
    return IsSetERROR();
}

inline
const CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::TERROR& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::GetERROR(void) const
{
    if (!CanGetERROR()) {
        ThrowUnassigned(0);
    }
    return m_ERROR;
}

inline
void CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::SetERROR(const CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::TERROR& value)
{
    m_ERROR = value;
    m_set_State[0] |= 0x3;
}

inline
void CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::SetERROR(CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::TERROR&& value)
{
    m_ERROR = std::forward<CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::TERROR>(value);
    m_set_State[0] |= 0x3;
}

inline
CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::TERROR& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::SetERROR(void)
{
#ifdef _DEBUG
    if (!IsSetERROR()) {
        m_ERROR = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_ERROR;
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::IsSetLinkSetDb(void) const
{
    return m_LinkSetDb.NotEmpty();
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::CanGetLinkSetDb(void) const
{
    return true;
}

inline
const CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::TLinkSetDb& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::GetLinkSetDb(void) const
{
    if ( !m_LinkSetDb ) {
        const_cast<C_E_EL*>(this)->ResetLinkSetDb();
    }
    return (*m_LinkSetDb);
}

inline
CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::TLinkSetDb& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::C_E_EL::SetLinkSetDb(void)
{
    if ( !m_LinkSetDb ) {
        ResetLinkSetDb();
    }
    return (*m_LinkSetDb);
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::IsSetEL(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::CanGetEL(void) const
{
    return true;
}

inline
const CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::TEL& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::GetEL(void) const
{
    return m_EL;
}

inline
CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::TEL& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_EL::SetEL(void)
{
    m_set_State[0] |= 0x1;
    return m_EL;
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::IsSetLinkSetDbHistory(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::CanGetLinkSetDbHistory(void) const
{
    return true;
}

inline
const CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::TLinkSetDbHistory& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::GetLinkSetDbHistory(void) const
{
    return m_LinkSetDbHistory;
}

inline
CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::TLinkSetDbHistory& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::SetLinkSetDbHistory(void)
{
    m_set_State[0] |= 0x1;
    return m_LinkSetDbHistory;
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::IsSetWebEnv(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::CanGetWebEnv(void) const
{
    return IsSetWebEnv();
}

inline
const CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::TWebEnv& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::GetWebEnv(void) const
{
    if (!CanGetWebEnv()) {
        ThrowUnassigned(1);
    }
    return m_WebEnv;
}

inline
void CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::SetWebEnv(const CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::TWebEnv& value)
{
    m_WebEnv = value;
    m_set_State[0] |= 0xc;
}

inline
void CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::SetWebEnv(CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::TWebEnv&& value)
{
    m_WebEnv = std::forward<CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::TWebEnv>(value);
    m_set_State[0] |= 0xc;
}

inline
CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::TWebEnv& CLinkSet_Base::C_Data::C_IE::C_EL_2::C_LW::SetWebEnv(void)
{
#ifdef _DEBUG
    if (!IsSetWebEnv()) {
        m_WebEnv = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_WebEnv;
}

inline
CLinkSet_Base::C_Data::C_IE::C_EL_2::E_Choice CLinkSet_Base::C_Data::C_IE::C_EL_2::Which(void) const
{
    return m_choice;
}

inline
void CLinkSet_Base::C_Data::C_IE::C_EL_2::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CLinkSet_Base::C_Data::C_IE::C_EL_2::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CLinkSet_Base::C_Data::C_IE::C_EL_2::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::IsEL(void) const
{
    return m_choice == e_EL;
}

inline
bool CLinkSet_Base::C_Data::C_IE::C_EL_2::IsLW(void) const
{
    return m_choice == e_LW;
}

inline
bool CLinkSet_Base::C_Data::C_IE::IsSetIdList(void) const
{
    return m_IdList.NotEmpty();
}

inline
bool CLinkSet_Base::C_Data::C_IE::CanGetIdList(void) const
{
    return IsSetIdList();
}

inline
const CLinkSet_Base::C_Data::C_IE::TIdList& CLinkSet_Base::C_Data::C_IE::GetIdList(void) const
{
    if (!CanGetIdList()) {
        ThrowUnassigned(0);
    }
    return (*m_IdList);
}

inline
bool CLinkSet_Base::C_Data::C_IE::IsSetEL_2(void) const
{
    return m_EL_2.NotEmpty();
}

inline
bool CLinkSet_Base::C_Data::C_IE::CanGetEL_2(void) const
{
    return true;
}

inline
const CLinkSet_Base::C_Data::C_IE::TEL_2& CLinkSet_Base::C_Data::C_IE::GetEL_2(void) const
{
    if ( !m_EL_2 ) {
        const_cast<C_IE*>(this)->ResetEL_2();
    }
    return (*m_EL_2);
}

inline
CLinkSet_Base::C_Data::C_IE::TEL_2& CLinkSet_Base::C_Data::C_IE::SetEL_2(void)
{
    if ( !m_EL_2 ) {
        ResetEL_2();
    }
    return (*m_EL_2);
}

inline
CLinkSet_Base::C_Data::E_Choice CLinkSet_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CLinkSet_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CLinkSet_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CLinkSet_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CLinkSet_Base::C_Data::IsIE(void) const
{
    return m_choice == e_IE;
}

inline
bool CLinkSet_Base::C_Data::IsIdUrlList(void) const
{
    return m_choice == e_IdUrlList;
}

inline
bool CLinkSet_Base::C_Data::IsIdCheckList(void) const
{
    return m_choice == e_IdCheckList;
}

inline
bool CLinkSet_Base::C_Data::IsERROR(void) const
{
    return m_choice == e_ERROR;
}

inline
const CLinkSet_Base::C_Data::TERROR& CLinkSet_Base::C_Data::GetERROR(void) const
{
    CheckSelected(e_ERROR);
    return *m_string;
}

inline
CLinkSet_Base::C_Data::TERROR& CLinkSet_Base::C_Data::SetERROR(void)
{
    Select(e_ERROR, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CLinkSet_Base::IsSetDbFrom(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLinkSet_Base::CanGetDbFrom(void) const
{
    return IsSetDbFrom();
}

inline
const CLinkSet_Base::TDbFrom& CLinkSet_Base::GetDbFrom(void) const
{
    if (!CanGetDbFrom()) {
        ThrowUnassigned(0);
    }
    return m_DbFrom;
}

inline
void CLinkSet_Base::SetDbFrom(const CLinkSet_Base::TDbFrom& value)
{
    m_DbFrom = value;
    m_set_State[0] |= 0x3;
}

inline
void CLinkSet_Base::SetDbFrom(CLinkSet_Base::TDbFrom&& value)
{
    m_DbFrom = std::forward<CLinkSet_Base::TDbFrom>(value);
    m_set_State[0] |= 0x3;
}

inline
CLinkSet_Base::TDbFrom& CLinkSet_Base::SetDbFrom(void)
{
#ifdef _DEBUG
    if (!IsSetDbFrom()) {
        m_DbFrom = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_DbFrom;
}

inline
bool CLinkSet_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CLinkSet_Base::CanGetData(void) const
{
    return true;
}

inline
const CLinkSet_Base::TData& CLinkSet_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CLinkSet_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CLinkSet_Base::TData& CLinkSet_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

inline
bool CLinkSet_Base::IsSetERROR(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CLinkSet_Base::CanGetERROR(void) const
{
    return IsSetERROR();
}

inline
const CLinkSet_Base::TERROR& CLinkSet_Base::GetERROR(void) const
{
    if (!CanGetERROR()) {
        ThrowUnassigned(2);
    }
    return m_ERROR;
}

inline
void CLinkSet_Base::SetERROR(const CLinkSet_Base::TERROR& value)
{
    m_ERROR = value;
    m_set_State[0] |= 0x30;
}

inline
void CLinkSet_Base::SetERROR(CLinkSet_Base::TERROR&& value)
{
    m_ERROR = std::forward<CLinkSet_Base::TERROR>(value);
    m_set_State[0] |= 0x30;
}

inline
CLinkSet_Base::TERROR& CLinkSet_Base::SetERROR(void)
{
#ifdef _DEBUG
    if (!IsSetERROR()) {
        m_ERROR = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_ERROR;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_LINKSET_BASE_HPP
