/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_ID_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// \d+ 
class NCBI_EUTILS_EXPORT CId_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CId_Base(void);
    // destructor
    virtual ~CId_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_HasLinkOut {
            eAttlist_HasLinkOut_Y = 1,
            eAttlist_HasLinkOut_N = 2
        };
        
        /// Access to EAttlist_HasLinkOut's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_HasLinkOut)(void);
        
        enum EAttlist_HasNeighbor {
            eAttlist_HasNeighbor_Y = 1,
            eAttlist_HasNeighbor_N = 2
        };
        
        /// Access to EAttlist_HasNeighbor's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_HasNeighbor)(void);
        
        // types
        typedef EAttlist_HasLinkOut THasLinkOut;
        typedef EAttlist_HasNeighbor THasNeighbor;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_HasLinkOut,
            e_HasNeighbor
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef EAttlist_HasLinkOut THasLinkOut
        ///  Check whether the HasLinkOut data member has been assigned a value.
        bool IsSetHasLinkOut(void) const;
        /// Check whether it is safe or not to call GetHasLinkOut method.
        bool CanGetHasLinkOut(void) const;
        void ResetHasLinkOut(void);
        THasLinkOut GetHasLinkOut(void) const;
        void SetHasLinkOut(THasLinkOut value);
        THasLinkOut& SetHasLinkOut(void);
    
        /// optional
        /// typedef EAttlist_HasNeighbor THasNeighbor
        ///  Check whether the HasNeighbor data member has been assigned a value.
        bool IsSetHasNeighbor(void) const;
        /// Check whether it is safe or not to call GetHasNeighbor method.
        bool CanGetHasNeighbor(void) const;
        void ResetHasNeighbor(void);
        THasNeighbor GetHasNeighbor(void) const;
        void SetHasNeighbor(THasNeighbor value);
        THasNeighbor& SetHasNeighbor(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_HasLinkOut m_HasLinkOut;
        EAttlist_HasNeighbor m_HasNeighbor;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TId;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    void SetId(TId&& value);
    TId& SetId(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CId_Base(const CId_Base&);
    CId_Base& operator=(const CId_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_Id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CId_Base::C_Attlist::IsSetHasLinkOut(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CId_Base::C_Attlist::CanGetHasLinkOut(void) const
{
    return IsSetHasLinkOut();
}

inline
void CId_Base::C_Attlist::ResetHasLinkOut(void)
{
    m_HasLinkOut = (EAttlist_HasLinkOut)(0);
    m_set_State[0] &= ~0x3;
}

inline
CId_Base::C_Attlist::THasLinkOut CId_Base::C_Attlist::GetHasLinkOut(void) const
{
    if (!CanGetHasLinkOut()) {
        ThrowUnassigned(0);
    }
    return m_HasLinkOut;
}

inline
void CId_Base::C_Attlist::SetHasLinkOut(CId_Base::C_Attlist::THasLinkOut value)
{
    m_HasLinkOut = value;
    m_set_State[0] |= 0x3;
}

inline
CId_Base::C_Attlist::THasLinkOut& CId_Base::C_Attlist::SetHasLinkOut(void)
{
#ifdef _DEBUG
    if (!IsSetHasLinkOut()) {
        memset(&m_HasLinkOut,UnassignedByte(),sizeof(m_HasLinkOut));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_HasLinkOut;
}

inline
bool CId_Base::C_Attlist::IsSetHasNeighbor(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CId_Base::C_Attlist::CanGetHasNeighbor(void) const
{
    return IsSetHasNeighbor();
}

inline
void CId_Base::C_Attlist::ResetHasNeighbor(void)
{
    m_HasNeighbor = (EAttlist_HasNeighbor)(0);
    m_set_State[0] &= ~0xc;
}

inline
CId_Base::C_Attlist::THasNeighbor CId_Base::C_Attlist::GetHasNeighbor(void) const
{
    if (!CanGetHasNeighbor()) {
        ThrowUnassigned(1);
    }
    return m_HasNeighbor;
}

inline
void CId_Base::C_Attlist::SetHasNeighbor(CId_Base::C_Attlist::THasNeighbor value)
{
    m_HasNeighbor = value;
    m_set_State[0] |= 0xc;
}

inline
CId_Base::C_Attlist::THasNeighbor& CId_Base::C_Attlist::SetHasNeighbor(void)
{
#ifdef _DEBUG
    if (!IsSetHasNeighbor()) {
        memset(&m_HasNeighbor,UnassignedByte(),sizeof(m_HasNeighbor));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_HasNeighbor;
}

inline
bool CId_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CId_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CId_Base::TAttlist& CId_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CId_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CId_Base::TAttlist& CId_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CId_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CId_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CId_Base::TId& CId_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(1);
    }
    return m_Id;
}

inline
void CId_Base::SetId(const CId_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0xc;
}

inline
void CId_Base::SetId(CId_Base::TId&& value)
{
    m_Id = std::forward<CId_Base::TId>(value);
    m_set_State[0] |= 0xc;
}

inline
CId_Base::TId& CId_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_ID_BASE_HPP
