/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Link_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'einfo.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef einfo__OBJTOOLS_EUTILS_EINFO_LINK_BASE_HPP
#define einfo__OBJTOOLS_EUTILS_EINFO_LINK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_einfo_SCOPE
#  define BEGIN_einfo_SCOPE BEGIN_SCOPE(einfo)
#  define END_einfo_SCOPE END_SCOPE(einfo)
#endif
BEGIN_einfo_SCOPE // namespace einfo::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CLink_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CLink_Base(void);
    // destructor
    virtual ~CLink_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TName;
    typedef NCBI_NS_STD::string TMenu;
    typedef NCBI_NS_STD::string TDescription;
    typedef NCBI_NS_STD::string TDbTo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Name,
        e_Menu,
        e_Description,
        e_DbTo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TMenu
    ///  Check whether the Menu data member has been assigned a value.
    bool IsSetMenu(void) const;
    /// Check whether it is safe or not to call GetMenu method.
    bool CanGetMenu(void) const;
    void ResetMenu(void);
    const TMenu& GetMenu(void) const;
    void SetMenu(const TMenu& value);
    void SetMenu(TMenu&& value);
    TMenu& SetMenu(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// \S+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDbTo
    ///  Check whether the DbTo data member has been assigned a value.
    bool IsSetDbTo(void) const;
    /// Check whether it is safe or not to call GetDbTo method.
    bool CanGetDbTo(void) const;
    void ResetDbTo(void);
    const TDbTo& GetDbTo(void) const;
    void SetDbTo(const TDbTo& value);
    void SetDbTo(TDbTo&& value);
    TDbTo& SetDbTo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CLink_Base(const CLink_Base&);
    CLink_Base& operator=(const CLink_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_Name;
    NCBI_NS_STD::string m_Menu;
    NCBI_NS_STD::string m_Description;
    NCBI_NS_STD::string m_DbTo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CLink_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLink_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CLink_Base::TName& CLink_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CLink_Base::SetName(const CLink_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CLink_Base::SetName(CLink_Base::TName&& value)
{
    m_Name = std::forward<CLink_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CLink_Base::TName& CLink_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CLink_Base::IsSetMenu(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CLink_Base::CanGetMenu(void) const
{
    return IsSetMenu();
}

inline
const CLink_Base::TMenu& CLink_Base::GetMenu(void) const
{
    if (!CanGetMenu()) {
        ThrowUnassigned(1);
    }
    return m_Menu;
}

inline
void CLink_Base::SetMenu(const CLink_Base::TMenu& value)
{
    m_Menu = value;
    m_set_State[0] |= 0xc;
}

inline
void CLink_Base::SetMenu(CLink_Base::TMenu&& value)
{
    m_Menu = std::forward<CLink_Base::TMenu>(value);
    m_set_State[0] |= 0xc;
}

inline
CLink_Base::TMenu& CLink_Base::SetMenu(void)
{
#ifdef _DEBUG
    if (!IsSetMenu()) {
        m_Menu = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Menu;
}

inline
bool CLink_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CLink_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CLink_Base::TDescription& CLink_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(2);
    }
    return m_Description;
}

inline
void CLink_Base::SetDescription(const CLink_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0x30;
}

inline
void CLink_Base::SetDescription(CLink_Base::TDescription&& value)
{
    m_Description = std::forward<CLink_Base::TDescription>(value);
    m_set_State[0] |= 0x30;
}

inline
CLink_Base::TDescription& CLink_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Description;
}

inline
bool CLink_Base::IsSetDbTo(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CLink_Base::CanGetDbTo(void) const
{
    return IsSetDbTo();
}

inline
const CLink_Base::TDbTo& CLink_Base::GetDbTo(void) const
{
    if (!CanGetDbTo()) {
        ThrowUnassigned(3);
    }
    return m_DbTo;
}

inline
void CLink_Base::SetDbTo(const CLink_Base::TDbTo& value)
{
    m_DbTo = value;
    m_set_State[0] |= 0xc0;
}

inline
void CLink_Base::SetDbTo(CLink_Base::TDbTo&& value)
{
    m_DbTo = std::forward<CLink_Base::TDbTo>(value);
    m_set_State[0] |= 0xc0;
}

inline
CLink_Base::TDbTo& CLink_Base::SetDbTo(void)
{
#ifdef _DEBUG
    if (!IsSetDbTo()) {
        m_DbTo = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_DbTo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_einfo_SCOPE // namespace einfo::


#endif // einfo__OBJTOOLS_EUTILS_EINFO_LINK_BASE_HPP
