/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EInfoResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'einfo.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef einfo__OBJTOOLS_EUTILS_EINFO_EINFORESULT_BASE_HPP
#define einfo__OBJTOOLS_EUTILS_EINFO_EINFORESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_einfo_SCOPE
#  define BEGIN_einfo_SCOPE BEGIN_SCOPE(einfo)
#  define END_einfo_SCOPE END_SCOPE(einfo)
#endif
BEGIN_einfo_SCOPE // namespace einfo::


// forward declarations
class CDbInfo;
class CDbList;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CEInfoResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CEInfoResult_Base(void);
    // destructor
    virtual ~CEInfoResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_DbList,
        e_DbInfo,
        e_ERROR         ///< .+ 
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_ERROR+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static NCBI_NS_STD::string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                NCBI_NS_NCBI::EResetVariant reset,
                NCBI_NS_NCBI::CObjectMemoryPool* pool);

    // types
    typedef CDbList TDbList;
    typedef CDbInfo TDbInfo;
    typedef NCBI_NS_STD::string TERROR;

    // getters
    // setters

    // typedef CDbList TDbList
    bool IsDbList(void) const;
    const TDbList& GetDbList(void) const;
    TDbList& SetDbList(void);
    void SetDbList(TDbList& value);

    // typedef CDbInfo TDbInfo
    bool IsDbInfo(void) const;
    const TDbInfo& GetDbInfo(void) const;
    TDbInfo& SetDbInfo(void);
    void SetDbInfo(TDbInfo& value);

    // typedef NCBI_NS_STD::string TERROR
    bool IsERROR(void) const;
    const TERROR& GetERROR(void) const;
    TERROR& SetERROR(void);
    void SetERROR(const TERROR& value);


private:
    // copy constructor and assignment operator
    CEInfoResult_Base(const CEInfoResult_Base& );
    CEInfoResult_Base& operator=(const CEInfoResult_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CEInfoResult_Base::E_Choice CEInfoResult_Base::Which(void) const
{
    return m_choice;
}

inline
void CEInfoResult_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CEInfoResult_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CEInfoResult_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CEInfoResult_Base::IsDbList(void) const
{
    return m_choice == e_DbList;
}

inline
bool CEInfoResult_Base::IsDbInfo(void) const
{
    return m_choice == e_DbInfo;
}

inline
bool CEInfoResult_Base::IsERROR(void) const
{
    return m_choice == e_ERROR;
}

inline
const CEInfoResult_Base::TERROR& CEInfoResult_Base::GetERROR(void) const
{
    CheckSelected(e_ERROR);
    return *m_string;
}

inline
CEInfoResult_Base::TERROR& CEInfoResult_Base::SetERROR(void)
{
    Select(e_ERROR, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_einfo_SCOPE // namespace einfo::


#endif // einfo__OBJTOOLS_EUTILS_EINFO_EINFORESULT_BASE_HPP
