/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EGQueryResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'egquery.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef egquery__OBJTOOLS_EUTILS_EGQUERY_EGQUERYRESULT_BASE_HPP
#define egquery__OBJTOOLS_EUTILS_EGQUERY_EGQUERYRESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_egquery_SCOPE
#  define BEGIN_egquery_SCOPE BEGIN_SCOPE(egquery)
#  define END_egquery_SCOPE END_SCOPE(egquery)
#endif
BEGIN_egquery_SCOPE // namespace egquery::


// forward declarations
class CResultItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CEGQueryResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CEGQueryResult_Base(void);
    // destructor
    virtual ~CEGQueryResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CResultItem C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CResultItem > > TResultItem;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_ResultItem
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CResultItem > > TResultItem
    ///  Check whether the ResultItem data member has been assigned a value.
    bool IsSetResultItem(void) const;
    /// Check whether it is safe or not to call GetResultItem method.
    bool CanGetResultItem(void) const;
    void ResetResultItem(void);
    const TResultItem& GetResultItem(void) const;
    TResultItem& SetResultItem(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEGQueryResult_Base(const CEGQueryResult_Base&);
    CEGQueryResult_Base& operator=(const CEGQueryResult_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CResultItem > > m_ResultItem;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEGQueryResult_Base::IsSetResultItem(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEGQueryResult_Base::CanGetResultItem(void) const
{
    return true;
}

inline
const CEGQueryResult_Base::TResultItem& CEGQueryResult_Base::GetResultItem(void) const
{
    return m_ResultItem;
}

inline
CEGQueryResult_Base::TResultItem& CEGQueryResult_Base::SetResultItem(void)
{
    m_set_State[0] |= 0x1;
    return m_ResultItem;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_egquery_SCOPE // namespace egquery::


#endif // egquery__OBJTOOLS_EUTILS_EGQUERY_EGQUERYRESULT_BASE_HPP
